/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.ajp;

import java.util.Properties;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.http.HttpCodecFilter;
import org.glassfish.grizzly.http.ajp.AjpHandlerFilter;
import org.glassfish.grizzly.http.ajp.AjpMessageFilter;
import org.glassfish.grizzly.http.server.AddOn;
import org.glassfish.grizzly.http.server.HttpServerFilter;
import org.glassfish.grizzly.http.server.NetworkListener;

public class AjpAddOn
implements AddOn {
    private boolean isTomcatAuthentication = true;
    private String secret;

    public void configure(boolean isTomcatAuthentication, String secret) {
        this.isTomcatAuthentication = isTomcatAuthentication;
        this.secret = secret;
    }

    public void configure(Properties properties) {
        if (Boolean.parseBoolean(properties.getProperty("request.useSecret"))) {
            this.secret = Double.toString(Math.random());
        }
        this.secret = properties.getProperty("request.secret", this.secret);
        this.isTomcatAuthentication = Boolean.parseBoolean(properties.getProperty("tomcatAuthentication", "true"));
    }

    public boolean isTomcatAuthentication() {
        return this.isTomcatAuthentication;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setup(NetworkListener networkListener, FilterChainBuilder builder) {
        int idx;
        int httpCodecFilterIdx = builder.indexOfType(HttpCodecFilter.class);
        int httpServerFilterIdx = builder.indexOfType(HttpServerFilter.class);
        if (httpCodecFilterIdx >= 0) {
            builder.remove(httpCodecFilterIdx);
            idx = httpCodecFilterIdx;
        } else {
            idx = httpServerFilterIdx;
        }
        if (idx >= 0) {
            builder.add(idx, (Filter)this.createAjpMessageFilter());
            AjpHandlerFilter ajpHandlerFilter = this.createAjpHandlerFilter();
            ajpHandlerFilter.setSecret(this.secret);
            ajpHandlerFilter.setTomcatAuthentication(this.isTomcatAuthentication);
            builder.add(idx + 1, (Filter)ajpHandlerFilter);
        }
    }

    protected AjpHandlerFilter createAjpHandlerFilter() {
        return new AjpHandlerFilter();
    }

    protected AjpMessageFilter createAjpMessageFilter() {
        return new AjpMessageFilter();
    }
}

