/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.naming;

import com.sun.enterprise.naming.impl.SerialInitContextFactory;
import com.sun.enterprise.naming.util.LogFacade;
import jakarta.inject.Inject;
import java.lang.reflect.Field;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.InitialContextFactoryBuilder;
import javax.naming.spi.NamingManager;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.PreDestroy;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.jvnet.hk2.annotations.Service;

@Service
@RunLevel(value=1, mode=0)
public class GlassFishNamingBuilder
implements InitialContextFactoryBuilder,
PostConstruct,
PreDestroy {
    @LogMessageInfo(message="Failed to load {0} using CommonClassLoader")
    public static final String FAILED_TO_LOAD_CLASS = "AS-NAMING-00001";
    @LogMessageInfo(message="Fall back to INITIAL_CONTEXT_FACTORY {0}")
    private static final String FALL_BACK_INITIAL_CONTEXT_FACTORY = "AS-NAMING-00008";
    private static final String ALLOW_JNDI_FROM_OSGI = "com.sun.enterprise.naming.allowJndiLookupFromOSGi";
    @Inject
    private ServerContext serverContext;

    @Override
    public InitialContextFactory createInitialContextFactory(Hashtable<?, ?> environment) throws NamingException {
        String className;
        if (environment != null && (className = (String)environment.get("java.naming.factory.initial")) != null) {
            try {
                return (InitialContextFactory)this.loadClass(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                if (className.startsWith("weblogic.jndi")) {
                    LogFacade.logger.log(Level.INFO, FALL_BACK_INITIAL_CONTEXT_FACTORY, "com.sun.enterprise.naming.impl.SerialInitContextFactory");
                }
                NoInitialContextException ne = new NoInitialContextException("Cannot instantiate class: " + className);
                ne.setRootCause(e);
                throw ne;
            }
        }
        return new SerialInitContextFactory();
    }

    private Class<?> loadClass(String className) throws ClassNotFoundException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            return Class.forName(className, true, contextClassLoader);
        }
        catch (ClassNotFoundException e) {
            LogFacade.logger.logp(Level.FINE, "GlassFishNamingBuilder", "loadClass", "Failed to load {0} using thread context class loader {1}", new Object[]{className, contextClassLoader});
            ClassLoader commonClassLoader = this.serverContext.getCommonClassLoader();
            if (contextClassLoader != commonClassLoader) {
                try {
                    return Class.forName(className, true, commonClassLoader);
                }
                catch (ClassNotFoundException e2) {
                    LogFacade.logger.logp(Level.WARNING, "GlassFishNamingBuilder", "loadClass", FAILED_TO_LOAD_CLASS, new Object[]{className});
                    throw e2;
                }
            }
            throw e;
        }
    }

    public void postConstruct() {
        try {
            if (this.isUsingBuilder().booleanValue()) {
                NamingManager.setInitialContextFactoryBuilder(this);
            }
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    public void preDestroy() {
        if (this.isUsingBuilder().booleanValue()) {
            this.resetInitialContextFactoryBuilder();
        }
    }

    private void resetInitialContextFactoryBuilder() {
        try {
            Field initctxFactoryBuilderField = NamingManager.class.getDeclaredField("initctx_factory_builder");
            initctxFactoryBuilderField.setAccessible(true);
            initctxFactoryBuilderField.set(null, null);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private Boolean isUsingBuilder() {
        return Boolean.valueOf(System.getProperty(ALLOW_JNDI_FROM_OSGI, "true"));
    }
}

