/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.classfile;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.derby.iapi.services.classfile.ClassFormatOutput;
import org.apache.derby.iapi.services.classfile.ClassMember;
import org.apache.derby.iapi.services.classfile.MemberTableHash;

class MemberTable {
    protected Vector<ClassMember> entries;
    private Hashtable<MemberTableHash, MemberTableHash> hashtable;
    private MemberTableHash mutableMTH = null;

    public MemberTable(int n) {
        this.entries = new Vector(n);
        this.hashtable = new Hashtable(n > 50 ? n : 50);
        this.mutableMTH = new MemberTableHash(null, null);
    }

    void addEntry(ClassMember classMember) {
        MemberTableHash memberTableHash = new MemberTableHash(classMember.getName(), classMember.getDescriptor(), this.entries.size());
        this.entries.add(classMember);
        this.hashtable.put(memberTableHash, memberTableHash);
    }

    ClassMember find(String string, String string2) {
        this.mutableMTH.name = string;
        this.mutableMTH.descriptor = string2;
        this.mutableMTH.setHashCode();
        MemberTableHash memberTableHash = this.hashtable.get(this.mutableMTH);
        if (memberTableHash == null) {
            return null;
        }
        return this.entries.get(memberTableHash.index);
    }

    void put(ClassFormatOutput classFormatOutput) throws IOException {
        Vector<ClassMember> vector = this.entries;
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            vector.get(i).put(classFormatOutput);
        }
    }

    int size() {
        return this.entries.size();
    }

    int classFileSize() {
        int n = 0;
        Vector<ClassMember> vector = this.entries;
        int n2 = vector.size();
        for (int i = 0; i < n2; ++i) {
            n += vector.get(i).classFileSize();
        }
        return n;
    }
}

