/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal.inject;

import jakarta.ws.rs.ConstrainedTo;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Feature;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.glassfish.jersey.internal.LocalizationMessages;
import org.glassfish.jersey.internal.ServiceFinder;
import org.glassfish.jersey.internal.inject.Binder;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.inject.InjectionManagerFactory;
import org.glassfish.jersey.model.internal.RankedComparator;
import org.glassfish.jersey.model.internal.RankedProvider;

public class Injections {
    public static InjectionManager createInjectionManager() {
        return Injections.createInjectionManager(new EmptyConfiguration(RuntimeType.SERVER));
    }

    public static InjectionManager createInjectionManager(RuntimeType type) {
        return Injections.createInjectionManager(new EmptyConfiguration(type));
    }

    public static InjectionManager createInjectionManager(Configuration configuration) {
        return Injections.lookupInjectionManagerFactory(configuration.getRuntimeType()).create(null, configuration);
    }

    public static InjectionManager createInjectionManager(Binder binder) {
        InjectionManager injectionManager = Injections.createInjectionManager(RuntimeType.SERVER);
        injectionManager.register(binder);
        return injectionManager;
    }

    public static InjectionManager createInjectionManager(Object parent) {
        return Injections.createInjectionManager(parent, new EmptyConfiguration(RuntimeType.SERVER));
    }

    public static InjectionManager createInjectionManager(Object parent, Configuration configuration) {
        return Injections.lookupInjectionManagerFactory(configuration.getRuntimeType()).create(parent, configuration);
    }

    private static InjectionManagerFactory lookupInjectionManagerFactory(RuntimeType type) {
        return Injections.lookupService(InjectionManagerFactory.class, type).orElseThrow(() -> new IllegalStateException(LocalizationMessages.INJECTION_MANAGER_FACTORY_NOT_FOUND()));
    }

    private static <T> Optional<T> lookupService(Class<T> clazz, RuntimeType type) {
        LinkedList<RankedProvider<T>> providers = new LinkedList<RankedProvider<T>>();
        for (T provider : ServiceFinder.find(clazz)) {
            ConstrainedTo constrain = provider.getClass().getAnnotation(ConstrainedTo.class);
            if (constrain != null && type != constrain.value()) continue;
            providers.add(new RankedProvider<T>(provider));
        }
        providers.sort(new RankedComparator(RankedComparator.Order.DESCENDING));
        return providers.isEmpty() ? Optional.empty() : Optional.ofNullable(((RankedProvider)providers.get(0)).getProvider());
    }

    public static <T> T getOrCreate(InjectionManager injectionManager, Class<T> clazz) {
        try {
            T component = injectionManager.getInstance(clazz);
            return component == null ? injectionManager.createAndInitialize(clazz) : component;
        }
        catch (RuntimeException e) {
            Throwable throwable = e.getCause();
            if (throwable != null && WebApplicationException.class.isAssignableFrom(throwable.getClass())) {
                throw (WebApplicationException)throwable;
            }
            throw e;
        }
    }

    private static final class EmptyConfiguration
    implements Configuration {
        private final RuntimeType runtimeType;

        private EmptyConfiguration(RuntimeType runtimeType) {
            this.runtimeType = runtimeType;
        }

        public RuntimeType getRuntimeType() {
            return this.runtimeType;
        }

        public Map<String, Object> getProperties() {
            return Collections.emptyMap();
        }

        public Object getProperty(String name) {
            return this.getProperties().get(name);
        }

        public Collection<String> getPropertyNames() {
            return this.getProperties().keySet();
        }

        public boolean isEnabled(Feature feature) {
            return false;
        }

        public boolean isEnabled(Class<? extends Feature> featureClass) {
            return false;
        }

        public boolean isRegistered(Object component) {
            return false;
        }

        public boolean isRegistered(Class<?> componentClass) {
            return false;
        }

        public Map<Class<?>, Integer> getContracts(Class<?> componentClass) {
            return Collections.emptyMap();
        }

        public Set<Class<?>> getClasses() {
            return Collections.emptySet();
        }

        public Set<Object> getInstances() {
            return Collections.emptySet();
        }
    }
}

