/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class SingletonEnforcer {
    private static final ConcurrentMap<Class<?>, Object> mItems = new ConcurrentHashMap();

    private SingletonEnforcer() {
    }

    public static <T> T get(Class<T> theClass) {
        return theClass.cast(mItems.get(theClass));
    }

    public static void register(Class<?> theClass, Object theInstance) {
        if (mItems.putIfAbsent(theClass, theInstance) != null) {
            throw new IllegalArgumentException("Illegal to register more than one instance of " + theClass.getName());
        }
    }

    public static void deregister(Class<?> theClass, Object theInstance) {
        if (!mItems.remove(theClass, theInstance)) {
            throw new IllegalArgumentException("Cannot deregister the instance of " + theClass.getName());
        }
    }
}

