/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.dynamic.codegen.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import org.glassfish.pfl.dynamic.codegen.impl.BlockStatement;
import org.glassfish.pfl.dynamic.codegen.impl.CaseBranch;
import org.glassfish.pfl.dynamic.codegen.impl.ExpressionInternal;
import org.glassfish.pfl.dynamic.codegen.impl.Node;
import org.glassfish.pfl.dynamic.codegen.impl.StatementBase;
import org.glassfish.pfl.dynamic.codegen.impl.Visitor;

public final class SwitchStatement
extends StatementBase {
    private Map<Integer, CaseBranch> cases;
    private BlockStatement defaultCase;
    private ExpressionInternal expr;

    public Map<Integer, CaseBranch> cases() {
        return this.cases;
    }

    public BlockStatement defaultCase() {
        return this.defaultCase;
    }

    public ExpressionInternal expr() {
        return this.expr;
    }

    SwitchStatement(Node parent, ExpressionInternal expr) {
        super(parent);
        this.expr = expr;
        this.cases = new LinkedHashMap<Integer, CaseBranch>();
        this.defaultCase = new BlockStatement(this);
    }

    public CaseBranch addCase(int value) {
        if (this.cases.containsKey(value)) {
            throw new IllegalArgumentException("Switch already contains case " + value);
        }
        CaseBranch stmt = new CaseBranch(this, value);
        this.cases.put(value, stmt);
        return stmt;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitSwitchStatement(this);
    }
}

