/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.persistence.core.descriptors.CoreDescriptor;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.core.descriptors.CoreInstantiationPolicy;
import org.eclipse.persistence.internal.core.helper.CoreClassConstants;
import org.eclipse.persistence.internal.core.sessions.CoreAbstractSession;
import org.eclipse.persistence.internal.oxm.ConversionManager;
import org.eclipse.persistence.internal.oxm.MappingNodeValue;
import org.eclipse.persistence.internal.oxm.NamespaceResolver;
import org.eclipse.persistence.internal.oxm.ObjectBuilder;
import org.eclipse.persistence.internal.oxm.XMLRelationshipMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.mappings.CompositeObjectMapping;
import org.eclipse.persistence.internal.oxm.mappings.Descriptor;
import org.eclipse.persistence.internal.oxm.mappings.DirectMapping;
import org.eclipse.persistence.internal.oxm.mappings.Field;
import org.eclipse.persistence.internal.oxm.mappings.Mapping;
import org.eclipse.persistence.internal.oxm.mappings.UnmarshalKeepAsElementPolicy;
import org.eclipse.persistence.internal.oxm.mappings.VariableXPathObjectMapping;
import org.eclipse.persistence.internal.oxm.record.MarshalContext;
import org.eclipse.persistence.internal.oxm.record.MarshalRecord;
import org.eclipse.persistence.internal.oxm.record.UnmarshalRecord;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class XMLVariableXPathMappingNodeValue
extends XMLRelationshipMappingNodeValue {
    @Override
    public boolean isOwningNode(XPathFragment xPathFragment) {
        return null == xPathFragment;
    }

    @Override
    protected Descriptor findReferenceDescriptor(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord, Attributes atts, Mapping mapping, UnmarshalKeepAsElementPolicy policy) {
        return (Descriptor)mapping.getReferenceDescriptor();
    }

    @Override
    public void attribute(UnmarshalRecord unmarshalRecord, String namespaceURI, String localName, String value) {
        Descriptor referenceDescriptor = (Descriptor)this.getMapping().getReferenceDescriptor();
        ObjectBuilder treeObjectBuilder = (ObjectBuilder)referenceDescriptor.getObjectBuilder();
        MappingNodeValue textMappingNodeValue = (MappingNodeValue)treeObjectBuilder.getRootXPathNode().getTextNode().getNodeValue();
        Mapping textMapping = textMappingNodeValue.getMapping();
        Object childObject = ((CoreInstantiationPolicy)referenceDescriptor.getInstantiationPolicy()).buildNewInstance();
        if (textMapping.isAbstractDirectMapping()) {
            DirectMapping xmlDirectMapping = (DirectMapping)textMappingNodeValue.getMapping();
            Field xmlField = (Field)xmlDirectMapping.getField();
            Object realValue = unmarshalRecord.getXMLReader().convertValueBasedOnSchemaType(xmlField, value, (ConversionManager)((CoreAbstractSession)unmarshalRecord.getSession()).getDatasourcePlatform().getConversionManager(), unmarshalRecord);
            Object convertedValue = xmlDirectMapping.getAttributeValue(realValue, unmarshalRecord.getSession(), unmarshalRecord);
            xmlDirectMapping.setAttributeValueInObject(childObject, convertedValue);
        } else {
            Object oldChildObject = unmarshalRecord.getCurrentObject();
            CompositeObjectMapping nestedXMLCompositeObjectMapping = (CompositeObjectMapping)textMappingNodeValue.getMapping();
            unmarshalRecord.setCurrentObject(childObject);
            textMappingNodeValue.attribute(unmarshalRecord, namespaceURI, localName, value);
            unmarshalRecord.setCurrentObject(oldChildObject);
        }
        this.setXPathInObject(namespaceURI, localName, childObject);
        this.setOrAddAttributeValue(unmarshalRecord, childObject, null, null);
    }

    @Override
    public boolean marshalSingleValue(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, Object value, CoreAbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext) {
        Class<?> objectValueClass;
        if (null == value) {
            return false;
        }
        Object originalValue = value;
        VariableXPathObjectMapping mapping = this.getMapping();
        Descriptor descriptor = (Descriptor)mapping.getReferenceDescriptor();
        if (descriptor.hasInheritance() && (objectValueClass = value.getClass()) != descriptor.getJavaClass()) {
            descriptor = (Descriptor)session.getDescriptor(objectValueClass);
        }
        Object marshaller = marshalRecord.getMarshaller();
        ObjectBuilder objectBuilder = (ObjectBuilder)descriptor.getObjectBuilder();
        List extraNamespaces = objectBuilder.addExtraNamespacesToNamespaceResolver(descriptor, marshalRecord, session, true, true);
        String defaultRootElementString = descriptor.getDefaultRootElement();
        marshalRecord.beforeContainmentMarshal(value);
        XPathFragment rootFragment = mapping.getXPathFragmentForValue(value, (NamespaceResolver)marshalRecord.getNamespaceResolver(), marshalRecord.isNamespaceAware(), marshalRecord.getNamespaceSeparator());
        XPathFragment groupingFragment = marshalRecord.openStartGroupingElements(namespaceResolver);
        if (mapping.isAttribute()) {
            ObjectBuilder tob = (ObjectBuilder)((CoreDescriptor)mapping.getReferenceDescriptor()).getObjectBuilder();
            MappingNodeValue textMappingNodeValue = (MappingNodeValue)tob.getRootXPathNode().getTextNode().getMarshalNodeValue();
            Mapping textMapping = textMappingNodeValue.getMapping();
            if (textMapping.isAbstractDirectMapping()) {
                DirectMapping xmlDirectMapping = (DirectMapping)textMapping;
                Object fieldValue = xmlDirectMapping.getFieldValue(xmlDirectMapping.valueFromObject(value, xmlDirectMapping.getField(), session), session, marshalRecord);
                QName schemaType = ((Field)xmlDirectMapping.getField()).getSchemaTypeForValue(fieldValue, session);
                marshalRecord.attribute(rootFragment, namespaceResolver, fieldValue, schemaType);
                return true;
            }
            return textMappingNodeValue.marshalSingleValue(rootFragment, marshalRecord, value, textMapping.getAttributeValueFromObject(value), session, namespaceResolver, marshalContext);
        }
        marshalRecord.closeStartGroupingElements(groupingFragment);
        this.getXPathNode().startElement(marshalRecord, rootFragment, object, session, (NamespaceResolver)marshalRecord.getNamespaceResolver(), objectBuilder, value);
        this.writeExtraNamespaces(extraNamespaces, marshalRecord, session);
        marshalRecord.addXsiTypeAndClassIndicatorIfRequired(descriptor, (Descriptor)mapping.getReferenceDescriptor(), (Field)mapping.getField(), originalValue, value, false, false);
        objectBuilder.buildRow(marshalRecord, value, session, marshaller, null);
        marshalRecord.afterContainmentMarshal(object, value);
        marshalRecord.endElement(rootFragment, namespaceResolver);
        marshalRecord.removeExtraNamespacesFromNamespaceResolver(extraNamespaces, session);
        return true;
    }

    @Override
    public void endElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord) {
        UnmarshalRecord childRecord = unmarshalRecord.getChildRecord();
        if (childRecord != null) {
            Object childObject = childRecord.getCurrentObject();
            String localName = xPathFragment.getLocalName();
            this.setXPathInObject(xPathFragment.getNamespaceURI(), localName, childObject);
            childObject = this.getMapping().convertDataValueToObjectValue(childObject, unmarshalRecord.getSession(), unmarshalRecord.getUnmarshaller());
            this.setOrAddAttributeValue(unmarshalRecord, childObject, xPathFragment, null);
            unmarshalRecord.setChildRecord(null);
        } else {
            unmarshalRecord.resetStringBuffer();
        }
    }

    @Override
    public abstract VariableXPathObjectMapping getMapping();

    public void setXPathInObject(String uri, String localName, Object childObject) {
        Object variableAttributeAccessor = this.getMapping().getVariableAttributeAccessor();
        if (!variableAttributeAccessor.isWriteOnly()) {
            Object value = null;
            value = this.getMapping().getVariableAttributeAccessor().getAttributeClass() == CoreClassConstants.QNAME ? (uri != null && !uri.isEmpty() ? new QName(uri, localName) : new QName(localName)) : localName;
            variableAttributeAccessor.setAttributeValueInObject(childObject, value);
        }
    }

    @Override
    public boolean startElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord, Attributes atts) {
        try {
            this.processChild(xPathFragment, unmarshalRecord, atts, (Descriptor)this.getMapping().getReferenceDescriptor(), this.getMapping());
        }
        catch (SAXException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        return true;
    }

    @Override
    public boolean isMixedContentNodeValue() {
        return true;
    }
}

