/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionOperator;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.databaseaccess.FieldTypeDefinition;
import org.eclipse.persistence.internal.expressions.ExpressionJavaPrinter;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.ExtractOperator;
import org.eclipse.persistence.internal.expressions.FunctionExpression;
import org.eclipse.persistence.internal.expressions.RelationExpression;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.queries.ValueReadQuery;

public class SQLServerPlatform
extends DatabasePlatform {
    private static final int DATETIMEOFFSET_TYPE = -155;
    private boolean isVersion11OrHigher;
    private Boolean driverSupportsOffsetDateTime;
    private boolean isConnectionDataInitialized;

    public SQLServerPlatform() {
        this.pingSQL = "SELECT 1";
        this.storedProcedureTerminationToken = " go";
        this.supportsReturnGeneratedKeys = true;
    }

    @Override
    public Map<Object, Object> connectionProperties() {
        return Map.of("sendTimeAsDatetime", Boolean.FALSE.toString());
    }

    @Override
    public void initializeConnectionData(Connection connection) throws SQLException {
        if (this.isConnectionDataInitialized) {
            return;
        }
        DatabaseMetaData dmd = connection.getMetaData();
        boolean isMicrosoftDriver = dmd.getDriverName().startsWith("Microsoft JDBC Driver");
        int databaseVersion = dmd.getDatabaseMajorVersion();
        String driverVersion = dmd.getDriverVersion();
        boolean bl = this.isVersion11OrHigher = databaseVersion >= 11;
        if (this.driverSupportsOffsetDateTime == null) {
            this.driverSupportsOffsetDateTime = isMicrosoftDriver && Helper.compareVersions(driverVersion, "7.1.4") >= 0;
        }
        this.driverSupportsNationalCharacterVarying = isMicrosoftDriver && Helper.compareVersions(driverVersion, "4.0.0") >= 0;
        this.isConnectionDataInitialized = true;
    }

    public void setDriverSupportsOffsetDateTime(boolean driverSupportsOffsetDateTime) {
        this.driverSupportsOffsetDateTime = driverSupportsOffsetDateTime;
    }

    @Override
    protected void appendByteArray(byte[] bytes, Writer writer) throws IOException {
        if (this.usesNativeSQL() && !this.usesByteArrayBinding()) {
            writer.write("0x");
            Helper.writeHexString(bytes, writer);
        } else {
            super.appendByteArray(bytes, writer);
        }
    }

    @Override
    protected void appendDate(Date date, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("'");
            writer.write(Helper.printDate(date));
            writer.write("'");
        } else {
            super.appendDate(date, writer);
        }
    }

    protected void appendSybaseTimestamp(Timestamp timestamp, Writer writer) throws IOException {
        writer.write("'");
        writer.write(Helper.printTimestampWithoutNanos(timestamp));
        writer.write(58);
        String nanoString = Integer.toString(timestamp.getNanos());
        int numberOfZeros = 0;
        for (int num = Math.min(9 - nanoString.length(), 3); num > 0; --num) {
            writer.write(48);
            ++numberOfZeros;
        }
        if (nanoString.length() + numberOfZeros > 3) {
            nanoString = nanoString.substring(0, 3 - numberOfZeros);
        }
        writer.write(nanoString);
        writer.write("'");
    }

    protected void appendSybaseCalendar(Calendar calendar, Writer writer) throws IOException {
        writer.write("'");
        writer.write(Helper.printCalendar(calendar));
        writer.write("'");
    }

    @Override
    protected void appendTime(Time time, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("'");
            writer.write(Helper.printTime(time));
            writer.write("'");
        } else {
            super.appendTime(time, writer);
        }
    }

    @Override
    protected void appendTimestamp(Timestamp timestamp, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            this.appendSybaseTimestamp(timestamp, writer);
        } else {
            super.appendTimestamp(timestamp, writer);
        }
    }

    @Override
    protected void appendCalendar(Calendar calendar, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            this.appendSybaseCalendar(calendar, writer);
        } else {
            super.appendCalendar(calendar, writer);
        }
    }

    @Override
    protected Map<String, Class<?>> buildClassTypes() {
        Map<String, Class<?>> classTypeMapping = super.buildClassTypes();
        classTypeMapping.put("DATETIME2", Timestamp.class);
        return classTypeMapping;
    }

    @Override
    protected Hashtable<Class<?>, FieldTypeDefinition> buildFieldTypes() {
        Hashtable fieldTypeMapping = new Hashtable();
        fieldTypeMapping.put(Boolean.class, new FieldTypeDefinition("BIT default 0", false));
        fieldTypeMapping.put(Integer.class, new FieldTypeDefinition("INTEGER", false));
        fieldTypeMapping.put(Long.class, new FieldTypeDefinition("NUMERIC", 19));
        fieldTypeMapping.put(Float.class, new FieldTypeDefinition("FLOAT(16)", false));
        fieldTypeMapping.put(Double.class, new FieldTypeDefinition("FLOAT(32)", false));
        fieldTypeMapping.put(Short.class, new FieldTypeDefinition("SMALLINT", false));
        fieldTypeMapping.put(Byte.class, new FieldTypeDefinition("SMALLINT", false));
        fieldTypeMapping.put(BigInteger.class, new FieldTypeDefinition("NUMERIC", 28));
        fieldTypeMapping.put(BigDecimal.class, new FieldTypeDefinition("NUMERIC", 28).setLimits(28, -19, 19));
        fieldTypeMapping.put(Number.class, new FieldTypeDefinition("NUMERIC", 28).setLimits(28, -19, 19));
        if (this.getUseNationalCharacterVaryingTypeForString()) {
            fieldTypeMapping.put(String.class, new FieldTypeDefinition("NVARCHAR", 255));
        } else {
            fieldTypeMapping.put(String.class, new FieldTypeDefinition("VARCHAR", 255));
        }
        fieldTypeMapping.put(Character.class, new FieldTypeDefinition("CHAR", 1));
        fieldTypeMapping.put(Byte[].class, new FieldTypeDefinition("IMAGE", false));
        fieldTypeMapping.put(Character[].class, new FieldTypeDefinition("TEXT", false));
        fieldTypeMapping.put(byte[].class, new FieldTypeDefinition("IMAGE", false));
        fieldTypeMapping.put(char[].class, new FieldTypeDefinition("TEXT", false));
        fieldTypeMapping.put(Blob.class, new FieldTypeDefinition("IMAGE", false));
        fieldTypeMapping.put(Clob.class, new FieldTypeDefinition("TEXT", false));
        fieldTypeMapping.put(Date.class, new FieldTypeDefinition("DATE", false));
        fieldTypeMapping.put(Time.class, new FieldTypeDefinition("TIME", false));
        fieldTypeMapping.put(Timestamp.class, new FieldTypeDefinition("DATETIME2", false));
        fieldTypeMapping.put(LocalDate.class, new FieldTypeDefinition("DATE", false));
        fieldTypeMapping.put(LocalTime.class, new FieldTypeDefinition("TIME", false));
        fieldTypeMapping.put(LocalDateTime.class, new FieldTypeDefinition("DATETIME2", false));
        fieldTypeMapping.put(OffsetTime.class, new FieldTypeDefinition("DATETIME2", false));
        fieldTypeMapping.put(OffsetDateTime.class, new FieldTypeDefinition("DATETIME2", false));
        fieldTypeMapping.put(Instant.class, new FieldTypeDefinition("TIMESTAMP", false));
        return fieldTypeMapping;
    }

    @Override
    public ValueReadQuery buildSelectQueryForIdentity() {
        ValueReadQuery selectQuery = new ValueReadQuery();
        StringWriter writer = new StringWriter();
        writer.write("SELECT @@IDENTITY");
        selectQuery.setSQLString(writer.toString());
        return selectQuery;
    }

    @Override
    public ValueReadQuery buildSelectQueryForSequenceObject(String qualifiedSeqName, Integer size) {
        return new ValueReadQuery("SELECT NEXT VALUE FOR " + qualifiedSeqName);
    }

    @Override
    public boolean dontBindUpdateAllQueryUsingTempTables() {
        return true;
    }

    @Override
    public String getBatchDelimiterString() {
        return "";
    }

    @Override
    public String getCreationInOutputProcedureToken() {
        return this.getInOutputProcedureToken();
    }

    @Override
    public String getCreationOutputProcedureToken() {
        return "OUTPUT";
    }

    @Override
    public String getInOutputProcedureToken() {
        return "OUT";
    }

    @Override
    public int getMaxFieldNameSize() {
        return 22;
    }

    public Vector getNativeTableInfo(String table, String creator, AbstractSession session) {
        Object query = "SELECT * FROM sysobjects WHERE table_type <> 'SYSTEM_TABLE'";
        if (table != null) {
            query = table.indexOf(37) != -1 ? (String)query + " AND table_name LIKE " + table : (String)query + " AND table_name = " + table;
        }
        if (creator != null) {
            query = creator.indexOf(37) != -1 ? (String)query + " AND table_owner LIKE " + creator : (String)query + " AND table_owner = " + creator;
        }
        return session.executeSelectingCall(new SQLCall((String)query));
    }

    @Override
    public String getOutputProcedureToken() {
        return "";
    }

    @Override
    public String getProcedureArgumentString() {
        return "@";
    }

    @Override
    public String getProcedureCallHeader() {
        return "EXECUTE ";
    }

    @Override
    public String getStoredProcedureParameterPrefix() {
        return "@";
    }

    @Override
    public ValueReadQuery getTimestampQuery() {
        if (this.timestampQuery == null) {
            this.timestampQuery = new ValueReadQuery();
            this.timestampQuery.setSQLString("SELECT GETDATE()");
            this.timestampQuery.setAllowNativeSQLQuery(true);
        }
        return this.timestampQuery;
    }

    @Override
    public String getSelectForUpdateString() {
        return " WITH (UPDLOCK)";
    }

    @Override
    public String getSelectForUpdateNoWaitString() {
        return " WITH (UPDLOCK, NOWAIT)";
    }

    @Override
    public boolean shouldPrintLockingClauseAfterWhereClause() {
        return false;
    }

    @Override
    protected void initializePlatformOperators() {
        super.initializePlatformOperators();
        this.addOperator(SQLServerPlatform.operatorOuterJoin());
        this.addOperator(ExpressionOperator.simpleFunction(54, "GETDATE"));
        this.addOperator(ExpressionOperator.simpleFunctionNoParentheses(123, "CONVERT(DATE, GETDATE())"));
        this.addOperator(ExpressionOperator.simpleFunctionNoParentheses(128, "CONVERT(TIME, GETDATE())"));
        this.addOperator(ExpressionOperator.simpleFunctionNoParentheses(149, "CONVERT(DATE, GETDATE())"));
        this.addOperator(ExpressionOperator.simpleFunctionNoParentheses(150, "CONVERT(TIME, GETDATE())"));
        this.addOperator(ExpressionOperator.simpleFunction(46, "CHAR_LENGTH"));
        this.addOperator(ExpressionOperator.simpleThreeArgumentFunction(41, "SUBSTRING"));
        this.addOperator(SQLServerPlatform.singleArgumentSubstringOperator());
        this.addOperator(ExpressionOperator.addDate());
        this.addOperator(ExpressionOperator.dateName());
        this.addOperator(ExpressionOperator.datePart());
        this.addOperator(ExpressionOperator.dateDifference());
        this.addOperator(ExpressionOperator.difference());
        this.addOperator(ExpressionOperator.charIndex());
        this.addOperator(ExpressionOperator.charLength());
        this.addOperator(ExpressionOperator.reverse());
        this.addOperator(ExpressionOperator.replicate());
        this.addOperator(ExpressionOperator.right());
        this.addOperator(ExpressionOperator.cot());
        this.addOperator(ExpressionOperator.simpleTwoArgumentFunction(91, "ATN2"));
        this.addOperator(ExpressionOperator.simpleFunction(65, "LOG"));
        this.addOperator(SQLServerPlatform.addMonthsOperator());
        this.addOperator(SQLServerPlatform.inStringOperator());
        this.addOperator(ExpressionOperator.simpleTwoArgumentFunction(104, "ISNULL"));
        this.addOperator(SQLServerPlatform.toNumberOperator());
        this.addOperator(SQLServerPlatform.toDateToStringOperator());
        this.addOperator(SQLServerPlatform.toDateOperator());
        this.addOperator(SQLServerPlatform.toCharOperator());
        this.addOperator(SQLServerPlatform.locateOperator());
        this.addOperator(SQLServerPlatform.locate2Operator());
        this.addOperator(ExpressionOperator.simpleFunction(55, "CEILING"));
        this.addOperator(ExpressionOperator.simpleFunction(46, "LEN"));
        this.addOperator(this.modOperator());
        this.addOperator(ExpressionOperator.simpleAggregate(24, "STDEV", "standardDeviation"));
        this.addOperator(SQLServerPlatform.trimOperator());
        this.addOperator(SQLServerPlatform.trim2Operator());
        this.addOperator(SQLServerPlatform.mssqlExtractOperator());
    }

    private static ExpressionOperator mssqlExtractOperator() {
        return new SqlServerExtractOperator();
    }

    protected static ExpressionOperator trimOperator() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(44);
        ArrayList<String> v = new ArrayList<String>(2);
        v.add("RTRIM(LTRIM(");
        v.add("))");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    protected static ExpressionOperator trim2Operator() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(121);
        ArrayList<String> v = new ArrayList<String>(5);
        v.add("RTRIM(");
        v.add(" FROM LTRIM(");
        v.add(" FROM ");
        v.add("))");
        exOperator.printsAs(v);
        int[] argumentIndices = new int[]{1, 1, 0};
        exOperator.setArgumentIndices(argumentIndices);
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    @Override
    public Hashtable<Class<? extends Number>, ? super Number> maximumNumericValues() {
        Hashtable<Class, Number> values = new Hashtable<Class, Number>();
        values.put(Integer.class, Integer.MAX_VALUE);
        values.put(Long.class, Long.MAX_VALUE);
        values.put(Double.class, 0.0);
        values.put(Short.class, (short)Short.MAX_VALUE);
        values.put(Byte.class, (byte)127);
        values.put(Float.class, Float.valueOf(0.0f));
        values.put(BigInteger.class, new BigInteger("9999999999999999999999999999"));
        values.put(BigDecimal.class, new BigDecimal("999999999.9999999999999999999"));
        return values;
    }

    @Override
    public Hashtable<Class<? extends Number>, ? super Number> minimumNumericValues() {
        Hashtable<Class, Number> values = new Hashtable<Class, Number>();
        values.put(Integer.class, Integer.MIN_VALUE);
        values.put(Long.class, Long.MIN_VALUE);
        values.put(Double.class, -9.0);
        values.put(Short.class, (short)Short.MIN_VALUE);
        values.put(Byte.class, (byte)-128);
        values.put(Float.class, Float.valueOf(-9.0f));
        values.put(BigInteger.class, new BigInteger("-9999999999999999999999999999"));
        values.put(BigDecimal.class, new BigDecimal("-999999999.9999999999999999999"));
        return values;
    }

    protected ExpressionOperator modOperator() {
        ExpressionOperator result = new ExpressionOperator();
        result.setSelector(67);
        ArrayList<String> v = new ArrayList<String>();
        v.add(" % ");
        result.printsAs(v);
        result.bePostfix();
        result.setNodeClass(FunctionExpression.class);
        return result;
    }

    protected static ExpressionOperator singleArgumentSubstringOperator() {
        ExpressionOperator result = new ExpressionOperator();
        result.setSelector(133);
        result.setType(5);
        ArrayList<String> v = new ArrayList<String>();
        v.add("SUBSTRING(");
        v.add(",");
        v.add(", LEN(");
        v.add("))");
        result.printsAs(v);
        int[] indices = new int[]{0, 1, 0};
        result.setArgumentIndices(indices);
        result.setNodeClass(ClassConstants.FunctionExpression_Class);
        result.bePrefix();
        return result;
    }

    protected static ExpressionOperator operatorOuterJoin() {
        ExpressionOperator result = new ExpressionOperator();
        result.setSelector(6);
        ArrayList<String> v = new ArrayList<String>();
        v.add(" =* ");
        result.printsAs(v);
        result.bePostfix();
        result.setNodeClass(RelationExpression.class);
        return result;
    }

    protected static ExpressionOperator locate2Operator() {
        ExpressionOperator result = ExpressionOperator.simpleThreeArgumentFunction(113, "CHARINDEX");
        int[] argumentIndices = new int[]{1, 0, 2};
        result.setArgumentIndices(argumentIndices);
        return result;
    }

    protected static ExpressionOperator addMonthsOperator() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(47);
        ArrayList<String> v = new ArrayList<String>(3);
        v.add("DATEADD(month, ");
        v.add(", ");
        v.add(")");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        int[] indices = new int[]{1, 0};
        exOperator.setArgumentIndices(indices);
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    protected static ExpressionOperator inStringOperator() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(34);
        ArrayList<String> v = new ArrayList<String>(3);
        v.add("CHARINDEX(");
        v.add(", ");
        v.add(")");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        int[] indices = new int[]{1, 0};
        exOperator.setArgumentIndices(indices);
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    protected static ExpressionOperator toNumberOperator() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(42);
        ArrayList<String> v = new ArrayList<String>(2);
        v.add("CONVERT(NUMERIC, ");
        v.add(")");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    protected static ExpressionOperator toDateToStringOperator() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(48);
        ArrayList<String> v = new ArrayList<String>(2);
        v.add("CONVERT(CHAR, ");
        v.add(")");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    protected static ExpressionOperator toDateOperator() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(53);
        ArrayList<String> v = new ArrayList<String>(2);
        v.add("CONVERT(DATETIME, ");
        v.add(")");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    protected static ExpressionOperator toCharOperator() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(114);
        ArrayList<String> v = new ArrayList<String>(2);
        v.add("CONVERT(CHAR, ");
        v.add(")");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    protected static ExpressionOperator locateOperator() {
        ExpressionOperator result = ExpressionOperator.simpleTwoArgumentFunction(112, "CHARINDEX");
        int[] argumentIndices = new int[]{1, 0};
        result.setArgumentIndices(argumentIndices);
        return result;
    }

    @Override
    public boolean isOutputAllowWithResultSet() {
        return false;
    }

    @Override
    public boolean isSQLServer() {
        return true;
    }

    @Override
    public void printFieldIdentityClause(Writer writer) throws ValidationException {
        try {
            writer.write(" IDENTITY");
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
    }

    @Override
    public void printFieldNullClause(Writer writer) throws ValidationException {
        try {
            writer.write(" NULL");
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
    }

    @Override
    public boolean requiresProcedureCallBrackets() {
        return false;
    }

    @Override
    public boolean requiresProcedureCallOuputToken() {
        return true;
    }

    @Override
    public boolean shouldPrintInOutputTokenBeforeType() {
        return false;
    }

    @Override
    public boolean shouldPrintOutputTokenBeforeType() {
        return false;
    }

    @Override
    public boolean shouldUseJDBCOuterJoinSyntax() {
        return false;
    }

    @Override
    public boolean supportsIdentity() {
        return true;
    }

    @Override
    public boolean supportsSequenceObjects() {
        return this.isVersion11OrHigher;
    }

    @Override
    public boolean supportsLocalTempTables() {
        return true;
    }

    @Override
    protected String getCreateTempTableSqlPrefix() {
        return "CREATE TABLE ";
    }

    @Override
    public DatabaseTable getTempTableForTable(DatabaseTable table) {
        return new DatabaseTable("#" + table.getName(), table.getTableQualifier(), table.shouldUseDelimiters(), this.getStartDelimiter(), this.getEndDelimiter());
    }

    @Override
    public void writeUpdateOriginalFromTempTableSql(Writer writer, DatabaseTable table, Collection<DatabaseField> pkFields, Collection<DatabaseField> assignedFields) throws IOException {
        writer.write("UPDATE ");
        String tableName = table.getQualifiedNameDelimited(this);
        writer.write(tableName);
        String tempTableName = this.getTempTableForTable(table).getQualifiedNameDelimited(this);
        SQLServerPlatform.writeAutoAssignmentSetClause(writer, null, tempTableName, assignedFields, this);
        writer.write(" FROM ");
        writer.write(tableName);
        writer.write(", ");
        writer.write(tempTableName);
        SQLServerPlatform.writeAutoJoinWhereClause(writer, tableName, tempTableName, pkFields, this);
    }

    @Override
    public void printSQLSelectStatement(DatabaseCall call, ExpressionSQLPrinter printer, SQLSelectStatement statement) {
        List<Integer> offsetFetchArgs;
        String offsetFetchSql;
        ReadQuery query = statement.getQuery();
        if (query == null || !this.isVersion11OrHigher || !this.shouldUseRownumFiltering()) {
            super.printSQLSelectStatement(call, printer, statement);
            return;
        }
        int max = Math.max(0, query.getMaxRows());
        int first = Math.max(0, query.getFirstResult());
        if (max == 0 && first == 0) {
            super.printSQLSelectStatement(call, printer, statement);
            return;
        }
        List<Expression> orderBy = statement.getOrderByExpressions();
        if (orderBy.isEmpty()) {
            orderBy.add(statement.getBuilder().literal("ROW_NUMBER() OVER (ORDER BY (SELECT null))"));
        }
        if (max == 0) {
            offsetFetchSql = "? OFFSET ? ROWS";
            offsetFetchArgs = Arrays.asList(first);
        } else {
            offsetFetchSql = "? OFFSET ? ROWS FETCH NEXT ? ROWS ONLY";
            offsetFetchArgs = Arrays.asList(first, max - first);
        }
        orderBy.add(orderBy.remove(orderBy.size() - 1).sql(offsetFetchSql, offsetFetchArgs));
        super.printSQLSelectStatement(call, printer, statement);
        call.setIgnoreFirstRowSetting(true);
        call.setIgnoreMaxResultsSetting(true);
    }

    @Override
    public Object getObjectFromResultSet(ResultSet resultSet, int columnNumber, int type, AbstractSession session) throws SQLException {
        if (this.driverSupportsOffsetDateTime.booleanValue() && type == -155) {
            return resultSet.getObject(columnNumber, OffsetDateTime.class);
        }
        return super.getObjectFromResultSet(resultSet, columnNumber, type, session);
    }

    @Override
    public void setParameterValueInDatabaseCall(Object parameter, PreparedStatement statement, int index, AbstractSession session) throws SQLException {
        if (this.driverSupportsOffsetDateTime.booleanValue()) {
            if (parameter instanceof OffsetDateTime || parameter instanceof OffsetTime || parameter instanceof LocalTime || parameter instanceof LocalDate || parameter instanceof LocalDateTime) {
                statement.setObject(index, parameter);
                return;
            }
        } else if (parameter instanceof LocalTime) {
            statement.setTime(index, Time.valueOf((LocalTime)parameter));
            return;
        }
        super.setParameterValueInDatabaseCall(parameter, statement, index, session);
    }

    @Override
    public void setParameterValueInDatabaseCall(Object parameter, CallableStatement statement, String name, AbstractSession session) throws SQLException {
        if (this.driverSupportsOffsetDateTime.booleanValue()) {
            if (parameter instanceof OffsetDateTime || parameter instanceof OffsetTime || parameter instanceof LocalTime || parameter instanceof LocalDate || parameter instanceof LocalDateTime) {
                statement.setObject(name, parameter);
                return;
            }
        } else if (parameter instanceof LocalTime) {
            statement.setTime(name, Time.valueOf((LocalTime)parameter));
            return;
        }
        super.setParameterValueInDatabaseCall(parameter, statement, name, session);
    }

    private static final class SqlServerExtractOperator
    extends ExtractOperator {
        private static final String[] SECOND_STRINGS = new String[]{"(CAST(DATEPART(NANOSECOND, ", ") AS FLOAT)/1000000000 + DATEPART(SECOND, ", "))"};
        private static final String[] WEEK_STRINGS = new String[]{"DATEPART(ISO_WEEK,", ")"};

        private static List<String> mssqlDbStrings() {
            ArrayList<String> dbStrings = new ArrayList<String>(2);
            dbStrings.add("DATEPART(");
            dbStrings.add(",");
            dbStrings.add(")");
            return dbStrings;
        }

        private SqlServerExtractOperator() {
            super(SqlServerExtractOperator.mssqlDbStrings());
        }

        @Override
        protected void printSecondSQL(Expression first, Expression second, ExpressionSQLPrinter printer) {
            printer.printString(SECOND_STRINGS[0]);
            first.printSQL(printer);
            printer.printString(SECOND_STRINGS[1]);
            first.printSQL(printer);
            printer.printString(SECOND_STRINGS[2]);
        }

        @Override
        protected void printSecondJava(Expression first, Expression second, ExpressionJavaPrinter printer) {
            printer.printString(SECOND_STRINGS[0]);
            first.printJava(printer);
            printer.printString(SECOND_STRINGS[1]);
            first.printJava(printer);
            printer.printString(SECOND_STRINGS[2]);
        }

        @Override
        protected void printWeekSQL(Expression first, Expression second, ExpressionSQLPrinter printer) {
            printer.printString(WEEK_STRINGS[0]);
            first.printSQL(printer);
            printer.printString(WEEK_STRINGS[1]);
        }

        @Override
        protected void printWeekJava(Expression first, Expression second, ExpressionJavaPrinter printer) {
            printer.printString(WEEK_STRINGS[0]);
            first.printJava(printer);
            printer.printString(WEEK_STRINGS[1]);
        }
    }
}

