/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.schemaframework;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.sessions.AbstractSession;

public class UniqueKeyConstraint
implements Serializable {
    protected String name = "";
    protected List<String> sourceFields = new ArrayList<String>();

    public UniqueKeyConstraint() {
    }

    public UniqueKeyConstraint(String name, String sourceField) {
        this();
        this.name = name;
        this.sourceFields.add(sourceField);
    }

    public UniqueKeyConstraint(String name, String[] sourceFields) {
        this();
        this.name = name;
        this.sourceFields.addAll(Arrays.asList(sourceFields));
    }

    public void addSourceField(String sourceField) {
        this.getSourceFields().add(sourceField);
    }

    public void appendDBString(Writer writer, AbstractSession session) {
        try {
            writer.write("UNIQUE (");
            Iterator<String> iterator = this.getSourceFields().iterator();
            while (iterator.hasNext()) {
                writer.write(iterator.next());
                if (!iterator.hasNext()) continue;
                writer.write(", ");
            }
            writer.write(")");
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
    }

    public String getName() {
        return this.name;
    }

    public List<String> getSourceFields() {
        return this.sourceFields;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSourceFields(List<String> sourceFields) {
        this.sourceFields = sourceFields;
    }
}

