/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundlerepository.impl.wrapper;

import java.util.Iterator;
import java.util.Map;
import org.apache.felix.bundlerepository.Capability;
import org.apache.felix.bundlerepository.Requirement;
import org.apache.felix.bundlerepository.Resource;
import org.apache.felix.bundlerepository.impl.CapabilityImpl;
import org.apache.felix.bundlerepository.impl.RequirementImpl;
import org.osgi.framework.Version;

public class ConvertedResource
implements Resource {
    private final org.osgi.service.obr.Resource resource;
    private Capability[] capabilities;
    private Requirement[] requirements;

    public ConvertedResource(org.osgi.service.obr.Resource resource) {
        org.osgi.service.obr.Requirement[] r;
        this.resource = resource;
        org.osgi.service.obr.Capability[] c = resource.getCapabilities();
        if (c != null) {
            this.capabilities = new Capability[c.length];
            for (int i = 0; i < c.length; ++i) {
                CapabilityImpl cap = new CapabilityImpl(c[i].getName());
                Iterator iter = c[i].getProperties().entrySet().iterator();
                boolean j = false;
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    cap.addProperty((String)entry.getKey(), null, (String)entry.getValue());
                }
                this.capabilities[i] = cap;
            }
        }
        if ((r = resource.getRequirements()) != null) {
            this.requirements = new Requirement[r.length];
            for (int i = 0; i < r.length; ++i) {
                RequirementImpl req = new RequirementImpl(r[i].getName());
                req.setFilter(r[i].getFilter());
                req.setOptional(r[i].isOptional());
                req.setExtend(r[i].isExtend());
                req.setMultiple(r[i].isMultiple());
                this.requirements[i] = req;
            }
        }
    }

    public Capability[] getCapabilities() {
        return this.capabilities;
    }

    public Requirement[] getRequirements() {
        return this.requirements;
    }

    public String[] getCategories() {
        return this.resource.getCategories();
    }

    public String getId() {
        return this.resource.getId();
    }

    public String getPresentationName() {
        return this.resource.getPresentationName();
    }

    public Map getProperties() {
        return this.resource.getProperties();
    }

    public Long getSize() {
        return null;
    }

    public String getSymbolicName() {
        return this.resource.getSymbolicName();
    }

    public String getURI() {
        return this.resource.getURL().toString();
    }

    public Version getVersion() {
        return this.resource.getVersion();
    }

    public boolean isLocal() {
        return false;
    }
}

