/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurro.internal;

import jakarta.enterprise.concurrent.ContextService;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.glassfish.concurro.ContextServiceImpl;
import org.glassfish.concurro.spi.ContextHandle;
import org.glassfish.concurro.spi.ContextSetupProvider;
import org.glassfish.concurro.spi.TransactionHandle;
import org.glassfish.concurro.spi.TransactionSetupProvider;

public class ContextProxyInvocationHandler
implements InvocationHandler,
Serializable {
    static final long serialVersionUID = -2887560418884002777L;
    protected final ContextSetupProvider contextSetupProvider;
    protected ContextService contextService;
    protected final ContextHandle capturedContextHandle;
    protected final TransactionSetupProvider transactionSetupProvider;
    protected final Object proxiedObject;
    protected Map<String, String> executionProperties;

    public ContextProxyInvocationHandler(ContextServiceImpl contextService, Object proxiedObject, Map<String, String> executionProperties) {
        this.contextSetupProvider = contextService.getContextSetupProvider();
        this.proxiedObject = proxiedObject;
        this.contextService = contextService;
        this.transactionSetupProvider = contextService.getTransactionSetupProvider();
        this.executionProperties = executionProperties;
        this.capturedContextHandle = this.contextSetupProvider.saveContext(contextService, executionProperties);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result = null;
        Class<?> methodDeclaringClass = method.getDeclaringClass();
        if (methodDeclaringClass == Object.class) {
            result = method.invoke(this.proxiedObject, args);
        } else {
            TransactionHandle txHandle = null;
            if (this.transactionSetupProvider != null) {
                txHandle = this.transactionSetupProvider.beforeProxyMethod(this.getTransactionExecutionProperty());
            }
            ContextHandle contextHandleForReset = this.contextSetupProvider.setup(this.capturedContextHandle);
            try {
                result = method.invoke(this.proxiedObject, args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
            finally {
                this.contextSetupProvider.reset(contextHandleForReset);
                if (this.transactionSetupProvider != null) {
                    this.transactionSetupProvider.afterProxyMethod(txHandle, this.getTransactionExecutionProperty());
                }
            }
        }
        return result;
    }

    public Map<String, String> getExecutionProperties() {
        if (this.executionProperties == null) {
            return null;
        }
        HashMap<String, String> copy = new HashMap<String, String>();
        copy.putAll(this.executionProperties);
        return copy;
    }

    public ContextService getContextService() {
        return this.contextService;
    }

    protected String getTransactionExecutionProperty() {
        if (this.executionProperties != null && this.executionProperties.get("jakarta.enterprise.concurrent.TRANSACTION") != null) {
            return this.executionProperties.get("jakarta.enterprise.concurrent.TRANSACTION");
        }
        return "SUSPEND";
    }
}

