/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurro.internal;

import jakarta.enterprise.concurrent.ManagedExecutorService;
import jakarta.enterprise.concurrent.ManagedTaskListener;
import java.util.concurrent.Future;

public class MultiManagedTaskListener
implements ManagedTaskListener {
    private ManagedTaskListener[] delegates;

    public MultiManagedTaskListener(ManagedTaskListener ... delegates) {
        this.delegates = delegates;
    }

    public void taskSubmitted(Future<?> future, ManagedExecutorService executor, Object task) {
        for (ManagedTaskListener listener : this.delegates) {
            if (listener == null) continue;
            listener.taskSubmitted(future, executor, task);
        }
    }

    public void taskAborted(Future<?> future, ManagedExecutorService executor, Object task, Throwable exception) {
        for (ManagedTaskListener listener : this.delegates) {
            if (listener == null) continue;
            listener.taskAborted(future, executor, task, exception);
        }
    }

    public void taskDone(Future<?> future, ManagedExecutorService executor, Object task, Throwable exception) {
        for (ManagedTaskListener listener : this.delegates) {
            if (listener == null) continue;
            listener.taskDone(future, executor, task, exception);
        }
    }

    public void taskStarting(Future<?> future, ManagedExecutorService executor, Object task) {
        for (ManagedTaskListener listener : this.delegates) {
            if (listener == null) continue;
            listener.taskStarting(future, executor, task);
        }
    }
}

