/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.event;

import jakarta.enterprise.event.TransactionPhase;
import jakarta.enterprise.inject.spi.ObserverMethod;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.weld.util.Observers;
import org.jboss.weld.util.collections.ImmutableList;

public class ResolvedObservers<T> {
    private static final ResolvedObservers<Object> EMPTY = new ResolvedObservers<Object>(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false){

        @Override
        public boolean isEmpty() {
            return true;
        }
    };
    private final List<ObserverMethod<? super T>> immediateSyncObservers;
    private final List<ObserverMethod<? super T>> asyncObservers;
    private final List<ObserverMethod<? super T>> transactionObservers;
    private final boolean metadataRequired;

    public static <T> ResolvedObservers<T> of(List<ObserverMethod<? super T>> observers) {
        if (observers.isEmpty()) {
            return EMPTY;
        }
        boolean metadataRequired = false;
        ArrayList<ObserverMethod<T>> immediateSyncObservers = new ArrayList<ObserverMethod<T>>();
        ArrayList<ObserverMethod<T>> transactionObservers = new ArrayList<ObserverMethod<T>>();
        ArrayList<ObserverMethod<T>> asyncObservers = new ArrayList<ObserverMethod<T>>();
        for (ObserverMethod<T> observerMethod : observers) {
            if (observerMethod.isAsync()) {
                asyncObservers.add(observerMethod);
            } else if (TransactionPhase.IN_PROGRESS == observerMethod.getTransactionPhase()) {
                immediateSyncObservers.add(observerMethod);
            } else {
                transactionObservers.add(observerMethod);
            }
            if (metadataRequired || !Observers.isEventMetadataRequired(observerMethod)) continue;
            metadataRequired = true;
        }
        return new ResolvedObservers<T>(ImmutableList.copyOf(immediateSyncObservers), ImmutableList.copyOf(asyncObservers), ImmutableList.copyOf(transactionObservers), metadataRequired);
    }

    private ResolvedObservers(List<ObserverMethod<? super T>> immediateSyncObservers, List<ObserverMethod<? super T>> asyncObservers, List<ObserverMethod<? super T>> transactionObservers, boolean metadataRequired) {
        this.immediateSyncObservers = immediateSyncObservers;
        this.asyncObservers = asyncObservers;
        this.transactionObservers = transactionObservers;
        this.metadataRequired = metadataRequired;
    }

    List<ObserverMethod<? super T>> getImmediateSyncObservers() {
        return this.immediateSyncObservers;
    }

    List<ObserverMethod<? super T>> getTransactionObservers() {
        return this.transactionObservers;
    }

    List<ObserverMethod<? super T>> getAsyncObservers() {
        return this.asyncObservers;
    }

    boolean isMetadataRequired() {
        return this.metadataRequired;
    }

    public boolean isEmpty() {
        return false;
    }

    public List<ObserverMethod<? super T>> getAllObservers() {
        return ImmutableList.builder().addAll((Iterable<ObserverMethod<? super T>>)this.immediateSyncObservers).addAll((Iterable<ObserverMethod<ObserverMethod<? super T>>>)this.asyncObservers).addAll((Iterable<ObserverMethod<ObserverMethod<? super T>>>)this.transactionObservers).build();
    }
}

