/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.collections;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.jboss.weld.util.Preconditions;
import org.jboss.weld.util.collections.AbstractImmutableSet;
import org.jboss.weld.util.collections.ImmutableHashSet;
import org.jboss.weld.util.collections.ImmutableTinySet;

public abstract class ImmutableSet<T>
extends AbstractImmutableSet<T> {
    ImmutableSet() {
    }

    public static <T> Set<T> copyOf(Collection<? extends T> collection) {
        Preconditions.checkNotNull(collection);
        if (collection instanceof AbstractImmutableSet) {
            return (Set)collection;
        }
        if (collection.isEmpty()) {
            return Collections.emptySet();
        }
        if (collection instanceof Set) {
            return ImmutableSet.from((Set)collection);
        }
        return ImmutableSet.builder().addAll((Iterable<T>)collection).build();
    }

    @SafeVarargs
    public static <T> Set<T> of(T ... elements) {
        Preconditions.checkNotNull(elements);
        return ImmutableSet.builder().addAll(elements).build();
    }

    public static <T> ImmutableSetCollector<T> collector() {
        return ImmutableSetCollector.INSTANCE;
    }

    public static <T> Builder<T> builder() {
        return new BuilderImpl();
    }

    private static <T> Set<T> from(Set<T> set) {
        switch (set.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return new ImmutableTinySet.Singleton<Set<T>>(set);
            }
            case 2: {
                return new ImmutableTinySet.Doubleton<T>(set);
            }
            case 3: {
                return new ImmutableTinySet.Tripleton<T>(set);
            }
        }
        return new ImmutableHashSet<T>(set);
    }

    public static interface Builder<T> {
        public Builder<T> add(T var1);

        public Builder<T> addAll(Iterable<? extends T> var1);

        public Builder<T> addAll(T ... var1);

        public Set<T> build();
    }

    private static class ImmutableSetCollector<T>
    implements Collector<T, BuilderImpl<T>, Set<T>> {
        private static final ImmutableSetCollector<Object> INSTANCE = new ImmutableSetCollector();
        private static final Set<Collector.Characteristics> CHARACTERISTICS = ImmutableSet.of(Collector.Characteristics.UNORDERED);

        private ImmutableSetCollector() {
        }

        @Override
        public Supplier<BuilderImpl<T>> supplier() {
            return BuilderImpl::new;
        }

        @Override
        public BiConsumer<BuilderImpl<T>, T> accumulator() {
            return BuilderImpl::add;
        }

        @Override
        public BinaryOperator<BuilderImpl<T>> combiner() {
            return (builder1, builder2) -> builder1.addAll(builder2);
        }

        @Override
        public Function<BuilderImpl<T>, Set<T>> finisher() {
            return BuilderImpl::build;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return CHARACTERISTICS;
        }
    }

    private static class BuilderImpl<T>
    implements Builder<T> {
        private Set<T> set = new LinkedHashSet<T>();

        private BuilderImpl() {
        }

        @Override
        public Builder<T> add(T item) {
            if (item == null) {
                throw new IllegalArgumentException("This collection does not support null values");
            }
            this.set.add(item);
            return this;
        }

        @Override
        public Builder<T> addAll(T ... items) {
            for (T item : items) {
                this.add(item);
            }
            return this;
        }

        @Override
        public Builder<T> addAll(Iterable<? extends T> items) {
            for (T item : items) {
                this.add(item);
            }
            return this;
        }

        @Override
        BuilderImpl<T> addAll(BuilderImpl<T> items) {
            this.addAll((Iterable<? extends T>)items.set);
            return this;
        }

        @Override
        public Set<T> build() {
            return ImmutableSet.from(this.set);
        }
    }
}

