/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.containers.GenericEJBHome;
import com.sun.ejb.containers.RemoteAsyncResult;
import jakarta.ejb.EJBException;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class EjbRemoteFutureTask<V>
implements Future<V>,
Serializable {
    private Long asyncId;
    private GenericEJBHome server;
    private boolean cancelCalled = false;
    private boolean complete = false;
    private V resultValue;
    private Throwable resultException;

    public EjbRemoteFutureTask(Long id, GenericEJBHome home) {
        this.asyncId = id;
        this.server = home;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (!this.cancelCalled) {
            this.cancelCalled = true;
            if (mayInterruptIfRunning) {
                try {
                    RemoteAsyncResult result = this.server.cancel(this.asyncId);
                    if (result != null) {
                        if (result.resultException != null) {
                            this.setResultException(result.resultException);
                        } else {
                            this.setResultValue(result.resultValue);
                        }
                    }
                }
                catch (RemoteException re) {
                    throw new EJBException("Exception during cancel operation", re);
                }
            }
        }
        return false;
    }

    @Override
    public V get() throws ExecutionException {
        if (!this.complete) {
            try {
                RemoteAsyncResult result = this.server.get(this.asyncId);
                if (result != null) {
                    if (result.resultException != null) {
                        this.setResultException(result.resultException);
                    } else {
                        this.setResultValue(result.resultValue);
                    }
                }
            }
            catch (RemoteException re) {
                this.setResultException(re);
            }
        }
        if (this.resultException != null) {
            if (this.resultException instanceof ExecutionException) {
                throw (ExecutionException)this.resultException;
            }
            throw new ExecutionException(this.resultException);
        }
        return this.resultValue;
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this.complete) {
            try {
                RemoteAsyncResult result = this.server.getWithTimeout(this.asyncId, timeout, unit.toString());
                if (result != null) {
                    if (result.resultException != null) {
                        this.setResultException(result.resultException);
                    } else {
                        this.setResultValue(result.resultValue);
                    }
                }
            }
            catch (TimeoutException te) {
                throw te;
            }
            catch (RemoteException re) {
                this.setResultException(re);
            }
        }
        if (this.resultException != null) {
            if (this.resultException instanceof ExecutionException) {
                throw (ExecutionException)this.resultException;
            }
            throw new ExecutionException(this.resultException);
        }
        return this.resultValue;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        boolean isDone;
        boolean bl = isDone = this.cancelCalled || this.complete;
        if (!isDone) {
            try {
                RemoteAsyncResult result = this.server.isDone(this.asyncId);
                if (result != null) {
                    isDone = true;
                    if (result.resultException != null) {
                        this.setResultException(result.resultException);
                    } else {
                        this.setResultValue(result.resultValue);
                    }
                }
            }
            catch (RemoteException re) {
                throw new EJBException(re);
            }
        }
        return isDone;
    }

    private void setResultValue(V v) {
        this.resultValue = v;
        this.complete = true;
    }

    private void setResultException(Throwable t) {
        this.resultException = t;
        this.complete = true;
    }
}

