/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.launcher;

import com.sun.enterprise.admin.launcher.GFLauncherInfo;
import com.sun.enterprise.admin.launcher.JavaConfig;
import com.sun.enterprise.admin.launcher.JvmOptions;
import com.sun.enterprise.admin.launcher.Profiler;
import com.sun.enterprise.universal.glassfish.GFLauncherUtils;
import com.sun.enterprise.universal.io.SmartFile;
import java.io.File;

class GFLauncherNativeHelper {
    private final GFLauncherInfo info;
    private final JvmOptions jvmOptions;
    private final Profiler profiler;
    private final File installDir;
    private final File libDir;
    private final JavaConfig javaConfig;

    GFLauncherNativeHelper(GFLauncherInfo info_, JavaConfig javaConfig_, JvmOptions jvmOptions_, Profiler profiler_) {
        this.info = info_;
        this.javaConfig = javaConfig_;
        this.jvmOptions = jvmOptions_;
        this.profiler = profiler_;
        if (this.info == null || this.jvmOptions == null || this.profiler == null) {
            throw new NullPointerException("Null argument(s) to GFLauncherNativeHelper.GFLauncherNativeHelper");
        }
        this.installDir = SmartFile.sanitize(this.info.getInstallDir());
        this.libDir = new File(this.installDir, "lib");
    }

    File[] getNativePath() {
        String stockNativePathsString = this.getStockNativePathString();
        String prefixFileString = this.getPrefixString();
        String suffixFileString = this.getSuffixString();
        String profilerFileString = this.getProfilerString();
        String libFileString = this.libDir.getPath();
        String lib64FileString = this.getLib64String();
        StringBuilder sb = new StringBuilder();
        sb.append(prefixFileString).append(File.pathSeparatorChar);
        sb.append(libFileString).append(File.pathSeparatorChar);
        sb.append(lib64FileString).append(File.pathSeparatorChar);
        sb.append(stockNativePathsString).append(File.pathSeparatorChar);
        sb.append(profilerFileString).append(File.pathSeparatorChar);
        sb.append(suffixFileString);
        return (File[])GFLauncherUtils.stringToFiles(sb.toString()).toArray(File[]::new);
    }

    private String getStockNativePathString() {
        String s = System.getProperty("java.library.path");
        if (!GFLauncherUtils.ok(s)) {
            s = "";
        }
        return s;
    }

    private String getPrefixString() {
        return this.javaConfig.getNativeLibraryPrefix();
    }

    private String getSuffixString() {
        return this.javaConfig.getNativeLibrarySuffix();
    }

    private String getProfilerString() {
        if (!this.profiler.isEnabled()) {
            return "";
        }
        return GFLauncherUtils.fileListToPathString(this.profiler.getNativePath());
    }

    private String getLib64String() {
        String osArch = System.getProperty("os.arch");
        File f64 = null;
        if (osArch.equals("sparc")) {
            f64 = new File(this.libDir, "sparcv9");
        } else if (osArch.equals("x86")) {
            f64 = new File(this.libDir, "amd64");
        }
        if (f64 != null && f64.isDirectory()) {
            return f64.getPath();
        }
        return "";
    }
}

