/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.WebappLifecycleListener;
import com.sun.faces.config.ConfigManager;
import com.sun.faces.config.ConfigurationException;
import com.sun.faces.config.InitFacesContext;
import com.sun.faces.config.Verifier;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.context.SessionMap;
import com.sun.faces.el.ELContextImpl;
import com.sun.faces.push.WebsocketEndpoint;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MojarraThreadFactory;
import com.sun.faces.util.ReflectionUtils;
import com.sun.faces.util.Timer;
import com.sun.faces.util.Util;
import jakarta.el.ELManager;
import jakarta.faces.FactoryFinder;
import jakarta.faces.application.Application;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.PreDestroyApplicationEvent;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.ServletRequestEvent;
import jakarta.servlet.ServletRequestListener;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionEvent;
import jakarta.servlet.http.HttpSessionListener;
import jakarta.websocket.server.ServerContainer;
import jakarta.websocket.server.ServerEndpointConfig;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigureListener
implements ServletRequestListener,
HttpSessionListener,
ServletContextListener {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private ScheduledThreadPoolExecutor webResourcePool;
    protected WebappLifecycleListener webAppListener;
    protected WebConfiguration webConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextInitialized(ServletContextEvent servletContextEvent) {
        ConfigManager configManager;
        ServletContext servletContext = servletContextEvent.getServletContext();
        Timer timer = Timer.getInstance();
        if (timer != null) {
            timer.startTiming();
        }
        if ((configManager = ConfigManager.getInstance(servletContext)) == null) {
            configManager = ConfigManager.createInstance(servletContext);
        }
        if (configManager.hasBeenInitialized(servletContext)) {
            return;
        }
        InitFacesContext initFacesContext = new InitFacesContext(servletContext);
        Util.getCdiBeanManager(initFacesContext);
        LOGGER.log(Level.FINE, () -> MessageFormat.format("ConfigureListener.contextInitialized({0})", servletContext.getContextPath()));
        this.webConfig = WebConfiguration.getInstance(servletContext);
        Object facesServletRegistration = servletContext.getAttribute("com.sun.faces.FacesServletRegistration");
        WebXmlProcessor webXmlProcessor = new WebXmlProcessor(servletContext);
        if (facesServletRegistration == null) {
            if (!webXmlProcessor.isFacesServletPresent()) {
                if (!this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.ForceLoadFacesConfigFiles)) {
                    LOGGER.log(Level.FINE, "No FacesServlet found in deployment descriptor - bypassing configuration");
                    WebConfiguration.clear(servletContext);
                    configManager.destroy(servletContext, initFacesContext);
                    ConfigManager.removeInstance(servletContext);
                    InitFacesContext.cleanupInitMaps(servletContext);
                    return;
                }
            } else {
                LOGGER.log(Level.FINE, "FacesServlet found in deployment descriptor - processing configuration.");
            }
        }
        if (!this.webConfig.isSet(WebConfiguration.BooleanWebContextInitParameter.EnableDistributable)) {
            this.webConfig.setOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableDistributable, webXmlProcessor.isDistributablePresent());
        }
        if (this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableDistributable)) {
            servletContext.setAttribute(WebConfiguration.BooleanWebContextInitParameter.EnableDistributable.getQualifiedName(), (Object)Boolean.TRUE);
        }
        this.webAppListener = new WebappLifecycleListener(servletContext);
        this.webAppListener.contextInitialized(servletContextEvent);
        ReflectionUtils.initCache(Thread.currentThread().getContextClassLoader());
        Throwable caughtThrowable = null;
        try {
            ApplicationAssociate associate;
            Verifier verifier;
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "faces.config.listener.version", servletContext.getContextPath());
            }
            if (this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.VerifyFacesConfigObjects)) {
                LOGGER.warning("JSF1059: WARNING!  The com.sun.faces.verifyObjects feature is to aid developers not using tools.  It shouldn't be enabled if using an IDE, or if this application is being deployed for production as it will impact application start times.");
                this.webConfig.overrideContextInitParameter(WebConfiguration.BooleanWebContextInitParameter.EnableLazyBeanValidation, false);
                Verifier.setCurrentInstance(new Verifier());
            }
            configManager.initialize(servletContext, initFacesContext);
            if (this.shouldInitConfigMonitoring()) {
                this.initConfigMonitoring(servletContext);
            }
            if ((verifier = Verifier.getCurrentInstance()) != null && !verifier.isApplicationValid() && LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.severe("faces.config.verifyobjects.failures_detected");
                StringBuilder sb = new StringBuilder(128);
                for (String msg : verifier.getMessages()) {
                    sb.append(msg).append('\n');
                }
                LOGGER.severe(sb.toString());
            }
            if ((associate = ApplicationAssociate.getInstance(servletContext)) != null) {
                associate.setExpressionFactory(ELManager.getExpressionFactory());
            }
            initFacesContext.setELContext(new ELContextImpl(initFacesContext));
            if (associate != null) {
                associate.setContextName(servletContext.getContextPath());
                boolean isErrorPagePresent = webXmlProcessor.isErrorPagePresent();
                associate.setErrorPagePresent(isErrorPagePresent);
                servletContext.setAttribute("com.sun.faces.errorPagePresent", (Object)isErrorPagePresent);
            }
            if (this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableWebsocketEndpoint)) {
                ServerContainer serverContainer = (ServerContainer)servletContext.getAttribute(ServerContainer.class.getName());
                if (serverContainer == null) {
                    throw new UnsupportedOperationException("Cannot enable f:websocket. The current websocket container implementation does not support programmatically registering a container-provided endpoint.");
                }
                serverContainer.addEndpoint(ServerEndpointConfig.Builder.create(WebsocketEndpoint.class, (String)"/jakarta.faces.push/{channel}").build());
            }
            this.webConfig.doPostBringupActions();
            configManager.publishPostConfigEvent();
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, "Critical error during deployment: ", t);
            caughtThrowable = t;
        }
        finally {
            servletContextEvent.getServletContext().removeAttribute("com.sun.faces.AnnotatedClasses");
            servletContextEvent.getServletContext().removeAttribute("com.sun.faces.FacesServletMappings");
            Verifier.setCurrentInstance(null);
            LOGGER.log(Level.FINE, "faces.config.listener.version.complete");
            if (timer != null) {
                timer.stopTiming();
                timer.logResult("Initialization of context " + servletContext.getContextPath());
            }
            if (caughtThrowable != null) {
                throw new RuntimeException(caughtThrowable);
            }
            initFacesContext.releaseCurrentInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextDestroyed(ServletContextEvent sce) {
        ServletContext context = sce.getServletContext();
        ConfigManager configManager = ConfigManager.getInstance(context);
        if (configManager == null && WebConfiguration.getInstanceWithoutCreating(context) != null) {
            LOGGER.log(Level.WARNING, "Unexpected state during contextDestroyed: no ConfigManager instance in current ServletContext but one is expected to exist.");
        }
        InitFacesContext initContext = null;
        try {
            initContext = this.getInitFacesContext(context);
            if (initContext == null) {
                initContext = new InitFacesContext(context);
            } else {
                InitFacesContext.getThreadInitContextMap().put(Thread.currentThread(), initContext);
            }
            if (this.webAppListener != null) {
                this.webAppListener.contextDestroyed(sce);
                this.webAppListener = null;
            }
            if (this.webResourcePool != null) {
                this.webResourcePool.shutdownNow();
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "ConfigureListener.contextDestroyed({0})", context.getServletContextName());
            }
            if (configManager == null || !configManager.hasBeenInitialized(context)) {
                return;
            }
            ApplicationAssociate associate = ApplicationAssociate.getInstance(context);
            if (associate != null) {
                associate.setExpressionFactory(ELManager.getExpressionFactory());
            }
            initContext.setELContext(new ELContextImpl(initContext));
            Application application = initContext.getApplication();
            application.publishEvent(initContext, PreDestroyApplicationEvent.class, Application.class, application);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Unexpected exception when attempting to tear down the Mojarra runtime", e);
        }
        finally {
            ApplicationAssociate.clearInstance(context);
            ApplicationAssociate.setCurrentInstance(null);
            if (configManager != null) {
                configManager.destroy(context, initContext);
                ConfigManager.removeInstance(context);
            } else if (WebConfiguration.getInstanceWithoutCreating(context) != null && LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "Unexpected state during contextDestroyed: no ConfigManager instance in current ServletContext but one is expected to exist.");
            }
            FactoryFinder.releaseFactories();
            ReflectionUtils.clearCache(Thread.currentThread().getContextClassLoader());
            WebConfiguration.clear(context);
            InitFacesContext.cleanupInitMaps(context);
        }
    }

    public void requestDestroyed(ServletRequestEvent event) {
        if (this.webAppListener != null) {
            this.webAppListener.requestDestroyed(event);
        }
    }

    public void requestInitialized(ServletRequestEvent event) {
        if (this.webAppListener != null) {
            this.webAppListener.requestInitialized(event);
        }
    }

    public void sessionCreated(HttpSessionEvent event) {
        SessionMap.createMutex(event.getSession());
        if (this.webAppListener != null) {
            this.webAppListener.sessionCreated(event);
        }
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        SessionMap.removeMutex(event.getSession());
        if (this.webAppListener != null) {
            this.webAppListener.sessionDestroyed(event);
        }
    }

    private boolean shouldInitConfigMonitoring() {
        boolean development = this.isDevModeEnabled();
        boolean threadingOptionSpecified = this.webConfig.isSet(WebConfiguration.BooleanWebContextInitParameter.EnableThreading);
        if (development && !threadingOptionSpecified) {
            return true;
        }
        return development && threadingOptionSpecified && this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableThreading);
    }

    private void initConfigMonitoring(ServletContext context) {
        Collection webURIs = (Collection)context.getAttribute("com.sun.faces.webresources");
        if (this.isDevModeEnabled() && webURIs != null && !webURIs.isEmpty()) {
            this.webResourcePool = new ScheduledThreadPoolExecutor(1, new MojarraThreadFactory("WebResourceMonitor"));
            this.webResourcePool.scheduleAtFixedRate(new WebConfigResourceMonitor(context, webURIs), 2000L, 2000L, TimeUnit.MILLISECONDS);
        }
        context.removeAttribute("com.sun.faces.webresources");
    }

    private boolean isDevModeEnabled() {
        return "Development".equals(this.webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.JakartaFacesProjectStage));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reload(ServletContext servletContext) {
        ConfigManager configManager;
        InitFacesContext initContext;
        LOGGER.log(Level.INFO, () -> MessageFormat.format("Reloading Faces configuration for context {0}", servletContext.getContextPath()));
        try {
            List<HttpSession> sessions;
            if (this.webAppListener != null && (sessions = this.webAppListener.getActiveSessions()) != null) {
                for (HttpSession session : sessions) {
                    if (LOGGER.isLoggable(Level.INFO)) {
                        LOGGER.log(Level.INFO, "Invalidating Session {0}", session.getId());
                    }
                    session.invalidate();
                }
            }
            FactoryFinder.releaseFactories();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            initContext = new InitFacesContext(servletContext);
            ApplicationAssociate.clearInstance(((FacesContext)initContext).getExternalContext());
            ApplicationAssociate.setCurrentInstance(null);
            configManager = ConfigManager.getInstance(servletContext);
            if (configManager != null) {
                configManager.destroy(servletContext, initContext);
                ConfigManager.removeInstance(servletContext);
            } else {
                LOGGER.log(Level.SEVERE, "Unexpected state during reload: no ConfigManager instance in current ServletContext but one is expected to exist.");
            }
            ((FacesContext)initContext).release();
            ReflectionUtils.clearCache(Thread.currentThread().getContextClassLoader());
            WebConfiguration.clear(servletContext);
        }
        this.webAppListener = new WebappLifecycleListener(servletContext);
        initContext = new InitFacesContext(servletContext);
        ReflectionUtils.initCache(Thread.currentThread().getContextClassLoader());
        try {
            Boolean errorPagePresent;
            configManager = ConfigManager.createInstance(servletContext);
            if (configManager != null) {
                configManager.initialize(servletContext, initContext);
            } else {
                LOGGER.log(Level.SEVERE, "Unexpected state during reload: no ConfigManager instance in current ServletContext but one is expected to exist.");
            }
            ApplicationAssociate associate = ApplicationAssociate.getInstance(servletContext);
            if (associate != null && (errorPagePresent = (Boolean)servletContext.getAttribute("com.sun.faces.errorPagePresent")) != null) {
                associate.setErrorPagePresent(errorPagePresent);
                associate.setContextName(servletContext.getContextPath());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            initContext.release();
        }
        LOGGER.log(Level.INFO, () -> MessageFormat.format("Reload complete. ({0})", servletContext.getContextPath()));
    }

    private InitFacesContext getInitFacesContext(ServletContext context) {
        for (Map.Entry<InitFacesContext, ServletContext> entry : InitFacesContext.getInitContextServletContextMap().entrySet()) {
            if (context != entry.getValue()) continue;
            return entry.getKey();
        }
        return null;
    }

    private static class WebXmlProcessor {
        private static final String WEB_XML_PATH = "/WEB-INF/web.xml";
        private static final String WEB_FRAGMENT_PATH = "META-INF/web-fragment.xml";
        private boolean facesServletPresent;
        private boolean errorPagePresent;
        private boolean distributablePresent;

        WebXmlProcessor(ServletContext context) {
            if (context != null) {
                this.scanForFacesServlet(context);
            }
        }

        boolean isFacesServletPresent() {
            return this.facesServletPresent;
        }

        boolean isErrorPagePresent() {
            return this.errorPagePresent;
        }

        public boolean isDistributablePresent() {
            return this.distributablePresent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scanForFacesServlet(ServletContext context) {
            InputStream in = context.getResourceAsStream(WEB_XML_PATH);
            SAXParserFactory factory = this.getConfiguredFactory();
            if (in != null) {
                try {
                    SAXParser parser = factory.newSAXParser();
                    parser.parse(in, (DefaultHandler)new WebXmlHandler());
                }
                catch (IOException | ParserConfigurationException | SAXException e) {
                    this.warnProcessingError(e, context);
                    this.facesServletPresent = true;
                    return;
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception ioe) {
                            LOGGER.log(Level.FINEST, "Closing stream", ioe);
                        }
                    }
                }
            }
            if (!this.facesServletPresent && context.getMajorVersion() >= 3) {
                Enumeration<URL> urls;
                ClassLoader cl = Util.getCurrentLoader(this);
                try {
                    urls = cl.getResources(WEB_FRAGMENT_PATH);
                }
                catch (IOException ioe) {
                    throw new ConfigurationException(ioe);
                }
                if (urls != null) {
                    while (urls.hasMoreElements() && !this.facesServletPresent) {
                        InputStream fragmentStream = null;
                        try {
                            URL url = urls.nextElement();
                            URLConnection conn = url.openConnection();
                            conn.setUseCaches(false);
                            fragmentStream = conn.getInputStream();
                            factory.newSAXParser().parse(fragmentStream, (DefaultHandler)new WebXmlHandler());
                        }
                        catch (IOException | ParserConfigurationException | SAXException e) {
                            this.warnProcessingError(e, context);
                            this.facesServletPresent = true;
                            return;
                        }
                        finally {
                            if (fragmentStream == null) continue;
                            try {
                                fragmentStream.close();
                            }
                            catch (IOException ioe) {
                                LOGGER.log(Level.WARNING, "Exception whil scanning for FacesServlet", ioe);
                            }
                        }
                    }
                }
            }
        }

        private SAXParserFactory getConfiguredFactory() {
            SAXParserFactory factory = Util.createSAXParserFactory();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            return factory;
        }

        private void warnProcessingError(Exception e, ServletContext servletContext) {
            LOGGER.log(Level.WARNING, MessageFormat.format("JSF1078: Unable to process deployment descriptor for context ({0}).", servletContext.getContextPath()), e);
        }

        private class WebXmlHandler
        extends DefaultHandler {
            private static final String ERROR_PAGE = "error-page";
            private static final String SERVLET_CLASS = "servlet-class";
            private static final String FACES_SERVLET = "jakarta.faces.webapp.FacesServlet";
            private boolean servletClassFound;
            private StringBuffer content;

            private WebXmlHandler() {
            }

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
                return new InputSource(new StringReader(""));
            }

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                if (!WebXmlProcessor.this.errorPagePresent && ERROR_PAGE.equals(localName)) {
                    WebXmlProcessor.this.errorPagePresent = true;
                    return;
                }
                if (!WebXmlProcessor.this.facesServletPresent) {
                    if (SERVLET_CLASS.equals(localName)) {
                        this.servletClassFound = true;
                        this.content = new StringBuffer();
                    } else {
                        this.servletClassFound = false;
                    }
                }
                if ("distributable".equals(localName)) {
                    WebXmlProcessor.this.distributablePresent = true;
                }
            }

            @Override
            public void characters(char[] ch, int start, int length) throws SAXException {
                if (this.servletClassFound && !WebXmlProcessor.this.facesServletPresent) {
                    this.content.append(ch, start, length);
                }
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                if (this.servletClassFound && !WebXmlProcessor.this.facesServletPresent && FACES_SERVLET.equals(this.content.toString().trim())) {
                    WebXmlProcessor.this.facesServletPresent = true;
                }
            }
        }
    }

    private class WebConfigResourceMonitor
    implements Runnable {
        private List<Monitor> monitors;
        private final ServletContext servletContext;

        public WebConfigResourceMonitor(ServletContext servletContext, Collection<URI> uris) {
            this.servletContext = servletContext;
            for (URI uri : uris) {
                if (this.monitors == null) {
                    this.monitors = new ArrayList<Monitor>(uris.size());
                }
                try {
                    this.monitors.add(new Monitor(uri));
                }
                catch (IOException ioe) {
                    LOGGER.log(Level.SEVERE, () -> "Unable to setup resource monitor for " + uri.toString() + ".  Resource will not be monitored for changes.");
                    LOGGER.log(Level.FINE, ioe, ioe::toString);
                }
            }
        }

        @Override
        public void run() {
            boolean reloaded = false;
            Iterator<Monitor> i = this.monitors.iterator();
            while (i.hasNext()) {
                Monitor m = i.next();
                try {
                    if (!m.hasBeenModified() || reloaded) continue;
                    reloaded = true;
                }
                catch (IOException ioe) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.severe("Unable to access url " + m.uri.toString() + ".  Monitoring for this resource will no longer occur.");
                    }
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, ioe.toString(), ioe);
                    }
                    i.remove();
                }
            }
            if (reloaded) {
                ConfigureListener.this.reload(this.servletContext);
            }
        }

        private class Monitor {
            private final URI uri;
            private long timestamp = -1L;

            Monitor(URI uri) throws IOException {
                this.uri = uri;
                this.timestamp = this.getLastModified();
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, "Monitoring {0} for modifications", uri.toURL().toExternalForm());
                }
            }

            boolean hasBeenModified() throws IOException {
                long temp = this.getLastModified();
                if (this.timestamp < temp) {
                    this.timestamp = temp;
                    if (LOGGER.isLoggable(Level.INFO)) {
                        LOGGER.log(Level.INFO, "{0} changed!", this.uri.toURL().toExternalForm());
                    }
                    return true;
                }
                return false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private long getLastModified() throws IOException {
                InputStream in = null;
                try {
                    URLConnection connection = this.uri.toURL().openConnection();
                    connection.connect();
                    in = connection.getInputStream();
                    long l = connection.getLastModified();
                    return l;
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException ignored) {
                            LOGGER.log(Level.FINEST, "Exception while closing stream", ignored);
                        }
                    }
                }
            }
        }
    }
}

