/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch.jbcrypt;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.KDF;
import com.jcraft.jsch.jbcrypt.BCrypt;

public class JBCrypt
implements KDF {
    private BCrypt bcrypt;
    private byte[] salt;
    private int iteration;

    @Override
    public void initWithOpenSSHv1KDFOptions(byte[] kdfOptions) {
        Buffer kdfOpts = new Buffer(kdfOptions);
        this.salt = kdfOpts.getString();
        this.iteration = kdfOpts.getInt();
        this.bcrypt = new BCrypt();
    }

    @Override
    public byte[] getKey(byte[] pass, int size) {
        byte[] key = new byte[size];
        this.bcrypt.pbkdf(pass, this.salt, this.iteration, key);
        return key;
    }
}

