/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.layout;

import com.sun.jsftemplating.layout.LayoutStateManagementStrategy;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.FacesContext;
import jakarta.faces.view.StateManagementStrategy;
import jakarta.faces.view.ViewDeclarationLanguage;
import java.util.Map;

final class StateManagerUtil {
    private StateManagerUtil() {
        throw new AssertionError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object saveView(FacesContext facesContext, String viewId) {
        Map contextAttributes = facesContext.getAttributes();
        contextAttributes.put("jakarta.faces.IS_SAVING_STATE", Boolean.TRUE);
        try {
            Object object = StateManagerUtil.getStateManagementStrategy(facesContext, viewId).saveView(facesContext);
            return object;
        }
        finally {
            contextAttributes.remove("jakarta.faces.IS_SAVING_STATE");
        }
    }

    public static UIViewRoot restoreView(FacesContext facesContext, String viewId, String renderKitId) {
        return StateManagerUtil.getStateManagementStrategy(facesContext, viewId).restoreView(facesContext, viewId, renderKitId);
    }

    private static StateManagementStrategy getStateManagementStrategy(FacesContext facesContext, String viewId) {
        StateManagementStrategy strategy = null;
        ViewDeclarationLanguage vdl = facesContext.getApplication().getViewHandler().getViewDeclarationLanguage(facesContext, viewId);
        if (vdl != null) {
            strategy = vdl.getStateManagementStrategy(facesContext, viewId);
        }
        if (strategy == null) {
            strategy = new LayoutStateManagementStrategy();
        }
        return strategy;
    }
}

