/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.json.bind;

import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;

public class SimpleMappingTester<T> {
    private final Jsonb jsonb = JsonbBuilder.create();
    private final Class<T> typeClass;
    private final Class<? super T> serializationType;

    public SimpleMappingTester(Class<T> typeClass, Class<? super T> serializationType) {
        this.typeClass = Objects.requireNonNull(typeClass);
        this.serializationType = Objects.requireNonNull(serializationType);
    }

    public void test(T value, String expectedRepresentationPattern, String expectedRepresentation, Object expectedOutput) {
        this.testMarshalling(value, expectedRepresentationPattern);
        this.testMarshallingToStream(value, expectedRepresentationPattern);
        this.testMarshallingToWriter(value, expectedRepresentationPattern);
        this.testMarshallingByType(value, expectedRepresentationPattern);
        this.testMarshallingByTypeToStream(value, expectedRepresentationPattern);
        this.testMarshallingByTypeToWriter(value, expectedRepresentationPattern);
        this.testUnmarshallingByClass(expectedRepresentation, expectedOutput);
        this.testUnmarshallingByClassFromStream(expectedRepresentation, expectedOutput);
        this.testUnmarshallingByClassFromReader(expectedRepresentation, expectedOutput);
        this.testUnmarshallingByType(expectedRepresentation, expectedOutput);
        this.testUnmarshallingByTypeFromStream(expectedRepresentation, expectedOutput);
        this.testUnmarshallingByTypeFromReader(expectedRepresentation, expectedOutput);
    }

    private void testMarshalling(T value, String expectedRepresentation) {
        String jsonString = this.jsonb.toJson(value);
        MatcherAssert.assertThat((String)("[testMarshalling] - Failed to correctly marshal " + value.getClass().getName() + " object"), (Object)jsonString, (Matcher)Matchers.matchesPattern((String)expectedRepresentation));
    }

    private void testMarshallingToStream(T value, String expectedRepresentation) {
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            this.jsonb.toJson(value, (OutputStream)stream);
            String jsonString = new String(stream.toByteArray(), StandardCharsets.UTF_8);
            MatcherAssert.assertThat((String)("[testMarshallingToStream] - Failed to correctly marshal " + value.getClass().getName() + " object"), (Object)jsonString, (Matcher)Matchers.matchesPattern((String)expectedRepresentation));
        }
        catch (IOException e) {
            Assertions.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    private void testMarshallingToWriter(T value, String expectedRepresentation) {
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();
             OutputStreamWriter writer = new OutputStreamWriter(stream);){
            this.jsonb.toJson(value, (Writer)writer);
            String jsonString = new String(stream.toByteArray(), StandardCharsets.UTF_8);
            MatcherAssert.assertThat((String)("[testMarshallingToWriter] - Failed to correctly marshal " + value.getClass().getName() + " object"), (Object)jsonString, (Matcher)Matchers.matchesPattern((String)expectedRepresentation));
        }
        catch (IOException e) {
            Assertions.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    private void testMarshallingByType(T value, String expectedRepresentation) {
        String jsonString = this.jsonb.toJson(value, this.serializationType);
        MatcherAssert.assertThat((String)("[testMarshallingByType] - Failed to correctly marshal " + value.getClass().getName() + " object"), (Object)jsonString, (Matcher)Matchers.matchesPattern((String)expectedRepresentation));
    }

    private void testMarshallingByTypeToStream(T value, String expectedRepresentation) {
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            this.jsonb.toJson(value, this.serializationType, (OutputStream)stream);
            String jsonString = new String(stream.toByteArray(), StandardCharsets.UTF_8);
            MatcherAssert.assertThat((String)("[testMarshallingByTypeToStream] - Failed to correctly marshal " + value.getClass().getName() + " object"), (Object)jsonString, (Matcher)Matchers.matchesPattern((String)expectedRepresentation));
        }
        catch (IOException e) {
            Assertions.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    private void testMarshallingByTypeToWriter(T value, String expectedRepresentation) {
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();
             OutputStreamWriter writer = new OutputStreamWriter(stream);){
            this.jsonb.toJson(value, this.serializationType, (Writer)writer);
            String jsonString = new String(stream.toByteArray(), StandardCharsets.UTF_8);
            MatcherAssert.assertThat((String)("[testMarshallingByTypeToWriter] - Failed to correctly marshal " + value.getClass().getName() + " object"), (Object)jsonString, (Matcher)Matchers.matchesPattern((String)expectedRepresentation));
        }
        catch (IOException e) {
            Assertions.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    private void testUnmarshallingByClass(String expectedRepresentation, Object value) {
        Object unmarshalledObject = this.jsonb.fromJson(expectedRepresentation, this.typeClass);
        MatcherAssert.assertThat((String)("[testUnmarshallingByClass] - Failed to correctly unmarshal " + value.getClass().getName() + " object"), (Object)unmarshalledObject, (Matcher)Matchers.is((Object)value));
    }

    private void testUnmarshallingByClassFromStream(String expectedRepresentation, Object value) {
        try (ByteArrayInputStream stream = new ByteArrayInputStream(expectedRepresentation.getBytes(StandardCharsets.UTF_8));){
            Object unmarshalledObject = this.jsonb.fromJson((InputStream)stream, this.typeClass);
            MatcherAssert.assertThat((String)("[testUnmarshallingByClassFromStream] - Failed to correctly unmarshal " + value.getClass().getName() + " object"), (Object)unmarshalledObject, (Matcher)Matchers.is((Object)value));
        }
        catch (IOException e) {
            Assertions.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    private void testUnmarshallingByClassFromReader(String expectedRepresentation, Object value) {
        try (ByteArrayInputStream stream = new ByteArrayInputStream(expectedRepresentation.getBytes(StandardCharsets.UTF_8));
             InputStreamReader reader = new InputStreamReader(stream);){
            Object unmarshalledObject = this.jsonb.fromJson((Reader)reader, this.typeClass);
            MatcherAssert.assertThat((String)("[testUnmarshallingByClassFromReader] - Failed to correctly unmarshal " + value.getClass().getName() + " object"), (Object)unmarshalledObject, (Matcher)Matchers.is((Object)value));
        }
        catch (IOException e) {
            Assertions.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    private void testUnmarshallingByType(String expectedRepresentation, Object value) {
        Object unmarshalledObject = this.jsonb.fromJson(expectedRepresentation, this.typeClass);
        MatcherAssert.assertThat((String)("[testUnmarshallingByType] - Failed to correctly unmarshal " + value.getClass().getName() + " object"), (Object)unmarshalledObject, (Matcher)Matchers.is((Object)value));
    }

    private void testUnmarshallingByTypeFromStream(String expectedRepresentation, Object value) {
        try (ByteArrayInputStream stream = new ByteArrayInputStream(expectedRepresentation.getBytes(StandardCharsets.UTF_8));){
            Object unmarshalledObject = this.jsonb.fromJson((InputStream)stream, this.typeClass);
            MatcherAssert.assertThat((String)("[testUnmarshallingByTypeFromStream] - Failed to correctly unmarshal " + value.getClass().getName() + " object"), (Object)unmarshalledObject, (Matcher)Matchers.is((Object)value));
        }
        catch (IOException e) {
            Assertions.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    private void testUnmarshallingByTypeFromReader(String expectedRepresentation, Object value) {
        try (ByteArrayInputStream stream = new ByteArrayInputStream(expectedRepresentation.getBytes(StandardCharsets.UTF_8));
             InputStreamReader reader = new InputStreamReader(stream);){
            Object unmarshalledObject = this.jsonb.fromJson((Reader)reader, this.typeClass);
            MatcherAssert.assertThat((String)("[testUnmarshallingByTypeFromReader] - Failed to correctly unmarshal " + value.getClass().getName() + " object"), (Object)unmarshalledObject, (Matcher)Matchers.is((Object)value));
        }
        catch (IOException e) {
            Assertions.fail((String)e.getMessage(), (Throwable)e);
        }
    }
}

