/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.json.bind.defaultmapping.untyped;

import ee.jakarta.tck.json.bind.SimpleMappingTester;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class UntypedMappingTest {
    @Test
    public void testObjectMapping() {
        Jsonb jsonb = JsonbBuilder.create();
        String jsonString = jsonb.toJson(new Object(){
            private String stringProperty = "Test String";
            private Number numericProperty = 0;
            private boolean booleanProperty = false;
            private Object nullProperty = null;

            public String getStringProperty() {
                return this.stringProperty;
            }

            public Number getNumericProperty() {
                return this.numericProperty;
            }

            public boolean getBooleanProperty() {
                return this.booleanProperty;
            }

            public Object getNullProperty() {
                return this.nullProperty;
            }
        });
        String validationRegexp = "\\{\\s*\"booleanProperty\"\\s*:\\s*false\\s*\\,\\s*\"numericProperty\"\\s*:\\s*0[\\.0]?+\\s*,\\s*\"stringProperty\"\\s*:\\s*\"Test String\"\\s*}";
        MatcherAssert.assertThat((String)"Failed to correctly marshal object with String, Number, Boolean and null fields.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)validationRegexp));
        String toDeserialize = "{ \"numericProperty\" : 0.0, \"booleanProperty\" : false, \"stringProperty\" : \"Test String\" }";
        Object unmarshalledObject = jsonb.fromJson(toDeserialize, Object.class);
        String validationMessage = "Failed to correctly unmarshal object with string, number, boolean and null JSON values into a predictable order Map<String,Object> with java.lang.String, java.math.BigDecimal, java.lang.Boolean and null values.";
        LinkedHashMap<String, Object> instance = new LinkedHashMap<String, Object>(){
            {
                this.put("numericProperty", BigDecimal.valueOf(0.0));
                this.put("booleanProperty", false);
                this.put("stringProperty", "Test String");
            }
        };
        MatcherAssert.assertThat((String)validationMessage, (Object)unmarshalledObject, (Matcher)Matchers.instanceOf(Map.class));
        MatcherAssert.assertThat((String)validationMessage, (Object)unmarshalledObject, (Matcher)Matchers.is((Object)instance));
    }

    @Test
    public void testArrayMapping() {
        new SimpleMappingTester<List>(List.class, List.class).test(Arrays.asList("Test String"), "\\[\\s*\"Test String\"s*\\]", "[ \"Test String\" ]", Arrays.asList("Test String"));
    }
}

