/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.spec.binaryoperator;

import com.sun.ts.tests.el.common.util.ExprEval;
import com.sun.ts.tests.el.common.util.TestNum;
import com.sun.ts.tests.el.common.util.Validator;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class ELClientIT {
    private static final System.Logger logger = System.getLogger(ELClientIT.class.getName());

    @AfterEach
    public void cleanup() throws Exception {
        logger.log(System.Logger.Level.INFO, "Cleanup method called");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void elNullOperandAddTest() throws Exception {
        boolean pass = false;
        Long expectedResult = Long.valueOf("0");
        try {
            String expr = ExprEval.buildElExpr(true, "+");
            logger.log(System.Logger.Level.TRACE, "expression to be evaluated is " + expr);
            Object result = ExprEval.evaluateValueExpression(expr, null, Object.class);
            logger.log(System.Logger.Level.TRACE, "result is " + result.toString());
            pass = ExprEval.compareClass(result, Long.class) && ExprEval.compareValue((Long)result, expectedResult, 0);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        if (!pass) {
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    @Test
    public void elNullOperandSubtractTest() throws Exception {
        boolean pass = false;
        Long expectedResult = Long.valueOf("0");
        try {
            String expr = ExprEval.buildElExpr(false, "-");
            logger.log(System.Logger.Level.TRACE, "expression to be evaluated is " + expr);
            Object result = ExprEval.evaluateValueExpression(expr, null, Object.class);
            logger.log(System.Logger.Level.TRACE, "result is " + result.toString());
            pass = ExprEval.compareClass(result, Long.class) && ExprEval.compareValue((Long)result, expectedResult, 0);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        if (!pass) {
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    @Test
    public void elNullOperandMultiplyTest() throws Exception {
        boolean pass = false;
        Long expectedResult = Long.valueOf("0");
        try {
            String expr = ExprEval.buildElExpr(true, "*");
            logger.log(System.Logger.Level.TRACE, "expression to be evaluated is " + expr);
            Object result = ExprEval.evaluateValueExpression(expr, null, Object.class);
            logger.log(System.Logger.Level.TRACE, "result is " + result.toString());
            pass = ExprEval.compareClass(result, Long.class) && ExprEval.compareValue((Long)result, expectedResult, 0);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        if (!pass) {
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    @Test
    public void elNullOperandDivisionTest() throws Exception {
        boolean pass = false;
        Long expectedResult = Long.valueOf("0");
        try {
            String expr = ExprEval.buildElExpr(true, "/");
            logger.log(System.Logger.Level.TRACE, "expression to be evaluated is " + expr);
            Object result = ExprEval.evaluateValueExpression(expr, null, Object.class);
            logger.log(System.Logger.Level.TRACE, "result is " + result.toString());
            pass = ExprEval.compareClass(result, Long.class) && ExprEval.compareValue((Long)result, expectedResult, 0);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        if (!pass) {
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    @Test
    public void elNullOperandModulusTest() throws Exception {
        boolean pass = false;
        Long expectedResult = Long.valueOf("0");
        try {
            String expr = ExprEval.buildElExpr(true, "%");
            logger.log(System.Logger.Level.TRACE, "expression to be evaluated is " + expr);
            Object result = ExprEval.evaluateValueExpression(expr, null, Object.class);
            logger.log(System.Logger.Level.TRACE, "result is " + result.toString());
            pass = ExprEval.compareClass(result, Long.class) && ExprEval.compareValue((Long)result, expectedResult, 0);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        if (!pass) {
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    @Test
    public void elBigDecimalAddTest() throws Exception {
        BigDecimal testValue = BigDecimal.valueOf(10.531);
        BigDecimal expectedResult = BigDecimal.valueOf(11.531);
        Validator.testBigDecimal(testValue, expectedResult, "+");
    }

    @Test
    public void elBigDecimalSubtractTest() throws Exception {
        BigDecimal testValue = BigDecimal.valueOf(10.531);
        BigDecimal expectedResult = BigDecimal.valueOf(9.531);
        Validator.testBigDecimal(testValue, expectedResult, "-");
    }

    @Test
    public void elBigDecimalMultiplyTest() throws Exception {
        BigDecimal testValue = BigDecimal.valueOf(1.5);
        BigDecimal expectedResult = BigDecimal.valueOf(1.5);
        Validator.testBigDecimal(testValue, expectedResult, "*");
    }

    @Test
    public void elBigDecimalDivisionTest() throws Exception {
        BigDecimal testValue = BigDecimal.valueOf(3.0);
        BigDecimal expectedResult = BigDecimal.valueOf(3.0);
        Validator.testBigDecimal(testValue, expectedResult, "/");
    }

    @Test
    public void elBigDecimalModulusTest() throws Exception {
        BigDecimal testValue = BigDecimal.valueOf(2.5);
        BigDecimal expectedResult = BigDecimal.valueOf(0.5);
        Validator.testBigDecimal(testValue, expectedResult, "%");
    }

    @Test
    public void elBigIntegerAddTest() throws Exception {
        BigInteger testValue = BigInteger.valueOf(10531L);
        BigInteger expectedResult = BigInteger.valueOf(10532L);
        Validator.testBigInteger(testValue, expectedResult, "+");
    }

    @Test
    public void elBigIntegerSubtractTest() throws Exception {
        BigInteger testValue = BigInteger.valueOf(10531L);
        BigInteger expectedResult = BigInteger.valueOf(10530L);
        Validator.testBigInteger(testValue, expectedResult, "-");
    }

    @Test
    public void elBigIntegerMultiplyTest() throws Exception {
        BigInteger testValue = BigInteger.valueOf(10531L);
        BigInteger expectedResult = BigInteger.valueOf(10531L);
        Validator.testBigInteger(testValue, expectedResult, "*");
    }

    @Test
    public void elBigIntegerDivisionTest() throws Exception {
        BigInteger testValue = BigInteger.valueOf(10531L);
        BigInteger expectedResult = BigInteger.valueOf(10531L);
        Validator.testBigInteger(testValue, expectedResult, "/");
    }

    @Test
    public void elBigIntegerModulusTest() throws Exception {
        BigInteger testValue = BigInteger.valueOf(10531L);
        BigInteger expectedResult = BigInteger.valueOf(0L);
        Validator.testBigInteger(testValue, expectedResult, "%");
    }

    @Test
    public void elFloatAddTest() throws Exception {
        for (Float testValue : TestNum.getFloatList()) {
            Float expectedResult = Float.valueOf(testValue.floatValue() + Float.valueOf("1.0").floatValue());
            Validator.testFloat(testValue, expectedResult, "+");
        }
    }

    @Test
    public void elFloatSubtractTest() throws Exception {
        for (Float testValue : TestNum.getFloatList()) {
            Float expectedResult = Float.valueOf(testValue.floatValue() - Float.valueOf("1.0").floatValue());
            Validator.testFloat(testValue, expectedResult, "-");
        }
    }

    @Test
    public void elFloatMultiplyTest() throws Exception {
        for (Float testValue : TestNum.getFloatList()) {
            Float expectedResult = Float.valueOf(testValue.floatValue() * Float.valueOf("1.0").floatValue());
            Validator.testFloat(testValue, expectedResult, "*");
        }
    }

    @Test
    public void elFloatDivisionTest() throws Exception {
        for (Float testValue : TestNum.getFloatList()) {
            Float expectedResult = Float.valueOf(testValue.floatValue() / Float.valueOf("1.0").floatValue());
            Validator.testFloat(testValue, expectedResult, "/");
        }
    }

    @Test
    public void elFloatModulusTest() throws Exception {
        for (Float testValue : TestNum.getFloatList()) {
            Float expectedResult = Float.valueOf(testValue.floatValue() % Float.valueOf("1.0").floatValue());
            Validator.testFloat(testValue, expectedResult, "%");
        }
    }

    @Test
    public void elDoubleAddTest() throws Exception {
        Double testValue = 2.5;
        Double expectedResult = 3.5;
        Validator.testDouble(testValue, expectedResult, "+");
    }

    @Test
    public void elDoubleSubtractTest() throws Exception {
        Double testValue = 2.5;
        Double expectedResult = 1.5;
        Validator.testDouble(testValue, expectedResult, "-");
    }

    @Test
    public void elDoubleMultiplyTest() throws Exception {
        Double testValue = 2.5;
        Double expectedResult = 2.5;
        Validator.testDouble(testValue, expectedResult, "*");
    }

    @Test
    public void elDoubleDivisionTest() throws Exception {
        Double testValue = 2.5;
        Double expectedResult = 2.5;
        Validator.testDouble(testValue, expectedResult, "/");
    }

    @Test
    public void elDoubleModulusTest() throws Exception {
        Double testValue = 2.5;
        Double expectedResult = 0.5;
        Validator.testDouble(testValue, expectedResult, "%");
    }

    @Test
    public void elNumericStringSubtractTest() throws Exception {
        String testValue = "25e-1";
        Double expectedResult = 1.5;
        Validator.testNumericString(testValue, expectedResult, "-");
    }

    @Test
    public void elNumericStringMultiplyTest() throws Exception {
        String testValue = "25E-1";
        Double expectedResult = 2.5;
        Validator.testNumericString(testValue, expectedResult, "*");
    }

    @Test
    public void elNumericStringDivisionTest() throws Exception {
        String testValue = "2.5";
        Double expectedResult = 2.5;
        Validator.testNumericString(testValue, expectedResult, "/");
    }

    @Test
    public void elNumericStringModulusTest() throws Exception {
        String testValue = "2.5e0";
        Double expectedResult = 0.5;
        Validator.testNumericString(testValue, expectedResult, "%");
    }

    @Test
    public void elLongAddTest() throws Exception {
        Long testValue = 25000L;
        Long expectedResult = 25001L;
        Validator.testLong(testValue, expectedResult, "+");
    }

    @Test
    public void elLongSubtractTest() throws Exception {
        Long testValue = 25000L;
        Long expectedResult = 24999L;
        Validator.testLong(testValue, expectedResult, "-");
    }

    @Test
    public void elLongMultiplyTest() throws Exception {
        Long testValue = 25000L;
        Long expectedResult = 25000L;
        Validator.testLong(testValue, expectedResult, "*");
    }

    @Test
    public void elLongDivisionTest() throws Exception {
        Long testValue = 25000L;
        Long expectedResult = 25000L;
        Validator.testLong(testValue, expectedResult, "/");
    }

    @Test
    public void elLongModulusTest() throws Exception {
        Long testValue = 25000L;
        Long expectedResult = 0L;
        Validator.testLong(testValue, expectedResult, "%");
    }

    @Test
    public void elIntegerAddTest() throws Exception {
        Integer testValue = 25;
        Integer expectedResult = 26;
        Validator.testInteger(testValue, expectedResult, "+");
    }

    @Test
    public void elIntegerSubtractTest() throws Exception {
        Integer testValue = 25;
        Integer expectedResult = 24;
        Validator.testInteger(testValue, expectedResult, "-");
    }

    @Test
    public void elIntegerMultiplyTest() throws Exception {
        Integer testValue = 25;
        Integer expectedResult = 25;
        Validator.testInteger(testValue, expectedResult, "*");
    }

    @Test
    public void elIntegerDivisionTest() throws Exception {
        Integer testValue = 25;
        Integer expectedResult = 25;
        Validator.testInteger(testValue, expectedResult, "/");
    }

    @Test
    public void elIntegerModulusTest() throws Exception {
        Integer testValue = 25;
        Integer expectedResult = 0;
        Validator.testInteger(testValue, expectedResult, "%");
    }

    @Test
    public void elShortAddTest() throws Exception {
        Short testValue = Short.valueOf("2");
        Short expectedResult = Short.valueOf("3");
        Validator.testShort(testValue, expectedResult, "+");
    }

    @Test
    public void elShortSubtractTest() throws Exception {
        Short testValue = Short.valueOf("2");
        Short expectedResult = Short.valueOf("1");
        Validator.testShort(testValue, expectedResult, "-");
    }

    @Test
    public void elShortMultiplyTest() throws Exception {
        Short testValue = Short.valueOf("2");
        Short expectedResult = Short.valueOf("2");
        Validator.testShort(testValue, expectedResult, "*");
    }

    @Test
    public void elShortDivisionTest() throws Exception {
        Short testValue = Short.valueOf("2");
        Short expectedResult = Short.valueOf("2");
        Validator.testShort(testValue, expectedResult, "/");
    }

    @Test
    public void elShortModulusTest() throws Exception {
        Short testValue = Short.valueOf("2");
        Short expectedResult = Short.valueOf("0");
        Validator.testShort(testValue, expectedResult, "%");
    }

    @Test
    public void elByteAddTest() throws Exception {
        Byte testValue = Byte.valueOf("2");
        Byte expectedResult = Byte.valueOf("3");
        Validator.testByte(testValue, expectedResult, "+");
    }

    @Test
    public void elByteSubtractTest() throws Exception {
        Byte testValue = Byte.valueOf("2");
        Byte expectedResult = Byte.valueOf("1");
        Validator.testByte(testValue, expectedResult, "-");
    }

    @Test
    public void elByteMultiplyTest() throws Exception {
        Byte testValue = Byte.valueOf("2");
        Byte expectedResult = Byte.valueOf("2");
        Validator.testByte(testValue, expectedResult, "*");
    }

    @Test
    public void elByteDivisionTest() throws Exception {
        Byte testValue = Byte.valueOf("2");
        Byte expectedResult = Byte.valueOf("2");
        Validator.testByte(testValue, expectedResult, "/");
    }

    @Test
    public void elByteModulusTest() throws Exception {
        Byte testValue = Byte.valueOf("2");
        Byte expectedResult = Byte.valueOf("0");
        Validator.testByte(testValue, expectedResult, "%");
    }

    @Test
    public void elBooleanAndTest() throws Exception {
        Validator.testBoolean(true, "true", true, "&&");
        Validator.testBoolean(true, true, true, "&&");
        Validator.testBoolean(true, "false", false, "and");
        Validator.testBoolean(true, false, false, "and");
    }

    @Test
    public void elBooleanOrTest() throws Exception {
        Validator.testBoolean(false, "false", false, "||");
        Validator.testBoolean(true, "false", true, "or");
        Validator.testBoolean(true, false, true, "||");
        Validator.testBoolean(true, true, true, "or");
    }
}

