/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpoint;

import com.sun.ts.tests.websocket.common.util.IOUtil;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpoint.GetNegotiatedSubprotocolConfigurator;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpoint.OPS;
import jakarta.websocket.OnError;
import jakarta.websocket.OnMessage;
import jakarta.websocket.Session;
import jakarta.websocket.server.ServerEndpoint;
import java.io.IOException;

@ServerEndpoint(value="/subprotocol", subprotocols={"MBWS.huawei.com", "MBLWS.huawei.com"}, configurator=GetNegotiatedSubprotocolConfigurator.class)
public class WSCSubprotocolServer {
    private static final System.Logger logger = System.getLogger(WSCSubprotocolServer.class.getName());

    @OnMessage
    public String echo(String msg) {
        OPS op = OPS.valueOf((String)msg);
        switch (op) {
            case ECHO_MSG: {
                break;
            }
            case NEGOTIATED: {
                msg = "{" + GetNegotiatedSubprotocolConfigurator.getResulted().trim() + "}";
                break;
            }
            default: {
                throw new IllegalArgumentException("Operation" + (String)msg + "has not been implemented");
            }
        }
        return msg;
    }

    @OnError
    public void onError(Session session, Throwable t) throws IOException {
        logger.log(System.Logger.Level.INFO, "@OnError in" + this.getClass().getName());
        t.printStackTrace();
        String message = IOUtil.printStackTrace(t);
        session.getBasicRemote().sendText(message);
    }
}

