/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.core.context;

import java.util.EnumSet;
import java.util.Set;

public enum ModFeatures {
    AVAILABILITY,
    VERSION,
    MAIN_CLASS,
    PACKAGES,
    EXPORTS_PUBLIC,
    EXPORTS_ALL,
    REQUIRES_TRANSITIVE,
    REQUIRES_ALL,
    SERVICES,
    USES,
    ALL;


    public static EnumSet<ModFeatures> featureSetFromCommaList(String fList) throws IllegalArgumentException {
        EnumSet<ModFeatures> res = EnumSet.noneOf(ModFeatures.class);
        if (fList != null) {
            for (String f : fList.split(",")) {
                if ((f = f.trim().toUpperCase()).isEmpty()) continue;
                try {
                    res.add(ModFeatures.valueOf(f));
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException(f);
                }
            }
        }
        if (res.isEmpty()) {
            return EnumSet.of(AVAILABILITY, REQUIRES_TRANSITIVE, EXPORTS_PUBLIC);
        }
        return res;
    }

    public static String commaListFromFeatureSet(Set<ModFeatures> set) {
        if (set.isEmpty() || set.contains((Object)ALL)) {
            return ALL.name();
        }
        StringBuilder sb = new StringBuilder();
        for (ModFeatures f : set) {
            sb.append(f.name()).append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }
}

