/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.api.jakarta_servlet.dispatchertype;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import servlet.tck.common.servlets.GenericTCKServlet;
import servlet.tck.common.util.ServletTestUtil;

public class TestServlet
extends GenericTCKServlet {
    public void valuesTest(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        Boolean pass = true;
        PrintWriter pw = response.getWriter();
        DispatcherType[] types = DispatcherType.values();
        DispatcherType[] expected_types = new DispatcherType[]{DispatcherType.FORWARD, DispatcherType.INCLUDE, DispatcherType.REQUEST, DispatcherType.ASYNC, DispatcherType.ERROR};
        int i = 0;
        for (DispatcherType type : types) {
            if (!type.equals((Object)expected_types[i])) {
                pw.println("The DispatcherType value at position " + i + " is incorrect.");
                pw.println("Expecting " + String.valueOf(expected_types[i]) + "; got " + String.valueOf(type) + ".");
                pass = false;
            }
            ++i;
        }
        ServletTestUtil.printResult(pw, (boolean)pass);
    }

    public void valueOfTest(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        Boolean pass = true;
        PrintWriter pw = response.getWriter();
        String[] types = new String[]{"FORWARD", "INCLUDE", "REQUEST", "ASYNC", "ERROR"};
        DispatcherType[] expected_types = new DispatcherType[]{DispatcherType.FORWARD, DispatcherType.INCLUDE, DispatcherType.REQUEST, DispatcherType.ASYNC, DispatcherType.ERROR};
        int i = 0;
        for (DispatcherType type : expected_types) {
            if (!type.equals((Object)DispatcherType.valueOf((String)types[i]))) {
                pw.println("DispatcherType.valueOf does not work correctly.");
                pw.println("Expecting " + String.valueOf(expected_types[i]) + "; got " + String.valueOf(DispatcherType.valueOf((String)types[i])) + ".");
                pass = false;
            }
            ++i;
        }
        ServletTestUtil.printResult(pw, (boolean)pass);
    }

    public void valueOfNullTest(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        Boolean pass = true;
        PrintWriter pw = response.getWriter();
        String name = null;
        try {
            DispatcherType.valueOf(name);
            pass = false;
            pw.println("DispatcherType.valueOf(null) does not work correctly.");
            pw.println("Expected NullPointerException not thrown.");
        }
        catch (NullPointerException npe) {
            pw.println("Test Passed. Expected NullPointerException thrown for name =" + name + ".");
        }
        ServletTestUtil.printResult(pw, (boolean)pass);
    }

    public void valueOfInvalidTest(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        String[] names;
        Boolean pass = true;
        PrintWriter pw = response.getWriter();
        for (String name : names = new String[]{"Forward", " INCLUDE", "REQUEST ", "ASYNc", "ERROr ", "bogus"}) {
            try {
                DispatcherType.valueOf((String)name);
                pass = false;
                pw.println("DispatcherType.valueOf(bad dispatchertype) does not work correctly.");
                pw.println("Expected IllegalArgumentException not thrown.");
            }
            catch (IllegalArgumentException ile) {
                pw.println("Test Passed. Expected IllegalArgumentException thrown for name =" + name + ".");
            }
        }
        ServletTestUtil.printResult(pw, (boolean)pass);
    }
}

