/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.api.jakarta_servlet_http.httpsession;

import java.util.Properties;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import servlet.tck.api.jakarta_servlet_http.httpsession.ExpireHttpSession;
import servlet.tck.api.jakarta_servlet_http.httpsession.GetLastAccessedTime;
import servlet.tck.api.jakarta_servlet_http.httpsession.TestServlet;
import servlet.tck.common.client.AbstractTckTest;
import servlet.tck.common.servlets.CommonServlets;

public class HttpSessionTests
extends AbstractTckTest {
    @BeforeEach
    public void setupServletName() throws Exception {
        this.setServletName("TestServlet");
    }

    @Deployment(testable=false)
    public static WebArchive getTestArchive() throws Exception {
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"servlet_jsh_httpsession_web.war")).addAsWebResource("api/jakarta_servlet_http/httpsession/index.html", "index.html")).addAsLibraries((Archive[])CommonServlets.getCommonServletsArchive())).addClasses(new Class[]{ExpireHttpSession.class, GetLastAccessedTime.class, TestServlet.class})).setWebXML(HttpSessionTests.class.getResource("servlet_jsh_httpsession_web.xml"));
    }

    @Test
    public void getCreationTimeTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "getCreationTimeTest");
        this.invoke();
    }

    @Test
    public void getCreationTimeIllegalStateExceptionTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "getCreationTimeIllegalStateExceptionTest");
        this.invoke();
    }

    @Test
    public void getIdTestServlet() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "getIdTestServlet");
        this.invoke();
    }

    @Test
    public void getIdIllegalStateExceptionTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "getIdIllegalStateExceptionTest");
        this.invoke();
    }

    @Test
    public void getLastAccessedTimeTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "getLastAccessedTimeTest");
        this.invoke();
    }

    @Test
    public void getLastAccessedTimeSetGetTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "getLastAccessedTimeSetGetTest");
        this.invoke();
    }

    @Test
    public void expireHttpSessionTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "getSessionMax");
        ((Properties)TEST_PROPS.get()).setProperty("save_state", "true");
        this.invoke();
        Long t1 = System.currentTimeMillis();
        int tmp = 0;
        while (System.currentTimeMillis() - t1 < 10L) {
            ++tmp;
        }
        ((Properties)TEST_PROPS.get()).setProperty("request", "GET " + this.getContextRoot() + "/index.html HTTP/1.1");
        ((Properties)TEST_PROPS.get()).setProperty("save_state", "true");
        ((Properties)TEST_PROPS.get()).setProperty("use_saved_state", "true");
        ((Properties)TEST_PROPS.get()).setProperty("search_string", "INDEX from index.html");
        this.invoke();
        Long t2 = System.currentTimeMillis();
        while (System.currentTimeMillis() - t2 < 10L) {
            ++tmp;
        }
        ((Properties)TEST_PROPS.get()).setProperty("request", "GET " + this.getContextRoot() + "/getLastAccessedTime?t1=" + t1 + "&t2=" + t2 + " HTTP/1.1");
        ((Properties)TEST_PROPS.get()).setProperty("save_state", "true");
        ((Properties)TEST_PROPS.get()).setProperty("use_saved_state", "true");
        ((Properties)TEST_PROPS.get()).setProperty("search_string", "Test passed: session.getLastAccessedTime()");
        this.invoke();
        Long t3 = System.currentTimeMillis();
        int wait = Integer.parseInt(this._props.getProperty("servlet_waittime").trim());
        while (System.currentTimeMillis() - t3 < (long)(10000 + wait)) {
            ++tmp;
        }
        ((Properties)TEST_PROPS.get()).setProperty("request", "GET " + this.getContextRoot() + "/expireHttpSession HTTP/1.1");
        ((Properties)TEST_PROPS.get()).setProperty("use_saved_state", "true");
        ((Properties)TEST_PROPS.get()).setProperty("search_string", "Session expired as expected.");
        this.invoke();
    }

    @Test
    public void getLastAccessedTimeIllegalStateExceptionTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "getSession");
        ((Properties)TEST_PROPS.get()).setProperty("save_state", "true");
        this.invoke();
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "getLastAccessedTimeIllegalStateExceptionTest");
        ((Properties)TEST_PROPS.get()).setProperty("use_saved_state", "true");
        this.invoke();
    }

    @Test
    public void getMaxInactiveIntervalTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "getMaxInactiveIntervalTest");
        this.invoke();
    }

    @Test
    public void getAttributeNamesTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "getAttributeNamesTest");
        this.invoke();
    }

    @Test
    public void getAttributeNamesIllegalStateExceptionTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "getAttributeNamesIllegalStateExceptionTest");
        this.invoke();
    }

    @Test
    public void getAttributeTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "getAttributeTest");
        this.invoke();
    }

    @Test
    public void getAttributeIllegalStateExceptionTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "getAttributeIllegalStateExceptionTest");
        this.invoke();
    }

    @Test
    public void getServletContextTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "getServletContextTest");
        this.invoke();
    }

    @Test
    public void invalidateTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "invalidateTest");
        this.invoke();
    }

    @Test
    public void invalidateIllegalStateExceptionTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "invalidateIllegalStateExceptionTest");
        this.invoke();
    }

    @Test
    public void isNewTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "isNewTest");
        this.invoke();
    }

    @Test
    public void isNewIllegalStateExceptionTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "isNewIllegalStateExceptionTest");
        this.invoke();
    }

    @Test
    public void removeAttributeTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "removeAttributeTest");
        this.invoke();
    }

    @Test
    public void removeAttributeDoNothingTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "removeAttributeDoNothingTest");
        this.invoke();
    }

    @Test
    public void removeAttributeIllegalStateExceptionTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "removeAttributeIllegalStateExceptionTest");
        this.invoke();
    }

    @Test
    public void setAttributeTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "setAttributeTest");
        this.invoke();
    }

    @Test
    public void setAttributeNullTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "setAttributeNullTest");
        this.invoke();
    }

    @Test
    public void setAttributeIllegalStateExceptionTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "setAttributeIllegalStateExceptionTest");
        this.invoke();
    }

    @Test
    public void setMaxInactiveIntervalTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "setMaxInactiveIntervalTest");
        this.invoke();
    }
}

