/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.dialogs;

import java.util.HashSet;
import java.util.List;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.color.ColorCategoryManager;
import org.eclipse.sirius.diagram.ui.tools.api.color.ColorCategoryManagerProvider;
import org.eclipse.sirius.diagram.ui.tools.api.color.ColorManager;
import org.eclipse.sirius.diagram.ui.tools.internal.dialogs.ColorPaletteComposite;
import org.eclipse.sirius.diagram.ui.tools.internal.dialogs.ColorSelectionDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;

public class ColorPalettePopup {
    private static final int POPUP_HEIGHT = 192;
    private static final int POPUP_WIDTH = 343;
    private static final int POPUP_MAX_NB_COLORS = 10;
    private int previousColor;
    private boolean shouldBeDisposedOnDeactivation = true;
    private Shell shell;
    private RGB selectedColor;
    private Session session;
    private ColorPaletteComposite lastUsedCategory;
    private ColorPaletteComposite customCategory;
    private ColorPaletteComposite suggestedCategory;
    private ColorPaletteComposite basicCategory;
    private ColorCategoryManager colorCategoryManager;

    public ColorPalettePopup(Shell parent, Session session, List<IGraphicalEditPart> editParts, String propertyId) {
        this.session = session;
        this.shell = new Shell(parent, 0);
        this.colorCategoryManager = new ColorCategoryManagerProvider().getColorCategoryManager(session, editParts, propertyId);
    }

    public void init() {
        this.shell.setText(Messages.ColorPalettePopup_title);
        GridLayout layout = new GridLayout(1, true);
        layout.horizontalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 5;
        layout.verticalSpacing = 0;
        this.shell.setLayout((Layout)layout);
        this.shell.addListener(27, new Listener(){

            public void handleEvent(Event e) {
                if (ColorPalettePopup.this.shouldBeDisposedOnDeactivation) {
                    ColorPalettePopup.this.disposePalettePopup();
                } else {
                    ColorPalettePopup.this.shell.setVisible(false);
                }
            }
        });
        this.createLastUsedCategory((Composite)this.shell);
        this.createCustomCategory((Composite)this.shell);
        this.createSuggestedCategory((Composite)this.shell);
        this.createBasicCategory((Composite)this.shell);
    }

    private void createLastUsedCategory(Composite parent) {
        List<RGB> lastUsedColors = this.colorCategoryManager.getLastUsedColors();
        this.lastUsedCategory = this.configureColorCategory(parent, Messages.ColorPalettePopup_lastUsedCategoryLabel, Messages.ColorPalettePopup_lastUsedCategoryTooltip, lastUsedColors, null, new String());
        if (lastUsedColors.isEmpty()) {
            GridLayout layout = new GridLayout(10, true);
            layout.marginHeight = 0;
            layout.horizontalSpacing = 2;
            layout.marginBottom = 25;
            this.lastUsedCategory.setLayout((Layout)layout);
        }
    }

    private void createCustomCategory(Composite parent) {
        List<RGB> customColors = this.colorCategoryManager.getCustomColors();
        int lastIndex = customColors.size() < 10 ? customColors.size() : 10;
        this.customCategory = this.configureColorCategory(parent, Messages.ColorPalettePopup_customCategoryLabel, Messages.ColorPalettePopup_customCategoryTooltip, customColors.subList(0, lastIndex), () -> this.invokeCustomCategoryDialog(), Messages.ColorPalettePopup_customCategoryMoreButtonTooltip);
    }

    private void createSuggestedCategory(Composite parent) {
        List<RGB> suggestedColors = this.colorCategoryManager.getSuggestedColors();
        if (!ColorManager.getDefault().collectVsmColors(this.session).values().isEmpty()) {
            this.suggestedCategory = this.configureColorCategory(parent, Messages.ColorPalettePopup_suggestedCategoryLabel, Messages.ColorPalettePopup_suggestedCategoryTooltip, suggestedColors, () -> this.invokeSuggestedCategoryDialog(), Messages.ColorPalettePopup_suggestedCategoryMoreButtonTooltip);
        }
    }

    private void createBasicCategory(Composite parent) {
        List<RGB> basicColors = this.colorCategoryManager.getBasicColors();
        List<RGB> sortedBasicColors = ColorManager.getDefault().sortColors(basicColors);
        this.basicCategory = this.configureColorCategory(parent, Messages.ColorPalettePopup_basicCategoryLabel, Messages.ColorPalettePopup_basicCategoryTooltip, sortedBasicColors, null, new String());
    }

    private ColorPaletteComposite configureColorCategory(Composite parent, String separatorLabel, String categoryToolTip, List<RGB> colorsDisplayed, Runnable clickOnMoreButton, String moreButtonTooltip) {
        this.createSeparator(separatorLabel, categoryToolTip);
        Composite colorsAndButtonComposite = clickOnMoreButton != null ? this.configureColorsAndButtonsComposite(parent, 2) : this.configureColorsAndButtonsComposite(parent, 1);
        ColorPaletteComposite colorPaletteComposite = new ColorPaletteComposite(colorsAndButtonComposite, colorsDisplayed, 10, false){

            @Override
            public void selectColor(RGB colorToSet) {
                super.selectColor(colorToSet);
                ColorPalettePopup.this.selectedColor = this.getPaletteSelectedColor();
                ColorPalettePopup.this.disposePalettePopup();
            }
        };
        if (clickOnMoreButton != null) {
            this.configureMoreButton(colorsAndButtonComposite, clickOnMoreButton, moreButtonTooltip);
        }
        return colorPaletteComposite;
    }

    private Button configureMoreButton(Composite parent, final Runnable invokeDialogMethod, String moreButtonTooltip) {
        Button moreColors = new Button(parent, 8);
        moreColors.setText(Messages.ColorPalettePopup_moreButtonLabel);
        moreColors.setToolTipText(moreButtonTooltip);
        moreColors.setLayoutData((Object)new GridData(1, 0x1000000, false, true, 1, 1));
        moreColors.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                invokeDialogMethod.run();
            }
        });
        return moreColors;
    }

    private Composite configureColorsAndButtonsComposite(Composite parent, int nbColumns) {
        Composite colorsAndButtonComposite = new Composite(parent, 0);
        GridLayout colorsAndButtonLayout = new GridLayout(nbColumns, false);
        colorsAndButtonLayout.marginWidth = 2;
        colorsAndButtonLayout.marginRight = 5;
        colorsAndButtonLayout.marginHeight = 0;
        colorsAndButtonComposite.setLayout((Layout)colorsAndButtonLayout);
        GridData colorsAndButtonLayoutData = new GridData(4, 4, true, true, 1, 1);
        colorsAndButtonComposite.setLayoutData((Object)colorsAndButtonLayoutData);
        return colorsAndButtonComposite;
    }

    private void createSeparator(String separatorLabel, String categoryToolTip) {
        Composite separatorComposite = new Composite((Composite)this.shell, 0);
        GridLayout separatorLayout = new GridLayout(3, false);
        separatorLayout.marginHeight = 2;
        separatorComposite.setLayout((Layout)separatorLayout);
        GridData separatorLayoutData = new GridData(4, 4, true, true, 1, 1);
        separatorComposite.setLayoutData((Object)separatorLayoutData);
        Label separatorText = new Label(separatorComposite, 0);
        separatorText.setText(separatorLabel);
        separatorText.setLayoutData((Object)new GridData(1, 0x1000000, false, true, 1, 1));
        Label helpIcon = new Label(separatorComposite, 0);
        ImageDescriptor findImageDescriptor = DiagramUIPlugin.Implementation.findImageDescriptor("icons/help.gif");
        Image helpImage = DiagramUIPlugin.getPlugin().getImage(findImageDescriptor);
        helpIcon.setImage(helpImage);
        helpIcon.setToolTipText(categoryToolTip);
        helpIcon.setLayoutData((Object)new GridData(1, 0x1000000, false, true, 1, 1));
        Label separator = new Label(separatorComposite, 262);
        separator.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 1, 1));
    }

    private void invokeCustomCategoryDialog() {
        List<RGB> customColors = this.colorCategoryManager.getCustomColors();
        ColorSelectionDialog customCategoryDialog = new ColorSelectionDialog((Shell)this.shell.getParent()){

            @Override
            protected void initAllColorsGroup(Composite container) {
                Group allColorsGroup = this.configureAllColorsGroup(container);
                Composite compositeButtons = this.configurePaletteButtonsComposite(allColorsGroup);
                this.configureAddButton(compositeButtons, this.getAllColorsWrapper());
                this.configureRemoveButton(compositeButtons, this.getAllColorsWrapper());
            }

            @Override
            protected void initDisplayedColorsGroup(Composite container) {
            }
        };
        customCategoryDialog.setAllColors(customColors);
        if (!this.colorCategoryManager.getSelectedColorsByPropertyId().isEmpty()) {
            customCategoryDialog.setDialogSelectedColor(this.colorCategoryManager.getSelectedColorsByPropertyId().get(0));
        }
        customCategoryDialog.setDialogTitle(Messages.ColorSelectionDialog_customColorsDialogTitle);
        customCategoryDialog.setAllColorsGroupLabel(Messages.ColorSelectionDialog_groupAllCustomColorsLabel);
        customCategoryDialog.setAllColorsTooltip(Messages.ColorSelectionDialog_customAllColorsTooltip);
        customCategoryDialog.setAllColorsReorderAllowed(true);
        if (customCategoryDialog.open() == 0) {
            if (customCategoryDialog.getSelectedColor() != null) {
                this.selectedColor = customCategoryDialog.getSelectedColor();
            }
            this.colorCategoryManager.setCustomColors(customCategoryDialog.getAllColors());
        }
    }

    private void invokeSuggestedCategoryDialog() {
        List<RGB> suggestedColors = this.colorCategoryManager.getSuggestedColors();
        HashSet<RGB> allSuggestedColors = new HashSet<RGB>(ColorManager.getDefault().collectVsmColors(this.session).values());
        List<RGB> sortedAllSuggestedColors = ColorManager.getDefault().sortColors(allSuggestedColors);
        ColorSelectionDialog suggestedCategoryDialog = new ColorSelectionDialog((Shell)this.shell.getParent());
        suggestedCategoryDialog.setDisplayedColors(suggestedColors);
        suggestedCategoryDialog.setAllColors(sortedAllSuggestedColors);
        suggestedCategoryDialog.setDialogSelectedColor(null);
        suggestedCategoryDialog.setDialogTitle(Messages.ColorSelectionDialog_suggestedColorsDialogTitle);
        suggestedCategoryDialog.setDisplayedColorsGroupLabel(Messages.ColorSelectionDialog_groupDisplayedSuggestedColorsLabel);
        suggestedCategoryDialog.setAllColorsGroupLabel(Messages.ColorSelectionDialog_groupAllSuggestedColorsLabel);
        suggestedCategoryDialog.setAllColorsTooltip(Messages.ColorSelectionDialog_suggestedAllColorsTooltip);
        suggestedCategoryDialog.setDisplayedColorsTooltip(Messages.ColorSelectionDialog_suggestedDisplayedColorsTooltip);
        if (suggestedCategoryDialog.open() == 0) {
            if (suggestedCategoryDialog.getSelectedColor() != null) {
                this.selectedColor = suggestedCategoryDialog.getSelectedColor();
            }
            this.colorCategoryManager.setSuggestedColors(suggestedCategoryDialog.getDisplayedColors());
        }
    }

    public static Point getValidPopupLocation(MenuItem menuItem) {
        Point location = new Point(0, 0);
        location = Display.getCurrent().getCursorLocation();
        Rectangle screenBounds = Display.getCurrent().getBounds();
        if (!screenBounds.contains(location.x + 343, location.y + 192)) {
            location = new Point(location.x - 343, location.y - 192);
        }
        return location;
    }

    public static Point getValidPopupLocation(ToolItem toolItem) {
        Rectangle itemBounds = toolItem.getBounds();
        Point itemLocation = toolItem.getParent().toDisplay(itemBounds.x, itemBounds.y);
        return ColorPalettePopup.getValidPopupLocation(itemBounds, itemLocation);
    }

    public static Point getValidPopupLocation(Button button) {
        Rectangle buttonBounds = button.getBounds();
        Point buttonLocation = button.getParent().toDisplay(buttonBounds.x, buttonBounds.y);
        return ColorPalettePopup.getValidPopupLocation(buttonBounds, buttonLocation);
    }

    public static Point getValidPopupLocation(Rectangle buttonBounds, Point buttonLocation) {
        Point location = new Point(0, 0);
        Rectangle eclipseShellBounds = Display.getCurrent().getActiveShell().getBounds();
        int locationX = buttonLocation.x;
        int locationY = buttonLocation.y + buttonBounds.height;
        int shellMargin = 7;
        Point expectedRightBottomPopup = new Point(buttonLocation.x + 343, buttonLocation.y + 192);
        if (!eclipseShellBounds.contains(expectedRightBottomPopup)) {
            Point rightBottomShell = new Point(eclipseShellBounds.x + eclipseShellBounds.width, eclipseShellBounds.y + eclipseShellBounds.height);
            if (expectedRightBottomPopup.x > rightBottomShell.x) {
                locationX = rightBottomShell.x - 343 - shellMargin;
            }
            if (expectedRightBottomPopup.y > rightBottomShell.y) {
                locationY = rightBottomShell.y - 192 - shellMargin;
            }
        }
        location = new Point(locationX, locationY);
        return location;
    }

    public RGB open(Point location) {
        Point listSize = this.shell.computeSize(-1, -1, false);
        this.shell.setBounds(location.x, location.y, listSize.x, listSize.y);
        this.shell.open();
        this.shell.setFocus();
        Display display = this.shell.getDisplay();
        while (!this.shell.isDisposed() && this.shell.isVisible()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        RGB previousRGB = FigureUtilities.integerToRGB((Integer)this.getPreviousColor());
        if (!previousRGB.equals((Object)this.selectedColor)) {
            this.colorCategoryManager.addLastUsedColor(this.selectedColor);
        }
        return this.selectedColor;
    }

    public RGB getSelectedColor() {
        return this.selectedColor;
    }

    public int getPreviousColor() {
        return this.previousColor;
    }

    public void setPreviousColor(int previousColor) {
        this.previousColor = previousColor;
    }

    public void disposePalettePopup() {
        if (this.lastUsedCategory != null && !this.lastUsedCategory.isDisposed()) {
            this.lastUsedCategory.dispose();
        }
        if (this.customCategory != null && !this.customCategory.isDisposed()) {
            this.customCategory.dispose();
        }
        if (this.suggestedCategory != null && !this.suggestedCategory.isDisposed()) {
            this.suggestedCategory.dispose();
        }
        if (this.basicCategory != null && !this.basicCategory.isDisposed()) {
            this.basicCategory.dispose();
        }
        this.shell.dispose();
    }
}

