/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.base.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.fx.core.GenericObject;
import org.eclipse.fx.core.adapter.AdapterProvider;
import org.eclipse.fx.core.adapter.AdapterService;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.osgi.service.component.annotations.Component;

@Component
public class EObjectAdapterProvider
implements AdapterProvider<EObject, GenericObject> {
    public @NonNull Class<EObject> getSourceType() {
        return EObject.class;
    }

    public @NonNull Class<GenericObject> getTargetType() {
        return GenericObject.class;
    }

    public boolean canAdapt(@NonNull EObject sourceObject, @NonNull Class<GenericObject> targetType) {
        return true;
    }

    public GenericObject adapt(@NonNull EObject sourceObject, @NonNull Class<GenericObject> targetType, AdapterService.ValueAccess ... valueAccess) {
        return new EObjectGenericObjectAdapter(sourceObject);
    }

    static class EObjectGenericObjectAdapter
    implements GenericObject {
        private final EObject eo;
        private Map<String, GenericObject.GenericAttribute<?>> attributes;

        public EObjectGenericObjectAdapter(EObject eo) {
            this.eo = eo;
        }

        public Class<?> getType() {
            return this.eo.eClass().getInstanceClass();
        }

        private Map<String, GenericObject.GenericAttribute<?>> _getAttributeMap() {
            if (this.attributes == null) {
                this.attributes = new HashMap();
                for (EStructuralFeature feature : this.eo.eClass().getEAllStructuralFeatures()) {
                    this.attributes.put(feature.getName(), new GenericAttributeAdapter(this.eo, feature, this));
                }
            }
            return this.attributes;
        }

        public <T> // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable GenericObject.GenericAttribute<T> getAttribute(String attributeName) {
            return this._getAttributeMap().get(attributeName);
        }

        public Collection<GenericObject.GenericAttribute<?>> getAttributes() {
            return Collections.unmodifiableCollection(this._getAttributeMap().values());
        }

        public boolean hasAttribute(String attributeName) {
            return this._getAttributeMap().containsKey(attributeName);
        }

        public <V> @Nullable V get(String attributeName) throws IllegalArgumentException {
            GenericObject.GenericAttribute<?> attribute = this._getAttributeMap().get(attributeName);
            if (attribute == null) {
                throw new IllegalArgumentException("Attribute '" + attributeName + "' is not known to class '" + this.eo + "'");
            }
            return (V)attribute.getValue();
        }

        public GenericObject getAsGenericObject(String attributeName) throws IllegalArgumentException, IllegalStateException {
            GenericObject.GenericAttribute<?> genericAttribute = this._getAttributeMap().get(attributeName);
            GenericAttributeAdapter genericAttribute2 = (GenericAttributeAdapter)genericAttribute;
            if (genericAttribute == null) {
                throw new IllegalArgumentException("Attribute '" + attributeName + "' is not known to class '" + this.eo + "'");
            }
            if (genericAttribute2.f instanceof EReference) {
                return new EObjectGenericObjectAdapter((EObject)genericAttribute.getValue());
            }
            return null;
        }

        public void set(String attributeName, Object value) throws IllegalArgumentException, ClassCastException {
        }
    }

    static class GenericAttributeAdapter<T>
    implements GenericObject.GenericAttribute<T> {
        final EStructuralFeature f;
        private final GenericObject owner;
        private final EObject eo;

        public GenericAttributeAdapter(EObject eo, EStructuralFeature f, GenericObject owner) {
            this.eo = eo;
            this.f = f;
            this.owner = owner;
        }

        public GenericObject getOwner() {
            return this.owner;
        }

        public Class<T> getType() {
            return this.f.getEType().getInstanceClass();
        }

        public <R> R getValue() {
            return (R)this.eo.eGet(this.f);
        }

        public void setValue(T v) throws ClassCastException {
            this.eo.eSet(this.f, v);
        }
    }
}

