/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.emf.edit.ui;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.control.Cell;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.provider.IItemColorProvider;
import org.eclipse.emf.edit.provider.IItemFontProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ITableItemColorProvider;
import org.eclipse.emf.edit.provider.ITableItemFontProvider;
import org.eclipse.emf.edit.provider.ITableItemLabelProvider;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class AdapterFactoryCellFactory {
    @NonNull
    protected final AdapterFactory adapterFactory;
    @NonNull
    final List<ICellCreationListener> cellCreationListeners = new ArrayList<ICellCreationListener>();
    @NonNull
    final List<ICellUpdateListener> cellUpdateListeners = new ArrayList<ICellUpdateListener>();
    @NonNull
    final List<ICellEditHandler> cellEditHandlers = new ArrayList<ICellEditHandler>();

    public AdapterFactoryCellFactory(@NonNull AdapterFactory adapterFactory) {
        if (adapterFactory == null) {
            throw new IllegalArgumentException("AdapterFactory must not be null.");
        }
        this.adapterFactory = adapterFactory;
    }

    @NonNull
    public AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public void addCellCreationListener(@NonNull ICellCreationListener listener) {
        this.cellCreationListeners.add(listener);
    }

    public void removeCellCreationListener(@NonNull ICellCreationListener listener) {
        this.cellCreationListeners.remove(listener);
    }

    public void addCellUpdateListener(@NonNull ICellUpdateListener listener) {
        this.cellUpdateListeners.add(listener);
    }

    public void removeCellUpdateListener(@NonNull ICellUpdateListener listener) {
        this.cellUpdateListeners.remove(listener);
    }

    public void addCellEditHandler(@NonNull ICellEditHandler cellEditHandler) {
        this.cellEditHandlers.add(cellEditHandler);
    }

    public void remvoveCellEditHandler(@NonNull ICellEditHandler cellEditHandler) {
        this.cellEditHandlers.remove(cellEditHandler);
    }

    @Nullable
    ICellEditHandler getCellEditHandler(Cell<?> cell) {
        for (ICellEditHandler cellEditHandler : this.cellEditHandlers) {
            if (!cellEditHandler.canEdit(cell)) continue;
            return cellEditHandler;
        }
        return null;
    }

    static void applyItemProviderStyle(@NonNull Object item, @NonNull Cell<?> cell, @NonNull AdapterFactory adapterFactory) {
        AdapterFactoryCellFactory.applyItemProviderLabel(item, cell, adapterFactory);
        AdapterFactoryCellFactory.applyItemProviderColor(item, cell, adapterFactory);
        AdapterFactoryCellFactory.applyItemProviderFont(item, cell, adapterFactory);
    }

    static void applyItemProviderFont(@NonNull Object item, @NonNull Cell<?> cell, @NonNull AdapterFactory adapterFactory) {
        Font font;
        IItemFontProvider fontProvider = (IItemFontProvider)adapterFactory.adapt(item, IItemFontProvider.class);
        if (fontProvider != null && (font = AdapterFactoryCellFactory.fontFromObject(fontProvider.getFont(item))) != null) {
            cell.setFont(font);
        }
    }

    static Font fontFromObject(@NonNull Object object) {
        if (object instanceof URI) {
            int height;
            boolean delta;
            String heightSpecification;
            URI fontURI = (URI)object;
            if (!"font".equals(fontURI.scheme())) {
                throw new IllegalArgumentException("Only 'font' scheme is recognized" + fontURI);
            }
            if (fontURI.segmentCount() != 2) {
                throw new IllegalArgumentException("The URI must have an authority and two segments");
            }
            String fontNameSpecification = fontURI.authority();
            if ("".equals(fontNameSpecification)) {
                fontNameSpecification = null;
            }
            if ((heightSpecification = fontURI.segment(0)).startsWith("+")) {
                delta = true;
                height = Integer.parseInt(heightSpecification.substring(1));
            } else if ("".equals(heightSpecification)) {
                delta = true;
                height = 0;
            } else {
                height = Integer.parseInt(heightSpecification);
                delta = height < 0;
            }
            String styleSpecification = fontURI.segment(1);
            boolean italic = false;
            boolean bold = false;
            if ("bold".equals(styleSpecification)) {
                bold = true;
            } else if ("italic".equals(styleSpecification)) {
                italic = true;
            } else if ("italic+bold".equals(styleSpecification) || "bold+italic".equals(styleSpecification)) {
                italic = true;
                bold = true;
            }
            double size = delta ? Font.getDefault().getSize() + (double)height : (double)height;
            return Font.font((String)fontNameSpecification, (FontWeight)(bold ? FontWeight.BOLD : FontWeight.NORMAL), (FontPosture)(italic ? FontPosture.ITALIC : FontPosture.REGULAR), (double)size);
        }
        return null;
    }

    static void applyItemProviderLabel(@NonNull Object item, @NonNull Cell<?> cell, @NonNull AdapterFactory adapterFactory) {
        IItemLabelProvider labelProvider = (IItemLabelProvider)adapterFactory.adapt(item, IItemLabelProvider.class);
        if (labelProvider != null) {
            Node image;
            cell.setText(labelProvider.getText(item));
            if (item != null && (image = AdapterFactoryCellFactory.graphicFromObject(labelProvider.getImage(item))) != null) {
                cell.setGraphic(image);
            }
        }
    }

    static void applyTableItemProviderStyle(@NonNull Object item, int columnIndex, @NonNull Cell<?> cell, @NonNull AdapterFactory adapterFactory) {
        AdapterFactoryCellFactory.applyTableItemProviderLabel(item, columnIndex, cell, adapterFactory);
        AdapterFactoryCellFactory.applyTableItemProviderColor(item, columnIndex, cell, adapterFactory);
        AdapterFactoryCellFactory.applyTableItemProviderFont(item, columnIndex, cell, adapterFactory);
    }

    static void applyTableItemProviderLabel(@NonNull Object item, int columnIndex, @NonNull Cell<?> cell, @NonNull AdapterFactory adapterFactory) {
        ITableItemLabelProvider labelProvider = (ITableItemLabelProvider)adapterFactory.adapt(item, ITableItemLabelProvider.class);
        if (labelProvider != null) {
            cell.setText(labelProvider.getColumnText(item, columnIndex));
            Object columnImage = labelProvider.getColumnImage(item, columnIndex);
            Node graphic = AdapterFactoryCellFactory.graphicFromObject(columnImage);
            cell.setGraphic(graphic);
        } else {
            cell.setText(null);
            cell.setGraphic(null);
        }
    }

    static void applyTableItemProviderColor(@NonNull Object item, int columnIndex, @NonNull Cell<?> cell, @NonNull AdapterFactory adapterFactory) {
        ITableItemColorProvider colorProvider = (ITableItemColorProvider)adapterFactory.adapt(item, ITableItemColorProvider.class);
        if (colorProvider != null) {
            String background;
            Color foreground = AdapterFactoryCellFactory.colorFromObject(colorProvider.getForeground(item, columnIndex));
            if (foreground != null) {
                cell.setTextFill((Paint)foreground);
            }
            if ((background = AdapterFactoryCellFactory.cssColorFromObject(colorProvider.getBackground(item, columnIndex))) != null) {
                cell.setStyle("-fx-background-color: " + background);
            }
        }
    }

    static void applyTableItemProviderFont(@NonNull Object item, int columnIndex, @NonNull Cell<?> cell, @NonNull AdapterFactory adapterFactory) {
        Font font;
        ITableItemFontProvider fontProvider = (ITableItemFontProvider)adapterFactory.adapt(item, ITableItemFontProvider.class);
        if (fontProvider != null && (font = AdapterFactoryCellFactory.fontFromObject(fontProvider.getFont(item, columnIndex))) != null) {
            cell.setFont(font);
        }
    }

    static Node graphicFromObject(@NonNull Object object) {
        if (object instanceof Node) {
            return (Node)object;
        }
        if (object instanceof URL) {
            return new ImageView(((URL)object).toExternalForm());
        }
        if (object instanceof ComposedImage) {
            Pane pane = new Pane();
            for (Object image : ((ComposedImage)object).getImages()) {
                if (!(image instanceof URL)) continue;
                ImageView imageView = new ImageView(((URL)image).toExternalForm());
                pane.getChildren().add((Object)imageView);
            }
            return pane;
        }
        return null;
    }

    static void applyItemProviderColor(@NonNull Object item, @NonNull Cell<?> cell, @NonNull AdapterFactory adapterFactory) {
        IItemColorProvider colorProvider = (IItemColorProvider)adapterFactory.adapt(item, IItemColorProvider.class);
        if (colorProvider != null) {
            String background;
            Color foreground = AdapterFactoryCellFactory.colorFromObject(colorProvider.getForeground(item));
            if (foreground != null) {
                cell.setTextFill((Paint)foreground);
            }
            if ((background = AdapterFactoryCellFactory.cssColorFromObject(colorProvider.getBackground(item))) != null) {
                cell.setStyle("-fx-background-color: " + background);
            }
        }
    }

    static Color colorFromObject(@NonNull Object object) {
        URI colorURI = AdapterFactoryCellFactory.toColorURI(object);
        if (colorURI != null) {
            try {
                int red = Integer.parseInt(colorURI.segment(0));
                int green = Integer.parseInt(colorURI.segment(1));
                int blue = Integer.parseInt(colorURI.segment(2));
                return Color.rgb((int)red, (int)green, (int)blue);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Cannot parse color values " + colorURI + ". " + e.getMessage());
            }
        }
        return null;
    }

    static String cssColorFromObject(@NonNull Object object) {
        URI colorURI = AdapterFactoryCellFactory.toColorURI(object);
        if (colorURI != null) {
            return "rgb(" + colorURI.segment(0) + ", " + colorURI.segment(1) + ", " + colorURI.segment(2) + ")";
        }
        return null;
    }

    static URI toColorURI(@NonNull Object object) {
        if (object instanceof URI) {
            URI colorURI = (URI)object;
            if (!"color".equals(colorURI.scheme())) {
                throw new IllegalArgumentException("Only 'color' scheme is recognized " + colorURI);
            }
            if (!"rgb".equals(colorURI.authority())) {
                throw new IllegalArgumentException("Only 'rgb' authority is recognized " + colorURI);
            }
            if (colorURI.segmentCount() != 3) {
                throw new IllegalArgumentException("Color must have 3 segments (r, g, b) " + colorURI);
            }
            return colorURI;
        }
        return null;
    }

    public static interface ICellCreationListener {
        public void cellCreated(Cell<?> var1);
    }

    public static interface ICellEditHandler {
        public boolean canEdit(Cell<?> var1);

        public void startEdit(Cell<?> var1);

        public void commitEdit(Cell<?> var1, Object var2);

        public void cancelEdit(Cell<?> var1);
    }

    public static interface ICellUpdateListener {
        public void updateItem(Cell<?> var1, Object var2, boolean var3);
    }
}

