/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.animation.pagetransition.animation;

import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.RotateTransition;
import javafx.animation.ScaleTransition;
import javafx.animation.SequentialTransition;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.scene.DepthTest;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javafx.scene.transform.Rotate;
import javafx.util.Duration;
import org.eclipse.fx.ui.animation.pagetransition.CenterSwitchAnimation;
import org.eclipse.jdt.annotation.Nullable;

public class FlipAnimation
extends CenterSwitchAnimation {
    @Override
    public void animate(final BorderPane pane, final Node newNode, final Runnable postAnimation) {
        pane.setDepthTest(DepthTest.DISABLE);
        final Node curNode = pane.getCenter();
        pane.setCenter(null);
        Group area = new Group();
        area.setDepthTest(DepthTest.ENABLE);
        Bounds b = curNode.getBoundsInParent();
        newNode.resizeRelocate(b.getMinX(), b.getMinY(), b.getWidth(), b.getHeight());
        area.getChildren().add((Object)newNode);
        area.getChildren().add((Object)curNode);
        newNode.setTranslateZ(0.1);
        curNode.setTranslateZ(-0.1);
        newNode.setRotationAxis(Rotate.Y_AXIS);
        newNode.setRotate(180.0);
        pane.setCenter((Node)area);
        if (this.imageView != null) {
            pane.getChildren().add(0, (Object)this.imageView);
        }
        Animation animation = this.createAndPrepareAnimation((Node)area, null);
        animation.onFinishedProperty().set((Object)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                pane.getChildren().remove((Object)curNode);
                pane.getChildren().remove((Object)newNode);
                pane.setCenter(newNode);
                FlipAnimation.this.resetProperties(curNode, newNode);
                if (FlipAnimation.this.imageView != null) {
                    pane.getChildren().remove((Object)FlipAnimation.this.imageView);
                }
                if (postAnimation != null) {
                    postAnimation.run();
                }
            }
        });
        animation.play();
    }

    @Override
    protected Animation createAndPrepareAnimation(Node area, @Nullable Node newNode) {
        ScaleTransition zoomOut = new ScaleTransition(Duration.millis((double)300.0));
        zoomOut.setToX(0.7);
        zoomOut.setToY(0.7);
        zoomOut.setInterpolator(Interpolator.EASE_BOTH);
        ScaleTransition zoomIn = new ScaleTransition(Duration.millis((double)300.0));
        zoomIn.setToX(1.0);
        zoomIn.setToY(1.0);
        zoomIn.setInterpolator(Interpolator.EASE_BOTH);
        RotateTransition rt = new RotateTransition(Duration.millis((double)8000.0));
        rt.setAxis(Rotate.Y_AXIS);
        rt.setByAngle(180.0);
        rt.setInterpolator(Interpolator.EASE_BOTH);
        return new SequentialTransition(area, new Animation[]{zoomOut, rt, zoomIn});
    }

    @Override
    protected void resetProperties(Node curNode, Node newNode) {
        newNode.setTranslateZ(0.0);
        curNode.setTranslateZ(0.0);
        newNode.setRotate(0.0);
        curNode.setRotate(0.0);
    }
}

