/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.markers;

import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.markers.IEditorMarkerService;
import org.eclipse.m2e.core.internal.markers.IMarkerLocationService;
import org.eclipse.m2e.core.internal.markers.IMavenMarkerManager;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkerUtils {
    private static Logger log = LoggerFactory.getLogger(MarkerUtils.class);

    public static void decorateMarker(IMarker marker) {
        BundleContext context = MavenPluginActivator.getDefault().getBundleContext();
        ServiceReference ref = context.getServiceReference(IMarkerLocationService.class.getName());
        if (ref == null) {
            log.warn("Could not find OSGI service for " + IMarkerLocationService.class.getName());
            return;
        }
        IMarkerLocationService service = (IMarkerLocationService)context.getService(ref);
        if (service != null) {
            try {
                service.findLocationForMarker(marker);
            }
            finally {
                context.ungetService(ref);
            }
        }
    }

    public static void addEditorHintMarkers(IMavenMarkerManager markerManager, IFile pom, MavenProject mavenProject, String type) {
        BundleContext context = MavenPluginActivator.getDefault().getBundleContext();
        ServiceReference ref = context.getServiceReference(IEditorMarkerService.class.getName());
        if (ref == null) {
            log.warn("Could not find OSGI service for " + IEditorMarkerService.class.getName());
            return;
        }
        IEditorMarkerService service = (IEditorMarkerService)context.getService(ref);
        if (service != null) {
            try {
                service.addEditorHintMarkers(markerManager, pom, mavenProject, type);
            }
            finally {
                context.ungetService(ref);
            }
        }
    }

    public static MojoExecutionKey getMojoExecution(IMarker marker) {
        if (marker == null) {
            return null;
        }
        String groupId = marker.getAttribute("groupId", null);
        String artifactId = marker.getAttribute("artifactId", null);
        String executionId = marker.getAttribute("executionId", null);
        String version = marker.getAttribute("version", null);
        String goal = marker.getAttribute("goal", null);
        String lifecyclePhase = marker.getAttribute("lifecyclePhase", null);
        if (goal != null && executionId != null && artifactId != null && groupId != null) {
            return new MojoExecutionKey(groupId, artifactId, version, goal, lifecyclePhase, executionId);
        }
        return null;
    }
}

