/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.panes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.SimpleStyleableIntegerProperty;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import org.eclipse.jdt.annotation.NonNull;

public class SashPane
extends Region {
    private static final String USER_AGENT_STYLESHEET = SashPane.class.getResource("sash-pane.css").toExternalForm();
    private static final String LAYOUT_KEY = "sashData";
    static final int DRAG_MINIMUM = 20;
    private Sash[] sashes = new Sash[0];
    private BooleanProperty horizontal = new SimpleBooleanProperty((Object)this, "horizontal", true){

        protected void invalidated() {
            super.invalidated();
            SashPane.this.clearCache();
        }
    };
    private ObjectProperty<Node> maximizedControl = new SimpleObjectProperty<Node>((Object)this, "maximizedControl"){

        protected void invalidated() {
            super.invalidated();
            SashPane.this.clearCache();
        }
    };
    private static final CssMetaData<SashPane, Number> SASH_WIDTH = new CssMetaData<SashPane, Number>("-fx-sash-width", StyleConverter.getSizeConverter(), (Number)8){

        public boolean isSettable(SashPane node) {
            return !node.sashWidthProperty().isBound();
        }

        public StyleableProperty<Number> getStyleableProperty(SashPane node) {
            return (StyleableProperty)node.sashWidthProperty();
        }
    };
    private final @NonNull IntegerProperty sashWidth = new SimpleStyleableIntegerProperty(SASH_WIDTH, (Object)this, "sashWidth", Integer.valueOf(8));
    private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;
    private ObservableList<Node> items = FXCollections.observableArrayList();
    private Sash draggedSash;
    private Node c1;
    private Node c2;
    private double resize_1;
    private double resize_2;
    private double start;
    private Bounds clientArea;
    private double resize_total;
    private static PseudoClass HORIZONTAL;
    private static PseudoClass VERTICAL;

    static {
        ArrayList<CssMetaData<SashPane, Number>> styleables = new ArrayList<CssMetaData<SashPane, Number>>(Region.getClassCssMetaData());
        styleables.add(SASH_WIDTH);
        STYLEABLES = Collections.unmodifiableList(styleables);
        HORIZONTAL = PseudoClass.getPseudoClass((String)"horizontal");
        VERTICAL = PseudoClass.getPseudoClass((String)"vertical");
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return SashPane.getClassCssMetaData();
    }

    public SashPane() {
        this.getStyleClass().add((Object)"sash-pane");
        this.items.addListener(c -> {
            while (c.next()) {
                if (c.wasRemoved()) {
                    this.getChildren().removeIf(n -> n instanceof SashChild && c.getRemoved().contains(((SashChild)((Object)((Object)n))).getChildren().get(0)));
                }
                if (!c.wasAdded()) continue;
                this.getChildren().addAll(c.getFrom(), (Collection)c.getAddedSubList().stream().map(SashChild::new).collect(Collectors.toList()));
            }
            this.clearCache();
        });
        this.sashWidth.addListener(o -> {
            this.clearCache();
            this.requestLayout();
        });
        this.pseudoClassStateChanged(HORIZONTAL, true);
        this.pseudoClassStateChanged(VERTICAL, false);
        this.horizontal.addListener((o, ol, ne) -> {
            this.pseudoClassStateChanged(HORIZONTAL, (boolean)ne);
            this.pseudoClassStateChanged(VERTICAL, ne == false);
        });
    }

    public String getUserAgentStylesheet() {
        return USER_AGENT_STYLESHEET;
    }

    public ObservableList<Node> getItems() {
        return this.items;
    }

    void clearCache() {
        this.clientArea = null;
    }

    protected void layoutChildren() {
        int x = (int)Math.ceil(this.getPadding().getLeft());
        int y = (int)Math.ceil(this.getPadding().getTop());
        int w = (int)Math.floor(this.getWidth()) - (int)Math.ceil(this.getPadding().getLeft()) - (int)Math.ceil(this.getPadding().getRight());
        int h = (int)Math.floor(this.getHeight()) - (int)Math.ceil(this.getPadding().getTop()) - (int)Math.ceil(this.getPadding().getBottom());
        BoundingBox b = new BoundingBox((double)x, (double)y, (double)w, (double)h);
        if (this.clientArea != null && this.clientArea.equals(b)) {
            return;
        }
        if (w <= 1 || h <= 1) {
            return;
        }
        List children = this.getManagedChildren().stream().filter(Node::isVisible).collect(Collectors.toList());
        if (children.isEmpty()) {
            return;
        }
        if (this.maximizedControl.get() != null && children.contains(this.maximizedControl.get())) {
            int i = 0;
            while (i < children.size()) {
                if (children.get(i) != this.maximizedControl.get()) {
                    ((Node)children.get(i)).resizeRelocate(0.0, 0.0, 0.0, 0.0);
                } else {
                    ((Node)children.get(i)).resizeRelocate((double)x, (double)y, (double)h, (double)w);
                }
                ++i;
            }
            return;
        }
        long[] ratios = new long[children.size()];
        long total = 0L;
        int i = 0;
        while (i < children.size()) {
            Object data = ((Node)children.get(i)).getProperties().get((Object)LAYOUT_KEY);
            if (data != null && data instanceof SashFormData) {
                ratios[i] = ((SashFormData)data).weight;
            } else {
                data = new SashFormData();
                ((Node)children.get(i)).getProperties().put((Object)LAYOUT_KEY, data);
                ratios[i] = 13108L;
                ((SashFormData)data).weight = 13108L;
            }
            total += ratios[i];
            ++i;
        }
        if (this.sashes.length < children.size() - 1) {
            Sash[] newSashes = new Sash[children.size() - 1];
            System.arraycopy(this.sashes, 0, newSashes, 0, this.sashes.length);
            int i2 = this.sashes.length;
            while (i2 < newSashes.length) {
                newSashes[i2] = this.createSash();
                ++i2;
            }
            this.sashes = newSashes;
        }
        if (this.sashes.length > children.size() - 1) {
            if (children.size() == 0) {
                i = 0;
                while (i < this.sashes.length) {
                    this.getChildren().remove((Object)this.sashes[i]);
                    ++i;
                }
                this.sashes = new Sash[0];
            } else {
                Sash[] newSashes = new Sash[children.size() - 1];
                System.arraycopy(this.sashes, 0, newSashes, 0, newSashes.length);
                int i3 = children.size() - 1;
                while (i3 < this.sashes.length) {
                    this.getChildren().remove((Object)this.sashes[i3]);
                    ++i3;
                }
                this.sashes = newSashes;
            }
        }
        if (this.horizontal.get()) {
            int width = (int)(ratios[0] * (long)(w - this.sashes.length * this.getSashWidth()) / total);
            ((Node)children.get(0)).resizeRelocate((double)x, (double)y, (double)width, (double)h);
            x += width;
            int i4 = 1;
            while (i4 < children.size() - 1) {
                this.sashes[i4 - 1].resizeRelocate(x, y, this.getSashWidth(), h);
                width = (int)(ratios[i4] * (long)(w - this.sashes.length * this.getSashWidth()) / total);
                ((Node)children.get(i4)).resizeRelocate((double)(x += this.getSashWidth()), (double)y, (double)width, (double)h);
                x += width;
                ++i4;
            }
            if (children.size() > 1) {
                this.sashes[this.sashes.length - 1].resizeRelocate(x, y, this.getSashWidth(), h);
                width = w - (x += this.getSashWidth());
                ((Node)children.get(children.size() - 1)).resizeRelocate((double)x, (double)y, (double)width, (double)h);
            }
        } else {
            int height = (int)(ratios[0] * (long)(h - this.sashes.length * this.getSashWidth()) / total);
            ((Node)children.get(0)).resizeRelocate((double)x, (double)y, (double)w, (double)height);
            y += height;
            int i5 = 1;
            while (i5 < children.size() - 1) {
                this.sashes[i5 - 1].resizeRelocate(x, y, w, this.getSashWidth());
                height = (int)(ratios[i5] * (long)(h - this.sashes.length * this.getSashWidth()) / total);
                ((Node)children.get(i5)).resizeRelocate((double)x, (double)(y += this.getSashWidth()), (double)w, (double)height);
                y += height;
                ++i5;
            }
            if (children.size() > 1) {
                this.sashes[this.sashes.length - 1].resizeRelocate(x, y, w, this.getSashWidth());
                height = h - (y += this.getSashWidth());
                ((Node)children.get(children.size() - 1)).resizeRelocate((double)x, (double)y, (double)w, (double)height);
            }
        }
        this.clientArea = b;
    }

    private void handleDragSash(MouseEvent e) {
        e.consume();
        Rectangle rectangle = new Rectangle(this.getWidth(), this.getHeight(), this.getInsets());
        if (this.horizontal.get()) {
            Object data2;
            Object data1;
            double delta = e.getScreenX() - this.start;
            long newSize_1 = (long)(this.resize_1 + delta);
            long newSize_2 = (long)(this.resize_2 - delta);
            if (newSize_1 < 20L) {
                newSize_2 = (long)this.resize_total - 20L;
                newSize_1 = 20L;
            }
            if (newSize_2 < 20L) {
                newSize_1 = (long)this.resize_total - 20L;
                newSize_2 = 20L;
            }
            if ((data1 = this.c1.getProperties().get((Object)LAYOUT_KEY)) == null || !(data1 instanceof SashFormData)) {
                data1 = new SashFormData();
                this.c1.getProperties().put((Object)LAYOUT_KEY, data1);
            }
            if ((data2 = this.c2.getProperties().get((Object)LAYOUT_KEY)) == null || !(data2 instanceof SashFormData)) {
                data2 = new SashFormData();
                this.c2.getProperties().put((Object)LAYOUT_KEY, data2);
            }
            ((SashFormData)data1).weight = ((newSize_1 << 16) + (long)rectangle.width - 1L) / (long)rectangle.width;
            ((SashFormData)data2).weight = ((newSize_2 << 16) + (long)rectangle.width - 1L) / (long)rectangle.width;
            this.c1.resize((double)newSize_1, (double)rectangle.height);
            this.c2.resizeRelocate(this.c1.getLayoutX() + (double)newSize_1 + (double)this.getSashWidth(), this.c2.getLayoutY(), (double)newSize_2, (double)rectangle.height);
            this.draggedSash.relocate(this.c1.getLayoutX() + (double)newSize_1, this.draggedSash.getLayoutY());
        } else {
            Object data2;
            double delta = e.getScreenY() - this.start;
            long newSize_1 = (long)(this.resize_1 + delta);
            long newSize_2 = (long)(this.resize_2 - delta);
            Object data1 = this.c1.getProperties().get((Object)LAYOUT_KEY);
            if (data1 == null || !(data1 instanceof SashFormData)) {
                data1 = new SashFormData();
                this.c1.getProperties().put((Object)LAYOUT_KEY, data1);
            }
            if ((data2 = this.c2.getProperties().get((Object)LAYOUT_KEY)) == null || !(data2 instanceof SashFormData)) {
                data2 = new SashFormData();
                this.c2.getProperties().put((Object)LAYOUT_KEY, data2);
            }
            ((SashFormData)data1).weight = ((newSize_1 << 16) + (long)rectangle.height - 1L) / (long)rectangle.height;
            ((SashFormData)data2).weight = ((newSize_2 << 16) + (long)rectangle.height - 1L) / (long)rectangle.height;
            this.c1.resize((double)rectangle.width, (double)newSize_1);
            this.c2.resizeRelocate(this.c2.getLayoutX(), this.c1.getLayoutY() + (double)newSize_1 + (double)this.getSashWidth(), (double)rectangle.width, (double)newSize_2);
            this.draggedSash.relocate(this.draggedSash.getLayoutX(), this.c1.getLayoutY() + (double)newSize_1);
        }
        this.requestLayout();
    }

    private void handlePressedSash(MouseEvent e) {
        e.consume();
        Sash sash = (Sash)((Object)e.getSource());
        int sashIndex = -1;
        int i = 0;
        while (i < this.sashes.length) {
            if (this.sashes[i] == sash) {
                sashIndex = i;
                break;
            }
            ++i;
        }
        if (sashIndex == -1) {
            return;
        }
        this.start = this.horizontal.get() ? e.getScreenX() : e.getScreenY();
        this.draggedSash = sash;
        this.c1 = (Node)this.getManagedChildren().get(sashIndex);
        Bounds b = this.c1.getLayoutBounds();
        this.resize_1 = this.horizontal.get() ? b.getWidth() : b.getHeight();
        this.c2 = (Node)this.getManagedChildren().get(sashIndex + 1);
        b = this.c2.getLayoutBounds();
        this.resize_2 = this.horizontal.get() ? b.getWidth() : b.getHeight();
        this.resize_total = this.resize_1 + this.resize_2;
    }

    private Sash createSash() {
        Sash sash = new Sash();
        sash.setOnMousePressed(this::handlePressedSash);
        sash.setOnMouseDragged(this::handleDragSash);
        this.getChildren().add((Object)sash);
        return sash;
    }

    public void setWeights(int[] weights) {
        List children = this.getManagedChildren();
        if (weights == null || weights.length != children.size()) {
            throw new IllegalArgumentException();
        }
        int total = 0;
        int i = 0;
        while (i < weights.length) {
            if (weights[i] < 0) {
                throw new IllegalArgumentException();
            }
            total += weights[i];
            ++i;
        }
        if (total == 0) {
            throw new IllegalArgumentException();
        }
        i = 0;
        while (i < children.size()) {
            Object data = ((Node)children.get(i)).getProperties().get((Object)LAYOUT_KEY);
            if (data == null || !(data instanceof SashFormData)) {
                data = new SashFormData();
                ((Node)children.get(i)).getProperties().put((Object)LAYOUT_KEY, data);
            }
            ((SashFormData)data).weight = (((long)weights[i] << 16) + (long)total - 1L) / (long)total;
            ++i;
        }
        this.clearCache();
        this.requestLayout();
    }

    public int[] getWeights() {
        List children = this.getManagedChildren();
        int[] ratios = new int[children.size()];
        int i = 0;
        while (i < children.size()) {
            Object data = ((Node)children.get(i)).getProperties().get((Object)LAYOUT_KEY);
            ratios[i] = data != null && data instanceof SashFormData ? (int)(((SashFormData)data).weight * 1000L >> 16) : 200;
            ++i;
        }
        return ratios;
    }

    public final BooleanProperty horizontalProperty() {
        return this.horizontal;
    }

    public final boolean isHorizontal() {
        return this.horizontalProperty().get();
    }

    public final void setHorizontal(boolean horizontal) {
        this.horizontalProperty().set(horizontal);
    }

    public final IntegerProperty sashWidthProperty() {
        return this.sashWidth;
    }

    public final int getSashWidth() {
        return this.sashWidthProperty().get();
    }

    public final void setSashWidth(int sashWidth) {
        this.sashWidthProperty().set(sashWidth);
    }

    static class Rectangle {
        int x;
        int y;
        int width;
        int height;

        public Rectangle(double width, double height, Insets insets) {
            this.x = (int)Math.ceil(insets.getLeft());
            this.y = (int)Math.ceil(insets.getTop());
            this.width = (int)Math.floor(width) - (int)Math.ceil(insets.getLeft()) - (int)Math.ceil(insets.getRight());
            this.height = (int)Math.floor(height) - (int)Math.ceil(insets.getTop()) - (int)Math.ceil(insets.getBottom());
        }

        public Rectangle(Bounds b) {
            this.x = (int)Math.ceil(b.getMinX());
            this.y = (int)Math.ceil(b.getMinY());
            this.width = (int)Math.floor(b.getWidth());
            this.height = (int)Math.floor(b.getHeight());
        }
    }

    static class Sash
    extends Region {
        public Sash() {
            this.getStyleClass().add((Object)"sash");
            this.setManaged(false);
            this.setMouseTransparent(false);
        }
    }

    static class SashChild
    extends StackPane {
        private javafx.scene.shape.Rectangle r = new javafx.scene.shape.Rectangle();

        public SashChild(Node c) {
            this.getChildren().add((Object)c);
            this.setClip((Node)this.r);
        }

        public void resize(double width, double height) {
            super.resize(width, height);
            this.r.setWidth(width);
            this.r.setHeight(height);
        }
    }

    static class SashFormData {
        public long weight;

        SashFormData() {
        }
    }
}

