/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xtend.type.baseimpl.types;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.internal.xtend.type.baseimpl.OperationImpl;
import org.eclipse.internal.xtend.type.baseimpl.PropertyImpl;
import org.eclipse.internal.xtend.type.baseimpl.types.BuiltinBaseType;
import org.eclipse.internal.xtend.util.StringHelper;
import org.eclipse.xtend.expression.TypeSystem;
import org.eclipse.xtend.typesystem.Feature;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringTypeImpl
extends BuiltinBaseType {
    final Log log = LogFactory.getLog(this.getClass());

    public StringTypeImpl(TypeSystem ts, String name) {
        super(ts, name);
    }

    @Override
    public boolean isInstance(Object o) {
        return o instanceof String || o instanceof StringBuffer || o instanceof Character;
    }

    @Override
    public Object newInstance() {
        return "";
    }

    @Override
    public Feature[] getContributedFeatures() {
        return new Feature[]{new PropertyImpl(this, "length", this.getTypeSystem().getIntegerType()){

            public String getDocumentation() {
                return "the length of this string";
            }

            public Object get(Object target) {
                return new Long(target.toString().length());
            }
        }, new OperationImpl(this, "+", this.getTypeSystem().getStringType(), new Type[]{this.getTypeSystem().getObjectType()}){

            public String getDocumentation() {
                return "concatenates two strings";
            }

            public Object evaluateInternal(Object target, Object[] params) {
                return String.valueOf(target.toString()) + params[0];
            }
        }, new OperationImpl(this, "startsWith", this.getTypeSystem().getBooleanType(), new Type[]{this.getTypeSystem().getStringType()}){

            public String getDocumentation() {
                return "Tests if this string starts with the specified prefix.";
            }

            public Object evaluateInternal(Object target, Object[] params) {
                String token = (String)params[0];
                return new Boolean(target.toString().startsWith(token));
            }
        }, new OperationImpl(this, "contains", this.getTypeSystem().getBooleanType(), new Type[]{this.getTypeSystem().getStringType()}){

            public String getDocumentation() {
                return "Tests if this string contains substring.";
            }

            public Object evaluateInternal(Object target, Object[] params) {
                String token = (String)params[0];
                return new Boolean(target.toString().indexOf(token) >= 0);
            }
        }, new OperationImpl(this, "endsWith", this.getTypeSystem().getBooleanType(), new Type[]{this.getTypeSystem().getStringType()}){

            public String getDocumentation() {
                return "Tests if this string ends with the specified prefix.";
            }

            public Object evaluateInternal(Object target, Object[] params) {
                String token = (String)params[0];
                return new Boolean(target.toString().endsWith(token));
            }
        }, new OperationImpl(this, "subString", this.getTypeSystem().getStringType(), new Type[]{this.getTypeSystem().getIntegerType(), this.getTypeSystem().getIntegerType()}){

            public String getDocumentation() {
                return "Returns a new string that is a substring of this string.";
            }

            public Object evaluateInternal(Object target, Object[] params) {
                Number from = (Number)params[0];
                Number to = (Number)params[1];
                return target.toString().substring(from.intValue(), to.intValue());
            }
        }, new OperationImpl(this, "toUpperCase", this.getTypeSystem().getStringType(), new Type[0]){

            public String getDocumentation() {
                return "Converts all of the characters in this String to upper case using the rules of the default locale (from Java)";
            }

            public Object evaluateInternal(Object target, Object[] params) {
                return target.toString().toUpperCase();
            }
        }, new OperationImpl(this, "toLowerCase", this.getTypeSystem().getStringType(), new Type[0]){

            public String getDocumentation() {
                return "Converts all of the characters in this String to lower case using the rules of the default locale (from Java)";
            }

            public Object evaluateInternal(Object target, Object[] params) {
                return target.toString().toLowerCase();
            }
        }, new OperationImpl(this, "toFirstUpper", this.getTypeSystem().getStringType(), new Type[0]){

            public String getDocumentation() {
                return "Converts the first character in this String to upper case using the rules of the default locale (from Java)";
            }

            public Object evaluateInternal(Object target, Object[] params) {
                return StringHelper.firstUpper(target.toString());
            }
        }, new OperationImpl(this, "toFirstLower", this.getTypeSystem().getStringType(), new Type[0]){

            public String getDocumentation() {
                return "Converts the first character in this String to lower case using the rules of the default locale (from Java)";
            }

            public Object evaluateInternal(Object target, Object[] params) {
                return StringHelper.firstLower(target.toString());
            }
        }, new OperationImpl(this, "toCharList", this.getTypeSystem().getListType(this.getTypeSystem().getStringType()), new Type[0]){

            public String getDocumentation() {
                return "splits this String into a List[String] containing Strings of length 1";
            }

            public Object evaluateInternal(Object target, Object[] params) {
                String txt = target.toString();
                ArrayList<String> result = new ArrayList<String>();
                char[] chars = txt.toCharArray();
                int i = 0;
                while (i < chars.length) {
                    result.add(String.valueOf(chars[i]));
                    ++i;
                }
                return result;
            }
        }, new OperationImpl(this, "replaceAll", this.getTypeSystem().getStringType(), new Type[]{this.getTypeSystem().getStringType(), this.getTypeSystem().getStringType()}){

            public String getDocumentation() {
                return "Replaces each substring of this string that matches the given regular expression with the given replacement.";
            }

            public Object evaluateInternal(Object target, Object[] params) {
                return target.toString().replaceAll(params[0].toString(), params[1].toString());
            }
        }, new OperationImpl(this, "replaceFirst", this.getTypeSystem().getStringType(), new Type[]{this.getTypeSystem().getStringType(), this.getTypeSystem().getStringType()}){

            public String getDocumentation() {
                return "Replaces the first substring of this string that matches the given regular expression with the given replacement.";
            }

            public Object evaluateInternal(Object target, Object[] params) {
                return target.toString().replaceFirst(params[0].toString(), params[1].toString());
            }
        }, new OperationImpl(this, "split", this.getTypeSystem().getListType(this.getTypeSystem().getStringType()), new Type[]{this.getTypeSystem().getStringType()}){

            public String getDocumentation() {
                return "Splits this string around matches of the given regular expression (from Java 1.4)";
            }

            public Object evaluateInternal(Object target, Object[] params) {
                return new ArrayList<String>(Arrays.asList(target.toString().split(params[0].toString())));
            }
        }, new OperationImpl(this, "matches", this.getTypeSystem().getBooleanType(), new Type[]{this.getTypeSystem().getStringType()}){

            public String getDocumentation() {
                return "Tells whether or not this string matches the given regular expression. (from Java 1.4)";
            }

            public Object evaluateInternal(Object target, Object[] params) {
                return ((String)target).matches((String)params[0]);
            }
        }, new OperationImpl(this, "trim", this.getTypeSystem().getStringType(), new Type[0]){

            public String getDocumentation() {
                return "Returns a copy of the string, with leading and trailing whitespace omitted. (from Java 1.4)";
            }

            public Object evaluateInternal(Object target, Object[] params) {
                return ((String)target).trim();
            }
        }, new OperationImpl(this, "asInteger", this.getTypeSystem().getIntegerType(), new Type[0]){

            public String getDocumentation() {
                return "Returns an Integer object holding the value of the specified String (from Java 1.5)";
            }

            public Object evaluateInternal(Object target, Object[] params) {
                try {
                    return new BigInteger((String)target);
                }
                catch (NumberFormatException nfe) {
                    StringTypeImpl.this.log.error((Object)("'asInteger' on '" + target + "' returned null!"));
                    return null;
                }
            }
        }};
    }

    public Set<Type> getSuperTypes() {
        return Collections.singleton(this.getTypeSystem().getObjectType());
    }

    private String toString(Object o) {
        if (o == null) {
            return null;
        }
        if (this.isInstance(o)) {
            return o.toString();
        }
        throw new IllegalArgumentException(String.valueOf(o.getClass().getName()) + " not supported");
    }

    @Override
    public Object convert(Object src, Class<?> targetType) {
        String s = this.toString(src);
        if (String.class.equals(targetType)) {
            return s;
        }
        if (Character.class.equals(targetType) || Character.TYPE.equals(targetType)) {
            if (s.length() == 1) {
                return new Character(s.charAt(0));
            }
        } else if (StringBuffer.class.equals(targetType)) {
            return new StringBuffer(s);
        }
        return super.convert(src, targetType);
    }
}

