/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util.concurrent;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.xtext.util.concurrent.IReadAccess;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public abstract class AbstractReadWriteAcces<P>
implements IReadAccess<P> {
    private static Logger log = Logger.getLogger(AbstractReadWriteAcces.class);
    protected final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    protected final Lock writeLock = this.rwLock.writeLock();
    protected final Lock readLock = this.rwLock.readLock();
    private ThreadLocal<Integer> readLockCount = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };

    protected abstract P getState();

    @Override
    public <T> T readOnly(IUnitOfWork<T, P> work) {
        this.acquireReadLock();
        try {
            P state = this.getState();
            this.beforeReadOnly(state, work);
            T exec = work.exec(state);
            this.afterReadOnly(state, exec, work);
            T t = exec;
            return t;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WrappedException(e);
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T modify(IUnitOfWork<T, P> work) {
        this.acquireWriteLock();
        P state = null;
        T exec = null;
        try {
            state = this.getState();
            this.beforeModify(state, work);
            T t = exec = (T)work.exec(state);
            return t;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WrappedException(e);
        }
        finally {
            this.releaseWriteLock();
            try {
                this.acquireReadLock();
                this.afterModify(state, exec, work);
            }
            finally {
                this.releaseReadLock();
            }
        }
    }

    public <T> T process(IUnitOfWork<T, P> work) {
        this.releaseReadLock();
        this.acquireWriteLock();
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)("process - " + Thread.currentThread().getName()));
            }
            T t = this.modify(work);
            return t;
        }
        finally {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Downgrading from write lock to read lock...");
            }
            this.acquireReadLock();
            this.releaseWriteLock();
        }
    }

    protected void beforeModify(P state, IUnitOfWork<?, P> work) {
    }

    protected void beforeReadOnly(P state, IUnitOfWork<?, P> work) {
    }

    protected void afterModify(P state, Object result, IUnitOfWork<?, P> work) {
    }

    protected void afterReadOnly(P state, Object result, IUnitOfWork<?, P> work) {
    }

    protected int getWriteHoldCount() {
        return this.rwLock.getWriteHoldCount();
    }

    protected int getReadHoldCount() {
        return this.readLockCount.get();
    }

    private void acquireReadLock() {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Trying to acquire read lock...");
        }
        this.readLock.lock();
        this.readLockCount.set(this.readLockCount.get() + 1);
        if (log.isTraceEnabled()) {
            log.trace((Object)"...read lock acquired.");
        }
    }

    private void releaseReadLock() {
        this.readLock.unlock();
        this.readLockCount.set(this.readLockCount.get() - 1);
        if (log.isTraceEnabled()) {
            log.trace((Object)"Read lock released.");
        }
    }

    private void acquireWriteLock() {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Trying to acquire write lock...");
        }
        this.writeLock.lock();
        if (log.isTraceEnabled()) {
            log.trace((Object)"...write lock acquired.");
        }
    }

    private void releaseWriteLock() {
        this.writeLock.unlock();
        if (log.isTraceEnabled()) {
            log.trace((Object)"Write lock released.");
        }
    }
}

