/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.image.skin;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import org.eclipse.fx.ui.controls.image.FontIcon;
import org.eclipse.fx.ui.controls.image.FontIconView;
import org.eclipse.fx.ui.controls.image.spi.IconFontLookup;
import org.eclipse.fx.ui.controls.image.spi.IconFontProvider;
import org.eclipse.jdt.annotation.NonNull;

public class FontIconViewSkin
extends SkinBase<FontIconView> {
    private Text text = new Text();

    public FontIconViewSkin(@NonNull FontIconView control) {
        super((Control)control);
        this.text.setMouseTransparent(true);
        this.getChildren().add((Object)this.text);
        this.text.fontProperty().bind(((FontIconView)this.getSkinnable()).fontProperty());
        this.text.fillProperty().bind(((FontIconView)this.getSkinnable()).iconFillProperty());
        ((FontIconView)this.getSkinnable()).fontProperty().addListener((ChangeListener)new ChangeListener<Font>(){

            public void changed(ObservableValue<? extends Font> observable, Font oldValue, Font newValue) {
                FontIconViewSkin.this.updateIcon(((FontIconView)FontIconViewSkin.this.getSkinnable()).getIcon(), newValue);
            }
        });
        ((FontIconView)this.getSkinnable()).iconProperty().addListener((ChangeListener)new ChangeListener<FontIcon>(){

            public void changed(ObservableValue<? extends FontIcon> observable, FontIcon oldValue, FontIcon newValue) {
                FontIconViewSkin.this.updateIcon(newValue, ((FontIconView)FontIconViewSkin.this.getSkinnable()).getFont());
            }
        });
        this.text.setText(FontIconViewSkin.convert(((FontIconView)this.getSkinnable()).getIcon(), ((FontIconView)this.getSkinnable()).getFont()));
    }

    void updateIcon(FontIcon icon, Font font) {
        this.text.setText(FontIconViewSkin.convert(icon, font));
    }

    private static String convert(FontIcon icon, Font font) {
        if (icon != null) {
            if (icon.getIconCode() != '0') {
                return Character.toString(icon.getIconCode());
            }
            IconFontProvider sup = FontIconViewSkin.getSupportForFont(font);
            if (sup != null) {
                char v = sup.map(icon.getIconName());
                return Character.toString(v);
            }
        }
        return "?";
    }

    private static IconFontProvider getSupportForFont(Font font) {
        return IconFontLookup.getProviderForFont(font);
    }
}

