/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.css.validation;

import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.fx.ide.css.cssDsl.CssDslPackage;
import org.eclipse.fx.ide.css.cssDsl.CssTok;
import org.eclipse.fx.ide.css.cssDsl.IdentifierTok;
import org.eclipse.fx.ide.css.cssDsl.SymbolTok;
import org.eclipse.fx.ide.css.cssDsl.UrlTok;
import org.eclipse.fx.ide.css.cssDsl.WSTok;
import org.eclipse.fx.ide.css.cssDsl.css_declaration;
import org.eclipse.fx.ide.css.cssDsl.css_property;
import org.eclipse.fx.ide.css.cssDsl.font_face;
import org.eclipse.fx.ide.css.cssDsl.ruleset;
import org.eclipse.fx.ide.css.cssDsl.selector;
import org.eclipse.fx.ide.css.extapi.CssExt;
import org.eclipse.fx.ide.css.extapi.Proposal;
import org.eclipse.fx.ide.css.util.Utils;
import org.eclipse.fx.ide.css.validation.AbstractCssDslJavaValidator;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.validation.Check;

public class CssDslJavaValidator
extends AbstractCssDslJavaValidator {
    private static final List<String> PREDEFINED_VAR_PROPS = Arrays.asList("-fx-base", "-fx-background", "-fx-control-inner-background", "-fx-control-inner-background-alt", "-fx-dark-text-color", "-fx-mid-text-color", "-fx-light-text-color", "-fx-accent", "-fx-default-button", "-fx-focus-color", "-fx-faint-focus-color", "-fx-color", "CHART_COLOR_1", "CHART_COLOR_2", "CHART_COLOR_3", "CHART_COLOR_4", "CHART_COLOR_5", "CHART_COLOR_6", "CHART_COLOR_7", "CHART_COLOR_8", "CHART_COLOR_1_TRANS_20", "CHART_COLOR_2_TRANS_20", "CHART_COLOR_3_TRANS_20", "CHART_COLOR_4_TRANS_20", "CHART_COLOR_5_TRANS_20", "CHART_COLOR_6_TRANS_20", "CHART_COLOR_7_TRANS_20", "CHART_COLOR_8_TRANS_20", "CHART_COLOR_1_TRANS_70", "CHART_COLOR_2_TRANS_70", "CHART_COLOR_3_TRANS_70", "CHART_COLOR_4_TRANS_70", "CHART_COLOR_5_TRANS_70", "CHART_COLOR_6_TRANS_70", "CHART_COLOR_7_TRANS_70", "CHART_COLOR_8_TRANS_70", "-fx-hover-base", "-fx-pressed-base", "-fx-text-background-color", "-fx-box-border", "-fx-text-box-border", "-fx-shadow-highlight-color", "-fx-outer-border", "-fx-inner-border", "-fx-inner-border-horizontal", "-fx-inner-border-bottomup", "-fx-body-color", "-fx-body-color-bottomup", "-fx-body-color-to-right", "-fx-text-base-color", "-fx-text-inner-color", "-fx-mark-color", "-fx-mark-highlight-color", "-fx-selection-bar", "-fx-selection-bar-non-focused", "-fx-selection-bar-text", "-fx-cell-hover-color", "-fx-cell-focus-inner-border", "-fx-cell-focus-inner-border", "-fx-page-bullet-border", "-fx-page-indicator-hover-border", "-fx-focused-text-base-color", "-fx-focused-mark-color");
    @Inject
    private CssExt ext;

    private boolean filterWS(CssTok t) {
        return !(t instanceof WSTok);
    }

    private boolean filterSymbol(CssTok t) {
        return !(t instanceof SymbolTok);
    }

    @Check
    public void checkProperty(css_property property) {
    }

    @Check
    public void checkDeclaration(css_declaration dec) {
        boolean validate;
        IFile file;
        css_property property;
        block39: {
            property = dec.getProperty();
            file = Utils.getFile(dec.eResource());
            validate = false;
            try {
                block38: {
                    if (file.getProject().hasNature("org.eclipse.pde.PluginNature")) {
                        IFile properties = PDEProject.getBuildProperties((IProject)file.getProject());
                        Properties p = new Properties();
                        try {
                            Throwable throwable = null;
                            Object var8_13 = null;
                            try (InputStream in = properties.getContents();){
                                p.load(in);
                                String includes = p.getProperty("bin.includes");
                                if (includes == null) break block38;
                                IPath path = file.getProjectRelativePath();
                                String[] stringArray = includes.split(",");
                                int n = stringArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String s = stringArray[n2];
                                    if (path.toString().startsWith(s.trim())) {
                                        validate = true;
                                        break;
                                    }
                                    ++n2;
                                }
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (validate || !file.getProject().hasNature("org.eclipse.jdt.core.javanature")) break block39;
                IJavaProject jp = JavaCore.create((IProject)file.getProject());
                IPackageFragmentRoot[] iPackageFragmentRootArray = jp.getPackageFragmentRoots();
                int n = iPackageFragmentRootArray.length;
                int e = 0;
                while (e < n) {
                    IPackageFragmentRoot r = iPackageFragmentRootArray[e];
                    if (r.getKind() == 1 && file.getProjectRelativePath().toString().startsWith(r.getPath().removeFirstSegments(1).toString())) {
                        validate = true;
                        break;
                    }
                    ++e;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        if (!validate) {
            return;
        }
        if (dec.eContainer() instanceof font_face) {
            if ("font-family".equals(property.getName())) {
                if (dec.getValueTokens().stream().filter(this::filterWS).count() != 1L) {
                    this.error("Font family has to define a name", dec, (EStructuralFeature)CssDslPackage.Literals.CSS_DECLARATION__VALUE_TOKENS);
                } else if (!(dec.getValueTokens().stream().filter(this::filterWS).findFirst().get() instanceof IdentifierTok)) {
                    CssTok tok = dec.getValueTokens().stream().filter(this::filterWS).findFirst().get();
                    this.error("Invalid font family name", dec, (EStructuralFeature)CssDslPackage.Literals.CSS_DECLARATION__VALUE_TOKENS, dec.getValueTokens().indexOf((Object)tok));
                }
            } else if ("src".equals(property.getName())) {
                if (dec.getValueTokens().stream().filter(this::filterWS).count() == 0L) {
                    this.error("At least one URL is required", dec, (EStructuralFeature)CssDslPackage.Literals.CSS_DECLARATION__VALUE_TOKENS);
                } else {
                    dec.getValueTokens().stream().filter(this::filterWS).filter(this::filterSymbol).filter(t -> !(t instanceof UrlTok)).forEach(t -> this.error("Only url-values are allowed", dec, (EStructuralFeature)CssDslPackage.Literals.CSS_DECLARATION__VALUE_TOKENS, dec.getValueTokens().indexOf(t)));
                }
            } else if (!("font-stretch".equals(property.getName()) || "font-style".equals(property.getName()) || "font-weight".equals(property.getName()) || "unicode-range".equals(property.getName()))) {
                this.warning("Unknown property: \"" + property.getName() + "\"", property, (EStructuralFeature)CssDslPackage.Literals.CSS_PROPERTY__NAME);
            }
            return;
        }
        List<Proposal> properties = this.ext.getPropertyProposalsForSelector(file, dec, null);
        boolean known = false;
        for (Proposal p : properties) {
            if (!p.getProposal().equals(property.getName())) continue;
            known = true;
            break;
        }
        if (!known) {
            ICompositeNode node = NodeModelUtils.getNode((EObject)dec.getProperty());
            boolean suppress = node.getText().contains("@SuppressWarning");
            if (!(suppress || PREDEFINED_VAR_PROPS.contains(property.getName()) || property.getName().startsWith("-var"))) {
                this.warning("Unknown property: \"" + property.getName() + "\"", property, (EStructuralFeature)CssDslPackage.Literals.CSS_PROPERTY__NAME);
            }
        } else {
            ruleset rs = (ruleset)dec.eContainer();
            EList<selector> selectors = rs.getSelectors();
            List<Proposal> selectorProps = this.ext.getPropertyProposalsForSelector(Utils.getFile(dec.eResource()), dec, (List<selector>)selectors);
            if (selectorProps.size() > 0) {
                boolean supported = false;
                for (Proposal p : selectorProps) {
                    if (!p.getProposal().equals(property.getName())) continue;
                    supported = true;
                    break;
                }
                if (!supported) {
                    ICompositeNode node = NodeModelUtils.getNode((EObject)dec.getProperty());
                    boolean suppress = node.getText().contains("@SuppressWarning");
                    if (!PREDEFINED_VAR_PROPS.contains(property.getName()) && !property.getName().startsWith("-var")) {
                        this.warning("\"" + property.getName() + "\" is not supported by the given selectors", (EStructuralFeature)CssDslPackage.Literals.CSS_DECLARATION__PROPERTY);
                    }
                }
            }
        }
    }
}

