/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.internal.registry;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.egf.common.l10n.EGFCommonMessages;
import org.eclipse.egf.model.EGFModelPlugin;
import org.eclipse.egf.model.pattern.PatternNature;
import org.eclipse.egf.pattern.EGFPatternPlugin;
import org.eclipse.egf.pattern.extension.PatternExtension;
import org.eclipse.egf.pattern.internal.registry.PatternExtensionProxy;
import org.eclipse.egf.pattern.l10n.EGFPatternMessages;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PatternExtensionRegistry
implements IRegistryEventListener {
    private Map<String, PatternExtensionProxy> _proxies;
    public static final String EXTENSION_ID = "org.eclipse.egf.pattern.extension";
    public static final String ATT_NATURE = "nature";
    public static final String ATT_CLASS = "class";

    public PatternExtensionRegistry() {
        this.initialize();
        RegistryFactory.getRegistry().addListener((IRegistryEventListener)this, EXTENSION_ID);
    }

    public Set<String> getPatternNatures() {
        return this._proxies.keySet();
    }

    public PatternExtension getPatternExtension(PatternNature nature) throws CoreException {
        PatternExtensionProxy proxy = this._proxies.get(nature.eClass().getName());
        if (proxy == null) {
            throw new CoreException(EGFModelPlugin.getPlugin().newStatus(4, NLS.bind((String)EGFPatternMessages.PatternExtensionRegistry_extension_error, (Object)nature.eClass().getInstanceTypeName()), null));
        }
        return proxy.getPatternExtension();
    }

    public PatternExtension getPatternExtension(String name) throws CoreException {
        for (PatternExtensionProxy proxy : this._proxies.values()) {
            if (!name.equals(proxy.getName())) continue;
            return proxy.getPatternExtension();
        }
        return null;
    }

    private void initialize() {
        if (this._proxies != null) {
            return;
        }
        this._proxies = new HashMap<String, PatternExtensionProxy>();
        IExtensionPoint point = RegistryFactory.getRegistry().getExtensionPoint(EXTENSION_ID);
        if (point != null) {
            IExtension[] iExtensionArray = point.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    this.register(element);
                    ++n4;
                }
                ++n2;
            }
        }
    }

    private void register(IConfigurationElement element) {
        if (element == null) {
            return;
        }
        PatternExtensionProxy proxy = PatternExtensionProxy.createProxy(element);
        if (proxy != null) {
            if (this._proxies.get(proxy.getName()) != null) {
                EGFPatternPlugin.getDefault().logError(NLS.bind((String)EGFCommonMessages.Duplicate_Element_Message, (Object)proxy.getNature()));
                EGFPatternPlugin.getDefault().logInfo(NLS.bind((String)EGFCommonMessages.Bundle_Message, (Object)element.getContributor().getName()), 1);
                EGFPatternPlugin.getDefault().logInfo(NLS.bind((String)EGFCommonMessages.Extension_Point_Message, (Object)element.getName()), 1);
            }
            this._proxies.put(proxy.getName(), proxy);
        }
    }

    public void added(IExtension[] extensions) {
        if (extensions == null) {
            return;
        }
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                this.register(element);
                ++n4;
            }
            ++n2;
        }
    }

    public void removed(IExtension[] extensions) {
        int i = 0;
        while (i < extensions.length) {
            Iterator<PatternExtensionProxy> it = this._proxies.values().iterator();
            while (it.hasNext()) {
                PatternExtensionProxy proxy = it.next();
                if (!proxy.originatesFrom(extensions[i])) continue;
                it.remove();
            }
            ++i;
        }
    }

    public void added(IExtensionPoint[] extensionPoints) {
    }

    public void removed(IExtensionPoint[] extensionPoints) {
    }

    public void dispose() {
        RegistryFactory.getRegistry().removeListener((IRegistryEventListener)this);
        this._proxies = null;
    }
}

