/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.debug.grandom.generators;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import org.eclipse.elk.core.debug.grandom.generators.BlindTextGenerator;
import org.eclipse.elk.core.debug.grandom.generators.GeneratorOptions;
import org.eclipse.elk.core.math.ElkMath;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.util.Pair;
import org.eclipse.elk.graph.ElkConnectableShape;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkGraphElement;
import org.eclipse.elk.graph.ElkLabel;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.ElkPort;
import org.eclipse.elk.graph.impl.ElkNodeImpl;
import org.eclipse.elk.graph.impl.ElkPortImpl;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.util.ElkGraphUtil;

public class RandomGraphGenerator {
    public static final float PORT_SEPARATION = 7.0f;
    private static final int MAX_ITER = 12;
    private GeneratorOptions options;
    private Random random;
    private int nodeLabelCounter;
    private int portLabelCounter;
    private int maxHierarchyLevel;
    private final EdgeCondition basicCondition = new EdgeCondition(){

        @Override
        public boolean evaluate(ElkNode node1, ElkNode node2) {
            if (!((Boolean)RandomGraphGenerator.this.get(GeneratorOptions.SELF_LOOPS)).booleanValue() && node1 == node2) {
                return false;
            }
            if (!((Boolean)RandomGraphGenerator.this.get(GeneratorOptions.MULTI_EDGES)).booleanValue() && RandomGraphGenerator.connected(node1, node2)) {
                return false;
            }
            return (Boolean)RandomGraphGenerator.this.get(GeneratorOptions.CYCLES) != false || !RandomGraphGenerator.findNodeWithDFS(node2, node1);
        }
    };

    public RandomGraphGenerator(Random random) {
        this.random = random;
    }

    public ElkNode generate(GeneratorOptions opts) {
        this.nodeLabelCounter = 0;
        this.portLabelCounter = 0;
        this.options = opts;
        ElkNode parent = ElkGraphUtil.createGraph();
        this.maxHierarchyLevel = this.get(GeneratorOptions.MAX_HIERARCHY_LEVEL).intVal(this.random);
        if (this.get(GeneratorOptions.SMALL_HIERARCHY).booleanValue()) {
            List<List<ElkNode>> atomicNodesOnLevels = this.addHierarchicalNodes(parent);
            this.connectAtomicNodesOnDifferentLevels(atomicNodesOnLevels);
            return parent;
        }
        return this.makeGraph(parent);
    }

    private List<List<ElkNode>> addHierarchicalNodes(ElkNode parent) {
        ArrayList<List<ElkNode>> atomicNodes = new ArrayList<List<ElkNode>>();
        LinkedList<ElkNode> allGraphs = new LinkedList<ElkNode>();
        allGraphs.push(parent);
        int i = 0;
        while (i < this.maxHierarchyLevel) {
            ArrayList<ElkNode> hierarchicalNodes = new ArrayList<ElkNode>();
            while (!allGraphs.isEmpty()) {
                ElkNode p = (ElkNode)allGraphs.pop();
                this.makeGraph(p);
                if (!p.getChildren().isEmpty()) {
                    atomicNodes.add(new ArrayList(p.getChildren()));
                }
                if (i >= this.maxHierarchyLevel - 1) continue;
                int numHierarch = this.get(GeneratorOptions.NUMBER_HIERARCHICAL_NODES).intVal(this.random);
                hierarchicalNodes.addAll(this.createIndependentSet(p, numHierarch));
            }
            for (ElkNode node : hierarchicalNodes) {
                allGraphs.push(node);
            }
            ++i;
        }
        return atomicNodes;
    }

    private void connectAtomicNodesOnDifferentLevels(List<List<ElkNode>> atomicNodes) {
        int numCrossHier;
        if (this.get(GeneratorOptions.EXACT_RELATIVE_HIER) != null) {
            HashSet newHashSet = Sets.newHashSet();
            for (List<ElkNode> level : atomicNodes) {
                for (ElkNode node : level) {
                    newHashSet.addAll(node.getIncomingEdges());
                    newHashSet.addAll(node.getOutgoingEdges());
                }
            }
            numCrossHier = (int)((double)newHashSet.size() * this.get(GeneratorOptions.EXACT_RELATIVE_HIER).val(this.random));
        } else {
            numCrossHier = this.get(GeneratorOptions.CROSS_HIER).intVal(this.random);
        }
        if (atomicNodes.size() < 2) {
            return;
        }
        int i = 0;
        while (i < numCrossHier) {
            if (atomicNodes.size() > 1) {
                List<List<ElkNode>> levels = this.sample(atomicNodes, 2);
                this.connect((ElkConnectableShape)this.sample(levels.get(0), 1).get(0), (ElkConnectableShape)this.sample(levels.get(1), 1).get(0));
            }
            ++i;
        }
    }

    private <T> List<T> sample(List<T> list, int number) {
        ArrayList<T> shuffleThis = new ArrayList<T>(list);
        Collections.shuffle(shuffleThis);
        if (number > list.size()) {
            return shuffleThis;
        }
        return shuffleThis.subList(0, number);
    }

    private ElkNode makeGraph(ElkNode graph) {
        int m;
        if (!this.get(GeneratorOptions.ENABLE_HIERARCHY).booleanValue()) {
            this.set(GeneratorOptions.HIERARCHY_CHANCE, Float.valueOf(0.0f));
            this.set(GeneratorOptions.CROSS_HIERARCHY_EDGES, false);
        }
        int n = this.get(GeneratorOptions.NUMBER_OF_NODES).intVal(this.random);
        switch (this.get(GeneratorOptions.EDGE_DETERMINATION)) {
            case ABSOLUTE: {
                m = this.get(GeneratorOptions.EDGES_ABSOLUTE).intVal(this.random);
                break;
            }
            case RELATIVE: {
                m = (int)((double)n * this.get(GeneratorOptions.RELATIVE_EDGES).val(this.random));
                break;
            }
            case DENSITY: {
                double d = this.get(GeneratorOptions.DENSITY).val(this.random);
                m = (int)Math.round(d * (double)n * (double)(n - 1) / 2.0);
                break;
            }
            case OUTGOING: {
                double edgesPerNode = this.get(GeneratorOptions.OUTGOING_EDGES).val(this.random);
                m = (int)Math.round((double)n * edgesPerNode);
                break;
            }
            default: {
                throw new IllegalArgumentException("Selected edge determination is not supported.");
            }
        }
        switch (this.get(GeneratorOptions.GRAPH_TYPE)) {
            case CUSTOM: {
                this.generateCustomGraph(n, m, graph);
                break;
            }
            case BIPARTITE: {
                this.generateBipartite(graph, n, m, 0);
                break;
            }
            case TREE: {
                int maxDegree = this.get(GeneratorOptions.MAX_DEGREE);
                int maxWidth = this.get(GeneratorOptions.MAX_WIDTH);
                this.generateTree(graph, n, maxDegree, maxWidth, 0);
                break;
            }
            case BICONNECTED: {
                this.generateBiconnectedGraph(graph, n, m, 0);
                break;
            }
            case TRICONNECTED: {
                float p1 = this.random.nextFloat();
                float p2 = 1.0f - p1;
                this.generateTriconnectedGraph(graph, n, p1, p2, 0);
                break;
            }
            case ACYCLIC_NO_TRANSITIVE_EDGES: {
                boolean planar = this.get(GeneratorOptions.PLANAR);
                this.generateANTEGraph(graph, n, m, planar, false, 0);
                break;
            }
            default: {
                throw new IllegalArgumentException("Selected graph generator is not supported.");
            }
        }
        if (!this.get(GeneratorOptions.ISOLATED_NODES).booleanValue()) {
            RandomGraphGenerator.removeIsolatedNodes(graph);
        }
        if (this.get(GeneratorOptions.ENABLE_PORTS).booleanValue() && this.get(GeneratorOptions.PORT_CONSTRAINTS) == PortConstraints.FIXED_POS) {
            LinkedList<ElkNode> nodeQueue = new LinkedList<ElkNode>();
            nodeQueue.add(graph);
            do {
                ElkNode node = (ElkNode)nodeQueue.removeFirst();
                this.distributePorts(node);
                nodeQueue.addAll((Collection<ElkNode>)node.getChildren());
            } while (!nodeQueue.isEmpty());
        }
        return graph;
    }

    private List<ElkNode> generateCustomGraph(int n, int m, ElkNode graph) {
        List<ElkNode> generatedNodes;
        switch (this.get(GeneratorOptions.EDGE_DETERMINATION)) {
            case OUTGOING: {
                generatedNodes = this.generateAnyGraph(graph, n, 0);
                break;
            }
            default: {
                generatedNodes = this.generateAnyGraph(graph, n, m, 0);
            }
        }
        if (this.get(GeneratorOptions.CROSS_HIERARCHY_EDGES).booleanValue()) {
            switch (this.get(GeneratorOptions.EDGE_DETERMINATION)) {
                case OUTGOING: {
                    int[] outgoingEdges = this.determineOutgoingEdges(generatedNodes, this.get(GeneratorOptions.OUTGOING_EDGES));
                    this.connectRandomlyAndConditional(generatedNodes, outgoingEdges, this.basicCondition);
                    break;
                }
                default: {
                    int[] outgoingEdges;
                    int createdEdges = 0;
                    int iterations = 0;
                    while ((createdEdges += this.connectRandomlyAndConditional(generatedNodes, outgoingEdges = this.determineOutgoingEdges(generatedNodes, m - createdEdges), this.basicCondition)) < m && ++iterations < 12) {
                    }
                    break block3;
                }
            }
        }
        return generatedNodes;
    }

    private List<ElkNode> generateAnyGraph(ElkNode parent, int n, int m, int hierarchyLevel) {
        float hierarchyChance;
        List<ElkNode> nodes = this.createIndependentSet(parent, n);
        if (!this.get(GeneratorOptions.CROSS_HIERARCHY_EDGES).booleanValue()) {
            int[] outgoingEdges;
            int createdEdges = 0;
            int iterations = 0;
            while ((createdEdges += this.connectRandomlyAndConditional(nodes, outgoingEdges = this.determineOutgoingEdges(nodes, m - createdEdges), this.basicCondition)) < m && ++iterations < 12) {
            }
        }
        if ((hierarchyChance = this.get(GeneratorOptions.HIERARCHY_CHANCE).floatValue()) > 0.0f && hierarchyLevel < this.maxHierarchyLevel) {
            ElkNode[] elkNodeArray = nodes.toArray(new ElkNode[nodes.size()]);
            int n2 = elkNodeArray.length;
            int n3 = 0;
            while (n3 < n2) {
                ElkNode node = elkNodeArray[n3];
                if (!RandomGraphGenerator.isHypernode(node) && this.random.nextFloat() < hierarchyChance) {
                    float sizeFactor = this.random.nextFloat() * this.get(GeneratorOptions.HIERARCHY_NODES_FACTOR).floatValue();
                    int cn = Math.round(sizeFactor * (float)n);
                    if (cn == 0) {
                        cn = 1;
                    }
                    int cm = Math.round(sizeFactor * (float)m);
                    List<ElkNode> childNodes = this.generateAnyGraph(node, cn, cm, hierarchyLevel + 1);
                    nodes.addAll(childNodes);
                }
                ++n3;
            }
        }
        return nodes;
    }

    private List<ElkNode> generateAnyGraph(ElkNode parent, int n, int hierarchyLevel) {
        float hierarchyChance;
        List<ElkNode> nodes = this.createIndependentSet(parent, n);
        if (!this.get(GeneratorOptions.CROSS_HIERARCHY_EDGES).booleanValue()) {
            int[] outgoingEdges = this.determineOutgoingEdges(nodes, this.get(GeneratorOptions.OUTGOING_EDGES));
            this.connectRandomlyAndConditional(nodes, outgoingEdges, this.basicCondition);
        }
        if ((hierarchyChance = this.get(GeneratorOptions.HIERARCHY_CHANCE).floatValue()) > 0.0f && hierarchyLevel < this.maxHierarchyLevel) {
            ElkNode[] elkNodeArray = nodes.toArray(new ElkNode[nodes.size()]);
            int n2 = elkNodeArray.length;
            int n3 = 0;
            while (n3 < n2) {
                ElkNode node = elkNodeArray[n3];
                if (!RandomGraphGenerator.isHypernode(node) && this.random.nextFloat() < hierarchyChance) {
                    float sizeFactor = this.random.nextFloat() * this.get(GeneratorOptions.HIERARCHY_NODES_FACTOR).floatValue();
                    int cn = Math.round(sizeFactor * (float)n);
                    if (cn == 0) {
                        cn = 1;
                    }
                    List<ElkNode> childNodes = this.generateAnyGraph(node, cn, hierarchyLevel + 1, this.maxHierarchyLevel);
                    nodes.addAll(childNodes);
                }
                ++n3;
            }
        }
        return nodes;
    }

    private void generateBipartite(ElkNode parent, int n, int m, int hierarchyLevel) {
        int n2 = ElkMath.boundi((int)((int)Math.round((double)n * this.get(GeneratorOptions.PARTITION_FRAC).val(this.random))), (int)1, (int)(n - 1));
        int n1 = n - n2;
        ElkNode[] nodes1 = new ElkNode[n1];
        int i = 0;
        while (i < n1) {
            nodes1[i] = this.createNode(parent);
            ++i;
        }
        ElkNode[] nodes2 = new ElkNode[n2];
        int i2 = 0;
        while (i2 < n2) {
            nodes2[i2] = this.createNode(parent);
            ++i2;
        }
        boolean allowCycles = this.get(GeneratorOptions.CYCLES);
        int j = 0;
        while (j < m) {
            int target;
            int source = allowCycles ? this.random.nextInt(n) : this.random.nextInt(n1);
            if (source < n1) {
                target = this.random.nextInt(n2);
                this.connectConditional(nodes1[source], nodes2[target], this.basicCondition);
            } else {
                target = this.random.nextInt(n1);
                this.connectConditional(nodes2[source - n1], nodes1[target], this.basicCondition);
            }
            ++j;
        }
        float hierarchyChance = this.get(GeneratorOptions.HIERARCHY_CHANCE).floatValue();
        if (hierarchyChance > 0.0f && hierarchyLevel < this.maxHierarchyLevel) {
            for (ElkNode node : parent.getChildren()) {
                if (RandomGraphGenerator.isHypernode(node) || !(this.random.nextFloat() < hierarchyChance)) continue;
                float hierarchyNodesFactor = this.get(GeneratorOptions.HIERARCHY_NODES_FACTOR).floatValue();
                int cn = this.randomInt(1, (int)(hierarchyNodesFactor * (float)n));
                int cm = Math.round((float)cn / (float)n * (float)m);
                this.generateBipartite(node, cn, cm, hierarchyLevel + 1);
            }
        }
    }

    private void generateTree(ElkNode parent, int n, int maxDeg, int maxWidth, int hierarchyLevel) {
        int max = 0;
        int nodeIdCounter = 0;
        Pair[] possible = new Pair[n];
        int[] width = new int[n + 1];
        int[] level = new int[n];
        ElkNode rootNode = this.createNode(parent);
        int rootId = nodeIdCounter++;
        possible[0] = new Pair((Object)rootNode, (Object)rootId);
        level[rootId] = 0;
        int i = 1;
        while (i < n) {
            int x = this.randomInt(0, max);
            Pair nodeInfo = possible[x];
            ElkNode node = (ElkNode)nodeInfo.getFirst();
            int nodeId = (Integer)nodeInfo.getSecond();
            if (maxWidth != 0 && width[level[nodeId] + 1] == maxWidth) {
                possible[x] = possible[max--];
                continue;
            }
            if (maxDeg != 0 && node.getOutgoingEdges().size() + 1 == maxDeg) {
                possible[x] = possible[max--];
            }
            ElkNode newNode = this.createNode(parent);
            int newNodeId = nodeIdCounter++;
            possible[++max] = new Pair((Object)newNode, (Object)newNodeId);
            this.connect((ElkConnectableShape)node, (ElkConnectableShape)newNode);
            level[newNodeId] = level[nodeId] + 1;
            int n2 = level[newNodeId];
            width[n2] = width[n2] + 1;
            ++i;
        }
        float hierarchyChance = this.get(GeneratorOptions.HIERARCHY_CHANCE).floatValue();
        if (hierarchyChance > 0.0f && hierarchyLevel < this.maxHierarchyLevel) {
            for (ElkNode node : parent.getChildren()) {
                if (RandomGraphGenerator.isHypernode(node) || !(this.random.nextFloat() < hierarchyChance)) continue;
                float hierarchyNodesFactor = this.get(GeneratorOptions.HIERARCHY_NODES_FACTOR).floatValue();
                int cn = this.randomInt(1, (int)(hierarchyNodesFactor * (float)n));
                this.generateTree(node, cn, maxDeg, maxWidth, hierarchyLevel + 1);
            }
        }
    }

    private void generateBiconnectedGraph(ElkNode parent, int n, int m, int hierarchyLevel) {
        int realN = Math.max(3, n);
        int realM = Math.max(m, realN);
        int kse = realN - 3;
        int kae = realM - realN;
        ElkNode[] nodes = new ElkNode[realN];
        ElkEdge[] edges = new ElkEdge[realM];
        nodes[0] = this.createNode(parent);
        nodes[1] = this.createNode(parent);
        nodes[2] = this.createNode(parent);
        edges[0] = this.connect((ElkConnectableShape)nodes[0], (ElkConnectableShape)nodes[1]);
        edges[1] = this.connect((ElkConnectableShape)nodes[1], (ElkConnectableShape)nodes[2]);
        edges[2] = this.connect((ElkConnectableShape)nodes[2], (ElkConnectableShape)nodes[0]);
        int nNodes = 3;
        int nEdges = 3;
        while (kse + kae > 0) {
            int p = this.randomInt(1, kse + kae);
            if (p <= kse) {
                ElkEdge edge = edges[this.randomInt(0, nEdges - 1)];
                Pair<ElkNode, ElkEdge> splitInfo = this.split(edge);
                nodes[nNodes++] = (ElkNode)splitInfo.getFirst();
                edges[nEdges++] = (ElkEdge)splitInfo.getSecond();
                --kse;
                continue;
            }
            int i = this.randomInt(0, nNodes - 1);
            int j = (i + this.randomInt(1, nNodes - 1)) % nNodes;
            edges[nEdges++] = this.connect((ElkConnectableShape)nodes[i], (ElkConnectableShape)nodes[j]);
            --kae;
        }
        float hierarchyChance = this.get(GeneratorOptions.HIERARCHY_CHANCE).floatValue();
        if (hierarchyChance > 0.0f && hierarchyLevel < this.maxHierarchyLevel) {
            ElkNode[] elkNodeArray = nodes;
            int n2 = nodes.length;
            int n3 = 0;
            while (n3 < n2) {
                ElkNode node = elkNodeArray[n3];
                if (!RandomGraphGenerator.isHypernode(node) && this.random.nextFloat() < hierarchyChance) {
                    float hierarchyNodesFactor = this.get(GeneratorOptions.HIERARCHY_NODES_FACTOR).floatValue();
                    int cn = this.randomInt(1, (int)(hierarchyNodesFactor * (float)n));
                    float density = (float)m / (float)(n * n);
                    int cm = (int)density * cn * cn;
                    this.generateBiconnectedGraph(node, cn, cm, hierarchyLevel + 1);
                }
                ++n3;
            }
        }
    }

    private void generateTriconnectedGraph(ElkNode parent, int n, float p1, float p2, int hierarchyLevel) {
        int realN = Math.max(n, 4);
        List<ElkNode> cliqueNodes = this.createClique(parent, 4);
        ElkNode[] nodes = new ElkNode[realN];
        int i = 0;
        for (ElkNode node : cliqueNodes) {
            nodes[i++] = node;
        }
        ElkEdge[] neighbors = new ElkEdge[realN];
        int[] marks = new int[n];
        while (i < n) {
            ElkNode newNode;
            ElkNode node = nodes[this.randomInt(0, i - 1)];
            nodes[i] = newNode = this.createNode(parent);
            int d = node.getOutgoingEdges().size() + node.getIncomingEdges().size();
            int j = 0;
            for (ElkEdge edge : node.getOutgoingEdges()) {
                neighbors[j++] = edge;
            }
            for (ElkEdge edge : node.getIncomingEdges()) {
                neighbors[j++] = edge;
            }
            j = 2;
            while (j > 0) {
                int r = this.randomInt(0, d - 1);
                if ((marks[r] & 1) != 0) continue;
                int n2 = r;
                marks[n2] = marks[n2] | 1;
                --j;
            }
            j = 2;
            while (j > 0) {
                int r = this.randomInt(0, d - 1);
                if ((marks[r] & 2) != 0) continue;
                int n3 = r;
                marks[n3] = marks[n3] | 2;
                --j;
            }
            j = 0;
            while (j < d) {
                int mark = marks[j];
                marks[j] = 0;
                double x = this.random.nextDouble();
                switch (mark) {
                    case 0: {
                        if (x < (double)p1) {
                            mark = 1;
                            break;
                        }
                        if (x < (double)(p1 + p2)) {
                            mark = 2;
                            break;
                        }
                        mark = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        if (!(x >= (double)(p1 + p2))) break;
                        mark = 3;
                    }
                }
                ElkEdge edge = neighbors[j];
                switch (mark) {
                    case 2: {
                        if (edge.getSources().contains((Object)node)) {
                            this.moveSource(edge, (ElkConnectableShape)node, (ElkConnectableShape)newNode);
                            break;
                        }
                        this.moveTarget(edge, (ElkConnectableShape)node, (ElkConnectableShape)newNode);
                        break;
                    }
                    case 3: {
                        if (edge.getSources().contains((Object)node)) {
                            this.connect((ElkConnectableShape)newNode, (ElkConnectableShape)edge.getTargets().get(0));
                            break;
                        }
                        this.connect((ElkConnectableShape)newNode, (ElkConnectableShape)edge.getSources().get(0));
                    }
                }
                ++j;
            }
            this.connect((ElkConnectableShape)node, (ElkConnectableShape)newNode);
            ++i;
        }
        float hierarchyChance = this.get(GeneratorOptions.HIERARCHY_CHANCE).floatValue();
        if (hierarchyChance > 0.0f && hierarchyLevel < this.maxHierarchyLevel) {
            for (ElkNode node : parent.getChildren()) {
                if (RandomGraphGenerator.isHypernode(node) || !(this.random.nextFloat() < hierarchyChance)) continue;
                float hierarchyNodesFactor = this.get(GeneratorOptions.HIERARCHY_NODES_FACTOR).floatValue();
                int cn = this.randomInt(1, (int)(hierarchyNodesFactor * (float)n));
                this.generateTriconnectedGraph(node, cn, p1, p2, hierarchyLevel + 1);
            }
        }
    }

    private void generateANTEGraph(ElkNode parent, int n, int m, boolean planar, boolean singleSource, int hierarchyLevel) {
        HierarchyEdge nextEdge;
        int act;
        int n2;
        int n1;
        ElkNode[] nnr = new ElkNode[3 * n];
        int[] vrt = new int[3 * n];
        int[] fst = new int[n + 1];
        LinkedList<HierarchyEdge> startEdges = new LinkedList<HierarchyEdge>();
        int idc = 0;
        int i = 0;
        while (i < n) {
            this.createNode(parent);
            ++i;
        }
        int numberOfLayers = 0;
        int totNumber = 0;
        int realCount = 0;
        fst[0] = 0;
        Iterator iterator = parent.getChildren().iterator();
        while (iterator.hasNext()) {
            ElkNode node;
            nnr[totNumber] = node = (ElkNode)iterator.next();
            vrt[totNumber++] = 0;
            float r = this.random.nextFloat();
            if ((totNumber != 1 || !singleSource) && ++realCount != n && !(r * r * (float)n < 1.0f)) continue;
            fst[++numberOfLayers] = totNumber;
        }
        int[] leftN = new int[totNumber];
        int[] rightN = new int[totNumber];
        int l = 1;
        while (l < numberOfLayers) {
            if (planar) {
                n1 = fst[l - 1];
                n2 = fst[l];
                leftN[n2] = n1;
                while (n1 < fst[l] && n2 < fst[l + 1]) {
                    float r = this.random.nextFloat();
                    if (n1 != fst[l] - 1 && (n2 == fst[l + 1] - 1 || r < (float)(fst[l] - fst[l - 1]) / (float)(fst[l + 1] - fst[l - 1]))) {
                        ++n1;
                        continue;
                    }
                    rightN[n2] = n1;
                    if (++n2 >= fst[l + 1]) continue;
                    leftN[n2] = n1;
                }
            } else {
                n2 = fst[l];
                while (n2 < fst[l + 1]) {
                    leftN[n2] = fst[l - 1];
                    rightN[n2] = fst[l] - 1;
                    ++n2;
                }
            }
            ++l;
        }
        LinkedList[] edgeIn = new LinkedList[totNumber];
        LinkedList[] edgeOut = new LinkedList[totNumber];
        int i2 = 0;
        while (i2 < totNumber) {
            edgeIn[i2] = new LinkedList();
            edgeOut[i2] = new LinkedList();
            ++i2;
        }
        if (numberOfLayers != 0) {
            float x1 = m;
            float x2 = 0.0f;
            n2 = fst[1];
            while (n2 < totNumber) {
                if (vrt[n2] == 0) {
                    x2 += (float)(rightN[n2] - leftN[n2] + 1);
                }
                ++n2;
            }
            n2 = fst[1];
            while (n2 < totNumber) {
                if (vrt[n2] == 0) {
                    boolean connected = !singleSource;
                    n1 = leftN[n2];
                    while (n1 <= rightN[n2] || !connected) {
                        float r = this.random.nextFloat();
                        if (r < x1 / x2 || n1 > rightN[n2]) {
                            int next = n1 <= rightN[n2] ? n1 : this.randomInt(leftN[n2], rightN[n2]);
                            act = n2;
                            nextEdge = new HierarchyEdge(next, act, idc++);
                            while (vrt[next] != 0) {
                                act = next;
                                next = this.randomInt(leftN[act], rightN[act]);
                                edgeOut[act].add(nextEdge);
                                nextEdge = new HierarchyEdge(next, act, idc++);
                                edgeIn[act].add(nextEdge);
                            }
                            startEdges.add(nextEdge);
                            connected = true;
                            x1 -= 1.0f;
                        }
                        if (n1 <= rightN[n2]) {
                            x2 -= 1.0f;
                        }
                        ++n1;
                    }
                }
                ++n2;
            }
        }
        if (planar) {
            act = 0;
            while (act < totNumber) {
                Collections.sort(edgeIn[act], new TailComparator());
                Collections.sort(edgeOut[act], new HeadComparator());
                ++act;
            }
        }
        act = 0;
        while (act < totNumber) {
            LinkedList hedges = edgeIn[act];
            Iterator iterator2 = hedges.iterator();
            while (iterator2.hasNext()) {
                HierarchyEdge hedge;
                nextEdge = hedge = (HierarchyEdge)iterator2.next();
                nextEdge.setNext((HierarchyEdge)edgeOut[act].remove(0));
            }
            ++act;
        }
        Iterator hedge = startEdges.iterator();
        while (hedge.hasNext()) {
            HierarchyEdge hedge2;
            HierarchyEdge actEdge;
            nextEdge = actEdge = (hedge2 = (HierarchyEdge)hedge.next());
            while (vrt[nextEdge.getHead()] != 0) {
                nextEdge = nextEdge.getNext();
            }
            this.connect((ElkConnectableShape)nnr[actEdge.getTail()], (ElkConnectableShape)nnr[nextEdge.getHead()]);
        }
        float hierarchyChance = this.get(GeneratorOptions.HIERARCHY_CHANCE).floatValue();
        if (hierarchyChance > 0.0f && hierarchyLevel < this.maxHierarchyLevel) {
            for (ElkNode node : parent.getChildren()) {
                if (RandomGraphGenerator.isHypernode(node) || !(this.random.nextFloat() < hierarchyChance)) continue;
                float hierarchyNodesFactor = this.get(GeneratorOptions.HIERARCHY_NODES_FACTOR).floatValue();
                int cn = this.randomInt(1, (int)(hierarchyNodesFactor * (float)n));
                float density = (float)m / (float)(n * n);
                int cm = (int)density * cn * cn;
                this.generateANTEGraph(node, cn, cm, planar, singleSource, hierarchyLevel + 1);
            }
        }
    }

    private static int compareId(HierarchyEdge edge1, HierarchyEdge edge2) {
        return edge1.getId() < edge2.getId() ? -1 : (edge1.getId() > edge2.getId() ? 1 : 0);
    }

    private List<ElkNode> createIndependentSet(ElkNode parent, int n) {
        ArrayList<ElkNode> nodes = new ArrayList<ElkNode>(n);
        int i = 0;
        while (i < n) {
            ElkNode node = this.createNode(parent);
            nodes.add(node);
            ++i;
        }
        return nodes;
    }

    private List<ElkNode> createClique(ElkNode parent, int n) {
        List<ElkNode> nodes = this.createIndependentSet(parent, n);
        int i = 0;
        while (i < n - 1) {
            int j = i + 1;
            while (j < n) {
                this.connect((ElkConnectableShape)nodes.get(i), (ElkConnectableShape)nodes.get(j));
                ++j;
            }
            ++i;
        }
        return nodes;
    }

    private ElkNode createNode(ElkNode parent) {
        PortConstraints portConstraints;
        ElkNode node = ElkGraphUtil.createNode(null);
        float hypernodeChance = this.get(GeneratorOptions.HYPERNODE_CHANCE).floatValue();
        if (hypernodeChance > 0.0f && this.random.nextFloat() < hypernodeChance) {
            node.setProperty(CoreOptions.HYPERNODE, (Object)true);
        }
        String nodeid = String.valueOf(this.nodeLabelCounter++);
        if (this.get(GeneratorOptions.CREATE_NODE_LABELS).booleanValue()) {
            ElkGraphUtil.createLabel((String)("N" + nodeid), (ElkGraphElement)node);
        }
        node.setIdentifier("n" + nodeid);
        if (this.get(GeneratorOptions.SET_NODE_SIZE).booleanValue()) {
            node.setWidth((double)this.get(GeneratorOptions.NODE_WIDTH).floatVal(this.random));
            node.setHeight((double)this.get(GeneratorOptions.NODE_HEIGHT).floatVal(this.random));
        }
        if ((portConstraints = this.get(GeneratorOptions.PORT_CONSTRAINTS)) != PortConstraints.UNDEFINED) {
            node.setProperty(CoreOptions.PORT_CONSTRAINTS, (Object)portConstraints);
        }
        parent.getChildren().add((Object)node);
        return node;
    }

    private ElkPort createPort(ElkNode node, boolean source) {
        ElkPort port = ElkGraphUtil.createPort(null);
        node.getPorts().add((Object)port);
        String portId = String.valueOf(this.portLabelCounter++);
        if (this.get(GeneratorOptions.CREATE_PORT_LABELS).booleanValue()) {
            ElkGraphUtil.createLabel((String)("P" + portId), (ElkGraphElement)port);
        }
        port.setIdentifier("p" + portId);
        if (this.get(GeneratorOptions.SET_PORT_SIZE).booleanValue()) {
            port.setWidth((double)this.get(GeneratorOptions.PORT_WIDTH).floatVal(this.random));
            port.setHeight((double)this.get(GeneratorOptions.PORT_HEIGHT).floatVal(this.random));
        }
        if (this.get(GeneratorOptions.PORT_CONSTRAINTS).isSideFixed()) {
            int westProb;
            int southProb;
            int eastProb;
            int northProb;
            if (source) {
                northProb = this.get(GeneratorOptions.OUTGOING_NORTH_SIDE);
                eastProb = this.get(GeneratorOptions.OUTGOING_EAST_SIDE);
                southProb = this.get(GeneratorOptions.OUTGOING_SOUTH_SIDE);
                westProb = this.get(GeneratorOptions.OUTGOING_WEST_SIDE);
            } else {
                northProb = this.get(GeneratorOptions.INCOMING_NORTH_SIDE);
                eastProb = this.get(GeneratorOptions.INCOMING_EAST_SIDE);
                southProb = this.get(GeneratorOptions.INCOMING_SOUTH_SIDE);
                westProb = this.get(GeneratorOptions.INCOMING_WEST_SIDE);
            }
            int p = this.random.nextInt(northProb + eastProb + southProb + westProb);
            PortSide portSide = p < northProb ? PortSide.NORTH : (p < northProb + eastProb ? PortSide.EAST : (p < northProb + eastProb + southProb ? PortSide.SOUTH : PortSide.WEST));
            port.setProperty(CoreOptions.PORT_SIDE, (Object)portSide);
        }
        return port;
    }

    private ElkEdge connect(ElkConnectableShape source, ElkConnectableShape target) {
        ElkNode sourceNode = null;
        ElkNode targetNode = null;
        ElkPort sourcePort = null;
        ElkPort targetPort = null;
        if (source instanceof ElkNode) {
            sourceNode = (ElkNode)source;
        }
        if (source instanceof ElkPort) {
            sourcePort = (ElkPort)source;
            sourceNode = sourcePort.getParent();
        }
        if (target instanceof ElkPort) {
            targetPort = (ElkPort)target;
            targetNode = targetPort.getParent();
        }
        if (target instanceof ElkNode) {
            targetNode = (ElkNode)target;
        }
        ElkEdge edge = ElkGraphUtil.createEdge(null);
        if (this.get(GeneratorOptions.ENABLE_PORTS).booleanValue()) {
            if (source instanceof ElkNode) {
                sourcePort = this.retrievePort(sourceNode, true);
            }
            if (!RandomGraphGenerator.isHypernode(sourceNode)) {
                if (edge.getSources().contains((Object)sourceNode)) {
                    edge.getSources().remove((Object)sourceNode);
                }
                edge.getSources().add((Object)sourcePort);
            }
            if (!RandomGraphGenerator.isHypernode(targetNode)) {
                if (targetPort == null) {
                    targetPort = this.retrievePort(targetNode, false);
                }
                if (edge.getTargets().contains((Object)targetNode)) {
                    edge.getTargets().remove((Object)targetNode);
                }
                edge.getTargets().remove((Object)target);
                edge.getTargets().add((Object)targetPort);
            }
        } else {
            edge.getSources().add((Object)sourceNode);
            edge.getTargets().add((Object)targetNode);
        }
        if (this.get((IProperty)GeneratorOptions.EDGE_LABELS).booleanValue()) {
            this.addEdgeLabel(edge);
        }
        ElkGraphUtil.updateContainment((ElkEdge)edge);
        return edge;
    }

    private void addEdgeLabel(ElkEdge edge) {
        ElkLabel label = ElkGraphUtil.createLabel((String)BlindTextGenerator.generate(), (ElkGraphElement)edge);
        edge.getLabels().add((Object)label);
    }

    private ElkPort retrievePort(ElkNode node, boolean source) {
        float reusePortsChance = this.get(GeneratorOptions.USE_EXISTING_PORTS_CHANCE).floatVal(this.random);
        if (reusePortsChance > 0.0f && this.random.nextFloat() < reusePortsChance) {
            LinkedList reuseCandidates = Lists.newLinkedList();
            for (ElkPort port : node.getPorts()) {
                boolean connectedToDesiredEdges = false;
                boolean connectedToBadEdges = false;
                connectedToDesiredEdges = !port.getIncomingEdges().isEmpty() && !source || !port.getOutgoingEdges().isEmpty() && source;
                boolean bl = connectedToBadEdges = !port.getIncomingEdges().isEmpty() && source || !port.getOutgoingEdges().isEmpty() && !source;
                if (!connectedToDesiredEdges || connectedToBadEdges) continue;
                reuseCandidates.add(port);
            }
            if (!reuseCandidates.isEmpty()) {
                return (ElkPort)reuseCandidates.get(this.randomInt(0, reuseCandidates.size() - 1));
            }
        }
        return this.createPort(node, source);
    }

    private boolean connectConditional(ElkNode source, ElkNode target, EdgeCondition condition) {
        if (condition.evaluate(source, target)) {
            this.connect((ElkConnectableShape)source, (ElkConnectableShape)target);
            return true;
        }
        return false;
    }

    private void moveSource(ElkEdge edge, ElkConnectableShape oldConnectShape, ElkConnectableShape newConnectShape) {
        ElkPortImpl port = null;
        ElkNode oldNode = null;
        ElkNode newNode = null;
        ElkPort oldPort = null;
        ElkPort newPort = null;
        if (this.get(GeneratorOptions.ENABLE_PORTS).booleanValue()) {
            if (!edge.getSources().isEmpty()) {
                if (oldConnectShape instanceof ElkNodeImpl) {
                    oldNode = (ElkNode)oldConnectShape;
                    for (ElkConnectableShape source : edge.getSources()) {
                        if (!(source instanceof ElkPortImpl) || !(port = (ElkPortImpl)source).getParent().equals(oldNode)) continue;
                        edge.getSources().remove((Object)port);
                        if (port.getOutgoingEdges().size() != 0 || port.getIncomingEdges().size() != 1) continue;
                        port.getParent().getPorts().remove((Object)port);
                    }
                } else if (oldConnectShape instanceof ElkPortImpl) {
                    oldPort = (ElkPort)oldConnectShape;
                    if (edge.getSources().contains((Object)oldPort)) {
                        edge.getSources().remove((Object)oldPort);
                    }
                    if (oldPort.getOutgoingEdges().size() == 0 && oldPort.getIncomingEdges().size() == 1) {
                        oldPort.getParent().getPorts().remove((Object)oldPort);
                    }
                }
            }
            if (newConnectShape instanceof ElkNodeImpl) {
                newNode = (ElkNode)oldConnectShape;
                newPort = this.retrievePort(newNode, true);
            } else if (newConnectShape instanceof ElkPortImpl) {
                newPort = (ElkPort)oldConnectShape;
            }
            if (!RandomGraphGenerator.isHypernode(newNode)) {
                edge.getSources().add((Object)newPort);
            }
        } else {
            if (oldConnectShape instanceof ElkNodeImpl) {
                oldNode = (ElkNode)oldConnectShape;
            } else if (oldConnectShape instanceof ElkPortImpl) {
                oldPort = (ElkPort)oldConnectShape;
                oldNode = oldPort.getParent();
            }
            if (edge.getSources().contains((Object)oldNode)) {
                edge.getSources().remove((Object)oldNode);
            }
            if (newConnectShape instanceof ElkNodeImpl) {
                newNode = (ElkNode)newConnectShape;
            } else if (newConnectShape instanceof ElkPortImpl) {
                newPort = (ElkPort)newConnectShape;
                newNode = newPort.getParent();
            }
            edge.getSources().add((Object)newNode);
        }
        ElkGraphUtil.updateContainment((ElkEdge)edge);
    }

    private void moveTarget(ElkEdge edge, ElkConnectableShape oldConnectShape, ElkConnectableShape newConnectShape) {
        ElkPortImpl port = null;
        ElkNode oldNode = null;
        ElkNode newNode = null;
        ElkPort oldPort = null;
        ElkPort newPort = null;
        if (this.get(GeneratorOptions.ENABLE_PORTS).booleanValue()) {
            if (!edge.getTargets().isEmpty()) {
                if (oldConnectShape instanceof ElkNodeImpl) {
                    oldNode = (ElkNode)oldConnectShape;
                    for (ElkConnectableShape target : edge.getTargets()) {
                        if (!(target instanceof ElkPortImpl) || !(port = (ElkPortImpl)target).getParent().equals(oldNode)) continue;
                        edge.getTargets().remove((Object)port);
                        if (port.getOutgoingEdges().size() != 0 || port.getIncomingEdges().size() != 1) continue;
                        port.getParent().getPorts().remove((Object)port);
                    }
                } else if (oldConnectShape instanceof ElkPortImpl) {
                    oldPort = (ElkPort)oldConnectShape;
                    if (edge.getTargets().contains((Object)oldPort)) {
                        edge.getTargets().remove((Object)oldPort);
                    }
                    if (oldPort.getOutgoingEdges().size() == 0 && oldPort.getIncomingEdges().size() == 1) {
                        oldPort.getParent().getPorts().remove((Object)oldPort);
                    }
                }
            }
            if (newConnectShape instanceof ElkNodeImpl) {
                newNode = (ElkNode)oldConnectShape;
                newPort = this.retrievePort(newNode, true);
            } else if (newConnectShape instanceof ElkPortImpl) {
                newPort = (ElkPort)oldConnectShape;
            }
            if (!RandomGraphGenerator.isHypernode(newNode)) {
                edge.getTargets().add((Object)newPort);
            }
        } else {
            if (oldConnectShape instanceof ElkNodeImpl) {
                oldNode = (ElkNode)oldConnectShape;
            } else if (oldConnectShape instanceof ElkPortImpl) {
                oldPort = (ElkPort)oldConnectShape;
                oldNode = oldPort.getParent();
            }
            if (edge.getTargets().contains((Object)oldNode)) {
                edge.getTargets().remove((Object)oldNode);
            }
            if (newConnectShape instanceof ElkNodeImpl) {
                newNode = (ElkNode)newConnectShape;
            } else if (newConnectShape instanceof ElkPortImpl) {
                newPort = (ElkPort)newConnectShape;
                newNode = newPort.getParent();
            }
            edge.getTargets().add((Object)newNode);
        }
        ElkGraphUtil.updateContainment((ElkEdge)edge);
    }

    private Pair<ElkNode, ElkEdge> split(ElkEdge edge) {
        ElkNode newNode = this.createNode(edge.getContainingNode());
        ElkEdge newEdge = this.connect((ElkConnectableShape)newNode, (ElkConnectableShape)edge.getTargets().get(0));
        ElkConnectableShape oldTarget = (ElkConnectableShape)edge.getTargets().get(0);
        edge.getTargets().remove(0);
        newEdge.getTargets().addAll((Collection)edge.getTargets());
        edge.getTargets().clear();
        edge.getTargets().add((Object)oldTarget);
        this.moveTarget(edge, (ElkConnectableShape)edge.getTargets().get(0), (ElkConnectableShape)newNode);
        ElkGraphUtil.updateContainment((ElkEdge)newEdge);
        return new Pair((Object)newNode, (Object)newEdge);
    }

    private int connectRandomlyAndConditional(ElkNode source, List<ElkNode> targets, int number, EdgeCondition condition) {
        ElkNode[] targetBuffer = targets.toArray(new ElkNode[0]);
        int edges = 0;
        int bufferEnd = targetBuffer.length - 1;
        while (edges < number && bufferEnd >= 0) {
            int i = this.randomInt(0, bufferEnd);
            ElkNode target = targetBuffer[i];
            if (this.connectConditional(source, target, condition)) {
                ++edges;
                continue;
            }
            targetBuffer[i] = targetBuffer[bufferEnd];
            --bufferEnd;
        }
        return edges;
    }

    private int connectRandomlyAndConditional(List<ElkNode> nodes, int[] outgoingEdges, EdgeCondition condition) {
        int edges = 0;
        int i = 0;
        while (i < nodes.size()) {
            ElkNode source = nodes.get(i);
            edges += this.connectRandomlyAndConditional(source, nodes, outgoingEdges[i], condition);
            ++i;
        }
        return edges;
    }

    private int[] determineOutgoingEdges(List<ElkNode> nodes, GeneratorOptions.RandVal val) {
        int n = nodes.size();
        int[] numberOfEdges = new int[n];
        int i = 0;
        while (i < n) {
            int c;
            numberOfEdges[i] = c = val.intVal(this.random);
            ++i;
        }
        return numberOfEdges;
    }

    private int[] determineOutgoingEdges(List<ElkNode> nodes, int m) {
        int[] outgoingEdges = new int[nodes.size()];
        int c = 0;
        while (c < m) {
            int i;
            int n = i = this.randomInt(0, nodes.size() - 1);
            outgoingEdges[n] = outgoingEdges[n] + 1;
            ++c;
        }
        return outgoingEdges;
    }

    private static void removeIsolatedNodes(ElkNode parent) {
        ListIterator nodeIter = parent.getChildren().listIterator();
        while (nodeIter.hasNext()) {
            ElkNode node = (ElkNode)nodeIter.next();
            RandomGraphGenerator.removeIsolatedNodes(node);
            if (!node.getIncomingEdges().isEmpty() || !node.getOutgoingEdges().isEmpty() || !node.getChildren().isEmpty()) continue;
            nodeIter.remove();
        }
    }

    private static boolean findNodeWithDFS(ElkNode start, ElkNode end) {
        LinkedList<ElkNode> nodes = new LinkedList<ElkNode>();
        nodes.add(start);
        do {
            ElkNode node;
            if ((node = (ElkNode)nodes.poll()) == end) {
                return true;
            }
            for (ElkEdge edge : node.getOutgoingEdges()) {
                for (ElkConnectableShape target : edge.getTargets()) {
                    if (target instanceof ElkNode) {
                        nodes.add((ElkNode)target);
                        continue;
                    }
                    if (!(target instanceof ElkPort)) continue;
                    ElkPort port = (ElkPort)target;
                    nodes.add(port.getParent());
                }
            }
        } while (!nodes.isEmpty());
        return false;
    }

    private static boolean connected(ElkNode node1, ElkNode node2) {
        for (ElkEdge edge : node1.getOutgoingEdges()) {
            if (!edge.getTargets().contains((Object)node2)) continue;
            return true;
        }
        for (ElkEdge edge : node2.getOutgoingEdges()) {
            if (!edge.getTargets().contains((Object)node1)) continue;
            return true;
        }
        return false;
    }

    private void distributePorts(ElkNode node) {
        int northCount = 0;
        int eastCount = 0;
        int southCount = 0;
        int westCount = 0;
        for (ElkPort port : node.getPorts()) {
            switch ((PortSide)port.getProperty(CoreOptions.PORT_SIDE)) {
                case NORTH: {
                    ++northCount;
                    break;
                }
                case EAST: {
                    ++eastCount;
                    break;
                }
                case SOUTH: {
                    ++southCount;
                    break;
                }
                case WEST: {
                    ++westCount;
                }
            }
        }
        float portWidth = this.get(GeneratorOptions.PORT_WIDTH).floatVal(this.random);
        float portHeight = this.get(GeneratorOptions.PORT_HEIGHT).floatVal(this.random);
        if (node.getWidth() < (double)((float)(northCount + 1) * (portWidth + 7.0f))) {
            node.setWidth((double)((float)(northCount + 1) * (portWidth + 7.0f)));
        }
        if (node.getWidth() < (double)((float)(southCount + 1) * (portWidth + 7.0f))) {
            node.setWidth((double)((float)(southCount + 1) * (portWidth + 7.0f)));
        }
        if (node.getHeight() < (double)((float)(eastCount + 1) * (portHeight + 7.0f))) {
            node.setHeight((double)((float)(eastCount + 1) * (portHeight + 7.0f)));
        }
        if (node.getHeight() < (double)((float)(westCount + 1) * (portHeight + 7.0f))) {
            node.setHeight((double)((float)(westCount + 1) * (portHeight + 7.0f)));
        }
        double northDelta = node.getWidth() / (double)(northCount + 1);
        double eastDelta = node.getHeight() / (double)(eastCount + 1);
        double southDelta = node.getWidth() / (double)(southCount + 1);
        double westDelta = node.getHeight() / (double)(westCount + 1);
        double northPos = 0.0;
        double eastPos = 0.0;
        double southPos = 0.0;
        double westPos = 0.0;
        for (ElkPort port : node.getPorts()) {
            switch ((PortSide)port.getProperty(CoreOptions.PORT_SIDE)) {
                case NORTH: {
                    port.setLocation((northPos += northDelta) - port.getWidth() / 2.0, -port.getHeight());
                    break;
                }
                case EAST: {
                    port.setLocation(node.getWidth(), (eastPos += eastDelta) - port.getHeight() / 2.0);
                    break;
                }
                case SOUTH: {
                    port.setLocation((southPos += southDelta) - port.getWidth() / 2.0, node.getHeight());
                    break;
                }
                case WEST: {
                    port.setLocation(-port.getWidth(), (westPos += westDelta) - port.getHeight() / 2.0);
                }
            }
        }
    }

    private int randomInt(int from, int to) {
        assert (from <= to);
        return from + this.random.nextInt(to - from + 1);
    }

    private static boolean isHypernode(ElkNode node) {
        return (Boolean)node.getProperty(CoreOptions.HYPERNODE);
    }

    private <T> T get(IProperty<T> property) {
        return (T)this.options.getProperty(property);
    }

    private <T> void set(IProperty<T> property, T val) {
        this.options.setProperty(property, val);
    }

    private static interface EdgeCondition {
        public boolean evaluate(ElkNode var1, ElkNode var2);
    }

    private static class HeadComparator
    implements Comparator<HierarchyEdge> {
        private HeadComparator() {
        }

        @Override
        public int compare(HierarchyEdge edge1, HierarchyEdge edge2) {
            return edge1.getHead() < edge2.getHead() ? -1 : (edge1.getHead() > edge2.getHead() ? 1 : RandomGraphGenerator.compareId(edge1, edge2));
        }
    }

    private static class HierarchyEdge {
        private int head;
        private int tail;
        private int id;
        private HierarchyEdge next;

        HierarchyEdge(int head, int tail, int id) {
            this.head = head;
            this.tail = tail;
            this.id = id;
        }

        public int getHead() {
            return this.head;
        }

        public int getTail() {
            return this.tail;
        }

        public int getId() {
            return this.id;
        }

        public HierarchyEdge getNext() {
            return this.next;
        }

        public void setNext(HierarchyEdge next) {
            this.next = next;
        }
    }

    private static class TailComparator
    implements Comparator<HierarchyEdge> {
        private TailComparator() {
        }

        @Override
        public int compare(HierarchyEdge edge1, HierarchyEdge edge2) {
            return edge1.getTail() < edge2.getTail() ? -1 : (edge1.getTail() > edge2.getTail() ? 1 : RandomGraphGenerator.compareId(edge1, edge2));
        }
    }
}

