/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.common;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.emfstore.internal.client.model.util.WorkspaceUtil;
import org.eclipse.emf.emfstore.internal.client.ui.common.Messages;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MonitoredEMFStoreAction<T> {
    private final boolean cancelable;
    private T returnValue;
    private final boolean fork;

    public MonitoredEMFStoreAction(boolean fork, boolean cancelable) {
        this.fork = fork;
        this.cancelable = cancelable;
    }

    public final T execute() {
        IProgressService progressService;
        block4: {
            IWorkbench workbench = PlatformUI.getWorkbench();
            progressService = workbench.getProgressService();
            if (this.preRun()) break block4;
            return null;
        }
        try {
            progressService.run(this.fork, this.cancelable, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    try {
                        MonitoredEMFStoreAction.this.returnValue = MonitoredEMFStoreAction.this.doRun(monitor);
                    }
                    catch (ESException e) {
                        MonitoredEMFStoreAction.this.handleException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            WorkspaceUtil.logException((String)(String.valueOf(Messages.MonitoredEMFStoreAction) + e.getMessage()), (Exception)e);
        }
        catch (InterruptedException e) {
            WorkspaceUtil.logException((String)(String.valueOf(Messages.MonitoredEMFStoreAction) + e.getMessage()), (Exception)e);
        }
        this.afterRun();
        return this.returnValue;
    }

    public final T executeSub(IProgressMonitor monitor) {
        if (!this.preRun()) {
            return null;
        }
        try {
            this.returnValue = this.doRun((IProgressMonitor)new SubProgressMonitor(monitor, 5, 4));
        }
        catch (ESException e) {
            this.handleException(e);
        }
        this.afterRun();
        return this.returnValue;
    }

    public boolean preRun() {
        return true;
    }

    public void afterRun() {
    }

    protected abstract void handleException(ESException var1);

    public abstract T doRun(IProgressMonitor var1) throws ESException;

    public boolean isForked() {
        return this.fork;
    }
}

