/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.core;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.accesscontrol.AccessControl;
import org.eclipse.emf.emfstore.internal.server.core.AbstractEmfstoreInterface;
import org.eclipse.emf.emfstore.internal.server.core.Messages;
import org.eclipse.emf.emfstore.internal.server.core.helper.ResourceHelper;
import org.eclipse.emf.emfstore.internal.server.exceptions.AccessControlException;
import org.eclipse.emf.emfstore.internal.server.exceptions.FatalESException;
import org.eclipse.emf.emfstore.internal.server.exceptions.InvalidInputException;
import org.eclipse.emf.emfstore.internal.server.exceptions.InvalidVersionSpecException;
import org.eclipse.emf.emfstore.internal.server.model.ServerSpace;
import org.eclipse.emf.emfstore.internal.server.model.SessionId;
import org.eclipse.emf.emfstore.server.exceptions.ESException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSubEmfstoreInterface {
    private final AbstractEmfstoreInterface parentInterface;
    private ResourceHelper resourceHelper;

    public AbstractSubEmfstoreInterface(AbstractEmfstoreInterface parentInterface) throws FatalESException {
        if (parentInterface == null) {
            throw new FatalESException();
        }
        this.parentInterface = parentInterface;
    }

    protected void initSubInterface() throws FatalESException {
        this.resourceHelper = new ResourceHelper(this.parentInterface.getServerSpace());
    }

    public ResourceHelper getResourceHelper() {
        return this.resourceHelper;
    }

    protected void save(EObject eObject) throws FatalESException {
        this.resourceHelper.save(eObject);
    }

    protected ServerSpace getServerSpace() {
        return this.parentInterface.getServerSpace();
    }

    protected Object getMonitor() {
        return this.parentInterface.getMonitor();
    }

    protected AccessControl getAccessControl() {
        return this.parentInterface.getAccessControl();
    }

    protected <T> T getSubInterface(Class<T> clazz) {
        return this.parentInterface.getSubInterface(clazz);
    }

    public Object execute(Method method, Object[] args) throws ESException {
        try {
            if (method.getParameterTypes().length > 0 && method.getParameterTypes()[0] == SessionId.class) {
                return method.invoke((Object)this, args);
            }
            Object[] argsWoSessionId = new Object[args.length - 1];
            System.arraycopy(args, 1, argsWoSessionId, 0, args.length - 1);
            return method.invoke((Object)this, argsWoSessionId);
        }
        catch (IllegalArgumentException e) {
            ModelUtil.logWarning((String)Messages.AbstractSubEmfstoreInterface_Bad_Parameters, (Throwable)e);
            throw new ESException(e);
        }
        catch (IllegalAccessException e) {
            ModelUtil.logWarning((String)Messages.AbstractSubEmfstoreInterface_Method_Not_Accessible, (Throwable)e);
            throw new ESException(e);
        }
        catch (InvocationTargetException e) {
            if (InvalidVersionSpecException.class.isInstance(e.getTargetException()) || AccessControlException.class.isInstance(e.getTargetException())) {
                ModelUtil.logInfo((String)(String.valueOf(Messages.AbstractSubEmfstoreInterface_Exception_On_Execution) + e.getMessage()));
            } else {
                ModelUtil.logInfo((String)(String.valueOf(Messages.AbstractSubEmfstoreInterface_Exception_On_Execution) + this.stackTraceOf(e)));
            }
            if (e.getTargetException() instanceof ESException) {
                throw (ESException)e.getTargetException();
            }
            throw new ESException(e.getTargetException());
        }
    }

    private String stackTraceOf(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        return sw.toString();
    }

    protected void sanityCheckObjects(Object ... objects) throws InvalidInputException {
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            this.sanityCheckObject(object);
            ++n2;
        }
    }

    private void sanityCheckObject(Object object) throws InvalidInputException {
        if (object == null) {
            throw new InvalidInputException();
        }
    }
}

