/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.runtime.meta;

import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.simulator.runtime.meta.RuntimeStateObjectMeta;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InvalidOptionException;

public class RuntimeStateFilterer {
    private static final Pattern FILTER_PATTERN = Pattern.compile("\\-?[a-zA-Z_*][a-zA-Z0-9_*]*'?(\\.[a-zA-Z_*][a-zA-Z0-9_*]*'?)*");

    private RuntimeStateFilterer() {
    }

    public static List<RuntimeStateObjectMeta> filter(List<RuntimeStateObjectMeta> metas, String filtersTxt, String errorMsgPrefix, String errorMsgAction) {
        String[] filters = StringUtils.split((String)filtersTxt, (String)",");
        int i = 0;
        while (i < filters.length) {
            filters[i] = filters[i].trim();
            if (!FILTER_PATTERN.matcher(filters[i]).matches()) {
                String msg = Strings.fmt((String)"%s filter \"%s\" has invalid syntax.", (Object[])new Object[]{errorMsgPrefix, filters[i]});
                throw new InvalidOptionException(msg);
            }
            ++i;
        }
        if (filters.length == 0) {
            String msg = Strings.fmt((String)"%s filter is empty.", (Object[])new Object[]{errorMsgPrefix});
            throw new InvalidOptionException(msg);
        }
        boolean[] inclusionStatus = new boolean[metas.size()];
        String[] stringArray = filters;
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            Pattern pattern;
            String filter = stringArray[n2];
            boolean inclusion = !filter.startsWith("-");
            String filterPattern = inclusion ? filter : filter.substring(1);
            try {
                pattern = CifTextUtils.getRegExForCifNamePattern((String)filterPattern, (boolean)true);
            }
            catch (IllegalArgumentException ex) {
                throw new RuntimeException("Should never happen, as filter was already checked.", ex);
            }
            boolean match = false;
            boolean effect = false;
            int i2 = 0;
            while (i2 < metas.size()) {
                RuntimeStateObjectMeta meta = metas.get(i2);
                if (pattern.matcher(meta.plainName).matches()) {
                    match = true;
                    boolean modified = inclusionStatus[i2] ^ inclusion;
                    if (modified) {
                        inclusionStatus[i2] = inclusion;
                        effect = true;
                    }
                }
                ++i2;
            }
            if (!match) {
                String msg = Strings.fmt((String)"%s filter \"%s\" does not match any of the state objects.", (Object[])new Object[]{errorMsgPrefix, filter});
                OutputProvider.warn((String)msg);
            } else if (!effect) {
                String msg = Strings.fmt((String)"%s filter \"%s\" has no effect, as it did not %s any state objects %s the filtered result.", (Object[])new Object[]{errorMsgPrefix, filter, inclusion ? "add" : "remove", inclusion ? "to" : "from"});
                OutputProvider.warn((String)msg);
            }
            ++n2;
        }
        int cnt = 0;
        boolean[] blArray = inclusionStatus;
        int n3 = inclusionStatus.length;
        n = 0;
        while (n < n3) {
            boolean inclusion = blArray[n];
            if (inclusion) {
                ++cnt;
            }
            ++n;
        }
        if (cnt == 0) {
            String msg = Strings.fmt((String)"%s filters \"%s\" %smatch no state objects. Nothing will be %s.", (Object[])new Object[]{errorMsgPrefix, filtersTxt, filters.length > 1 ? "together " : "", errorMsgAction});
            OutputProvider.warn((String)msg);
        }
        List rslt = Lists.listc((int)cnt);
        int i3 = 0;
        while (i3 < metas.size()) {
            if (inclusionStatus[i3]) {
                rslt.add(metas.get(i3));
            }
            ++i3;
        }
        return rslt;
    }
}

