/*
 * Decompiled with CFR 0.152.
 */
package com.github.javabdd;

import com.github.javabdd.BDD;
import com.github.javabdd.BDDDomain;
import com.github.javabdd.BDDFactory;
import com.github.javabdd.BDDVarSet;
import com.github.javabdd.JFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.util.StringTokenizer;

public class FindBestOrder {
    static BDDFactory bdd = null;
    boolean newbdd = true;
    BDD b1 = null;
    BDD b2 = null;
    BDDVarSet b3 = null;
    String filename0 = "fbo.bi";
    String filename1 = "fbo.1";
    String filename2 = "fbo.2";
    String filename3 = "fbo.3";
    long DELAY_TIME = Long.parseLong(System.getProperty("fbo.delaytime", "30000"));
    float FACTOR = Float.parseFloat(System.getProperty("fbo.waitfactor", "1.1"));
    BDDFactory.BDDOp op;
    long bestCalcTime;
    long bestTotalTime;
    String bestOrder;
    int nodeTableSize;
    int cacheSize;
    int maxIncrease;
    File f0;
    File f1;
    File f2;
    File f3;

    public FindBestOrder(int nodeTableSize, int cacheSize, int maxIncrease, long bestTime, long delayTime) {
        this.bestCalcTime = bestTime;
        this.bestTotalTime = Long.MAX_VALUE;
        this.nodeTableSize = nodeTableSize;
        this.cacheSize = cacheSize;
        this.maxIncrease = maxIncrease;
        this.DELAY_TIME = delayTime;
    }

    public void init(BDD b1, BDD b2, BDDVarSet dom, BDDFactory.BDDOp op) throws IOException {
        this.op = op;
        this.f0 = File.createTempFile("fbo", "a");
        this.filename0 = this.f0.getAbsolutePath();
        this.f0.deleteOnExit();
        this.f1 = File.createTempFile("fbo", "b");
        this.filename1 = this.f1.getAbsolutePath();
        this.f1.deleteOnExit();
        this.f2 = File.createTempFile("fbo", "c");
        this.filename2 = this.f2.getAbsolutePath();
        this.f2.deleteOnExit();
        this.f3 = File.createTempFile("fbo", "d");
        this.filename3 = this.f3.getAbsolutePath();
        this.f3.deleteOnExit();
        this.writeBDDConfig(b1.getFactory(), this.filename0);
        b1.getFactory().save(this.filename1, b1);
        b2.getFactory().save(this.filename2, b2);
        dom.getFactory().save(this.filename3, dom.toBDD());
    }

    public void cleanup() {
        this.f0.delete();
        this.f1.delete();
        this.f2.delete();
        this.f3.delete();
        if (this.b1 != null) {
            this.b1.free();
        }
        if (this.b2 != null) {
            this.b2.free();
        }
        if (this.b3 != null) {
            this.b3.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBDDConfig(BDDFactory bdd, String fileName) throws IOException {
        try (BufferedWriter dos = null;){
            dos = new BufferedWriter(new FileWriter(fileName));
            for (int i = 0; i < bdd.numberOfDomains(); ++i) {
                BDDDomain d = bdd.getDomain(i);
                dos.write(d.getName() + " " + d.size() + "\n");
            }
        }
    }

    public long tryOrder(boolean reverse, String varOrder) {
        System.gc();
        TryThread t = new TryThread();
        t.reverse = reverse;
        t.varOrderToTry = varOrder;
        t.start();
        try {
            long waitTime = (long)((float)this.bestTotalTime * this.FACTOR) + this.DELAY_TIME;
            if (waitTime < 0L) {
                waitTime = Long.MAX_VALUE;
            }
            t.join(waitTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        t.stop();
        Thread.yield();
        if (t.totalTime == Long.MAX_VALUE) {
            System.out.println("Thread taking too long, aborted.");
            System.out.print("Free memory: " + Runtime.getRuntime().freeMemory());
            this.b1 = null;
            this.b2 = null;
            this.b3 = null;
            bdd = null;
            this.newbdd = true;
            System.gc();
            System.out.println(" bytes -> " + Runtime.getRuntime().freeMemory() + " bytes");
        }
        if (t.time < this.bestCalcTime) {
            this.bestOrder = varOrder;
            this.bestCalcTime = t.time;
            if (t.totalTime < this.bestTotalTime) {
                this.bestTotalTime = t.totalTime;
            }
        }
        return t.time;
    }

    public String getBestOrder() {
        return this.bestOrder;
    }

    public long getBestTime() {
        return this.bestCalcTime;
    }

    public class TryThread
    extends Thread {
        boolean reverse;
        String varOrderToTry;
        long time = Long.MAX_VALUE;
        long totalTime = Long.MAX_VALUE;

        @Override
        public void run() {
            long total = System.currentTimeMillis();
            if (bdd == null) {
                bdd = JFactory.init(FindBestOrder.this.nodeTableSize, FindBestOrder.this.cacheSize);
                bdd.setMaxIncrease(FindBestOrder.this.maxIncrease);
                this.readBDDConfig(bdd);
            }
            int[] varorder = bdd.makeVarOrdering(this.reverse, this.varOrderToTry);
            bdd.setVarOrder(varorder);
            try {
                if (FindBestOrder.this.newbdd) {
                    FindBestOrder.this.b1 = bdd.load(FindBestOrder.this.filename1);
                    FindBestOrder.this.b2 = bdd.load(FindBestOrder.this.filename2);
                    FindBestOrder.this.b3 = bdd.load(FindBestOrder.this.filename3).toVarSet();
                    FindBestOrder.this.newbdd = false;
                }
                long t = System.currentTimeMillis();
                BDD result = FindBestOrder.this.b1.applyEx(FindBestOrder.this.b2, FindBestOrder.this.op, FindBestOrder.this.b3);
                this.time = System.currentTimeMillis() - t;
                result.free();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            System.out.println("Ordering: " + this.varOrderToTry + " time: " + this.time);
            this.totalTime = System.currentTimeMillis() - total;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readBDDConfig(BDDFactory bdd) {
            BufferedReader in = null;
            try {
                String s;
                in = new BufferedReader(new FileReader(FindBestOrder.this.filename0));
                while ((s = in.readLine()) != null) {
                    if (s.equals("")) {
                        break;
                    }
                    StringTokenizer st = new StringTokenizer(s);
                    String name = st.nextToken();
                    long size = Long.parseLong(st.nextToken()) - 1L;
                    this.makeDomain(bdd, name, BigInteger.valueOf(size).bitLength());
                }
            }
            catch (IOException iOException) {
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        BDDDomain makeDomain(BDDFactory bdd, String name, int bits) {
            BDDDomain d = bdd.extDomain(new long[]{1L << bits})[0];
            d.setName(name);
            return d;
        }
    }
}

