/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.cssparser.dom;

import java.io.IOException;
import org.htmlunit.cssparser.dom.AbstractCSSRuleImpl;
import org.htmlunit.cssparser.dom.CSSStyleDeclarationImpl;
import org.htmlunit.cssparser.dom.CSSStyleSheetImpl;
import org.htmlunit.cssparser.dom.DOMExceptionImpl;
import org.htmlunit.cssparser.parser.CSSException;
import org.htmlunit.cssparser.parser.CSSOMParser;
import org.htmlunit.cssparser.util.ParserUtils;
import org.w3c.dom.DOMException;

public class CSSFontFaceRuleImpl
extends AbstractCSSRuleImpl {
    private CSSStyleDeclarationImpl style_;

    public CSSFontFaceRuleImpl(CSSStyleSheetImpl parentStyleSheet, AbstractCSSRuleImpl parentRule) {
        super(parentStyleSheet, parentRule);
    }

    @Override
    public String getCssText() {
        StringBuilder sb = new StringBuilder();
        sb.append("@font-face { ");
        CSSStyleDeclarationImpl style = this.getStyle();
        if (null != style) {
            sb.append(style.getCssText());
            if (style.getProperties().size() > 0) {
                sb.append(";");
            }
        }
        sb.append(" }");
        return sb.toString();
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        try {
            CSSOMParser parser = new CSSOMParser();
            AbstractCSSRuleImpl r = parser.parseRule(cssText);
            if (!(r instanceof CSSFontFaceRuleImpl)) {
                throw new DOMExceptionImpl(13, 7);
            }
            this.style_ = ((CSSFontFaceRuleImpl)r).style_;
        }
        catch (CSSException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
        catch (IOException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
    }

    public CSSStyleDeclarationImpl getStyle() {
        return this.style_;
    }

    public void setStyle(CSSStyleDeclarationImpl style) {
        this.style_ = style;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CSSFontFaceRuleImpl)) {
            return false;
        }
        CSSFontFaceRuleImpl cffr = (CSSFontFaceRuleImpl)obj;
        return super.equals(obj) && ParserUtils.equals(this.getStyle(), cffr.getStyle());
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = ParserUtils.hashCode(hash, this.style_);
        return hash;
    }

    public String toString() {
        return this.getCssText();
    }
}

