/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.runtime.meta;

import java.util.Comparator;
import org.eclipse.escet.cif.simulator.runtime.meta.StateObjectType;
import org.eclipse.escet.common.java.Strings;

public class RuntimeStateObjectMeta {
    public static final RuntimeStateObjectMetaComparator SORTER = new RuntimeStateObjectMetaComparator();
    public final int idx;
    public final StateObjectType type;
    public final String name;
    public final String plainName;

    public RuntimeStateObjectMeta(int idx, StateObjectType type, String name) {
        this.idx = idx;
        this.type = type;
        this.name = name;
        this.plainName = name.replace("$", "");
    }

    public String toString() {
        return Strings.fmt((String)"%s(%s,%d)", (Object[])new Object[]{this.name, this.type, this.idx});
    }

    public static class RuntimeStateObjectMetaComparator
    implements Comparator<RuntimeStateObjectMeta> {
        @Override
        public int compare(RuntimeStateObjectMeta meta1, RuntimeStateObjectMeta meta2) {
            int rslt = Strings.SORTER.compare(meta1.plainName, meta2.plainName);
            if (rslt != 0) {
                return rslt;
            }
            return Strings.SORTER.compare(meta1.name, meta2.name);
        }
    }
}

