/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.common.ide;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.HashSet;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.etrice.core.common.base.BasePackage;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistEntry;
import org.eclipse.xtext.ide.editor.contentassist.IIdeContentProposalAcceptor;
import org.eclipse.xtext.ide.editor.contentassist.IdeContentProposalPriorities;
import org.eclipse.xtext.ide.editor.contentassist.IdeCrossrefProposalProvider;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;

public class ImportAwareCrossrefProposalProvider
extends IdeCrossrefProposalProvider {
    @Inject
    private IdeContentProposalPriorities proposalPriorities;

    public void lookupCrossReference(IScope scope, CrossReference crossReference, ContentAssistContext context, IIdeContentProposalAcceptor acceptor, Predicate<IEObjectDescription> filter) {
        HashSet<String> existingLocalNames = new HashSet<String>();
        HashSet<String> qualifiedNames = new HashSet<String>();
        for (IEObjectDescription candidate : Iterables.filter((Iterable)this.queryScope(scope, crossReference, context), filter)) {
            if (!acceptor.canAcceptMoreProposals()) {
                return;
            }
            String simpleName = candidate.getName().getLastSegment();
            String qualifiedName = this.getQualifiedNameConverter().toString(candidate.getQualifiedName());
            if (!qualifiedNames.add(qualifiedName)) continue;
            String candidateName = this.getQualifiedNameConverter().toString(candidate.getName());
            String proposal = this.canImport(candidate.getEClass()) && !existingLocalNames.contains(simpleName) ? simpleName : candidateName;
            ContentAssistEntry entry = this.getProposalCreator().createProposal(proposal, context, e -> {
                e.setSource((Object)candidate);
                e.setLabel(candidateName);
                e.setDescription(candidate.getEClass() != null ? candidate.getEClass().getName() : null);
                e.setKind("REFERENCE");
            });
            acceptor.accept(entry, this.proposalPriorities.getCrossRefPriority(candidate, entry));
            if (candidate.getName().getSegmentCount() != 1) continue;
            existingLocalNames.add(simpleName);
        }
    }

    protected boolean canImport(EClass clss) {
        return BasePackage.Literals.ANNOTATION_TYPE == clss;
    }
}

