/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.management.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.gemini.management.framework.internal.OSGiBundle;
import org.osgi.framework.Bundle;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

public final class BundleUtil {
    private static final String FRAGMENT_HOST_HEADER = "Fragment-Host";

    public static String[] getBundleExportedPackages(Bundle bundle) {
        BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        if (wiring == null) {
            return new String[0];
        }
        List providedWires = wiring.getProvidedWires("osgi.wiring.package");
        ArrayList<String> packages = new ArrayList<String>();
        for (BundleWire wire : providedWires) {
            String packageName = String.format("%s;%s", wire.getCapability().getAttributes().get("osgi.wiring.package"), wire.getCapability().getAttributes().get("version"));
            if (packages.contains(packageName)) continue;
            packages.add(packageName);
        }
        return packages.toArray(new String[packages.size()]);
    }

    public static String[] getBundleImportedPackages(Bundle bundle) {
        BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        if (wiring == null) {
            return new String[0];
        }
        List requiredWires = wiring.getRequiredWires("osgi.wiring.package");
        ArrayList<String> packages = new ArrayList<String>();
        for (BundleWire requiredWire : requiredWires) {
            String packageName = String.format("%s;%s", requiredWire.getCapability().getAttributes().get("osgi.wiring.package"), requiredWire.getCapability().getAttributes().get("version"));
            if (packages.contains(packageName)) continue;
            packages.add(packageName);
        }
        return packages.toArray(new String[packages.size()]);
    }

    public static String getBundleState(Bundle b) {
        switch (b.getState()) {
            case 32: {
                return "ACTIVE";
            }
            case 2: {
                return "INSTALLED";
            }
            case 4: {
                return "RESOLVED";
            }
            case 8: {
                return "STARTING";
            }
            case 16: {
                return "STOPPING";
            }
            case 1: {
                return "UNINSTALLED";
            }
        }
        return "UNKNOWN";
    }

    public static boolean isBundleFragment(Bundle bundle) {
        BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        if (wiring != null) {
            return (wiring.getRevision().getTypes() & 1) != 0;
        }
        return bundle.getHeaders().get(FRAGMENT_HOST_HEADER) != null;
    }

    public static int getBundleStartLevel(Bundle bundle) {
        BundleStartLevel startLevel = (BundleStartLevel)bundle.adapt(BundleStartLevel.class);
        return startLevel.getStartLevel();
    }

    public static boolean isBundlePersistentlyStarted(Bundle bundle) {
        BundleStartLevel startLevel = (BundleStartLevel)bundle.adapt(BundleStartLevel.class);
        return startLevel.isPersistentlyStarted();
    }

    public static boolean isBundleActivationPolicyUsed(Bundle bundle) {
        BundleStartLevel startLevel = (BundleStartLevel)bundle.adapt(BundleStartLevel.class);
        return startLevel.isActivationPolicyUsed();
    }

    public static Long[] getRequiredBundles(Bundle bundle) throws IOException {
        BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        if (wiring == null) {
            return new Long[0];
        }
        List requiredWires = wiring.getRequiredWires(null);
        return OSGiBundle.bundleWiresToProviderIds(requiredWires);
    }

    public static Long[] getRequiringBundles(Bundle bundle) throws IOException {
        BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        if (wiring == null) {
            return new Long[0];
        }
        List providedWires = wiring.getProvidedWires(null);
        return OSGiBundle.bundleWiresToRequirerIds(providedWires);
    }

    public static boolean isRequired(Bundle bundle) {
        BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        if (wiring != null) {
            return wiring.getProvidedWires(null).size() > 0;
        }
        return false;
    }

    public static boolean isRemovalPending(Bundle bundle) {
        BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        if (wiring != null) {
            return !wiring.isCurrent() && wiring.isInUse();
        }
        return false;
    }
}

