/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.util.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.eclipse.virgo.util.io.JarTransformer;

public final class JarTransformingURLConnection
extends URLConnection {
    private final JarTransformer transformer;
    private final boolean ensureManifestIsPresent;

    public JarTransformingURLConnection(URL url, JarTransformer transformer) {
        this(url, transformer, false);
    }

    public JarTransformingURLConnection(URL url, JarTransformer transformer, boolean ensureManifestIsPresent) {
        super(url);
        this.transformer = transformer;
        this.ensureManifestIsPresent = ensureManifestIsPresent;
    }

    public InputStream getInputStream() throws IOException {
        ByteArrayInputStream byteArrayInputStream;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        InputStream rawInputStream = this.url.openStream();
        try {
            this.transformer.transform(rawInputStream, baos, this.ensureManifestIsPresent);
            byteArrayInputStream = new ByteArrayInputStream(baos.toByteArray());
        }
        catch (Throwable throwable) {
            baos.close();
            try {
                rawInputStream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        baos.close();
        try {
            rawInputStream.close();
        }
        catch (IOException iOException) {}
        return byteArrayInputStream;
    }

    public void connect() throws IOException {
    }
}

