/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.backend.manager.visible;

import fr.inria.aoste.timesquare.trace.util.ReferenceNameBuilder;
import fr.inria.aoste.timesquare.trace.util.adapter.AdapterRegistry;
import fr.inria.aoste.trace.ModelElementReference;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class ClockEntity
implements Comparable<ClockEntity> {
    private final ModelElementReference _modelElementReference;
    private final String _URIfragment;
    private final String name;
    private final String id;

    public ClockEntity(ModelElementReference clock) {
        this._modelElementReference = clock;
        this._URIfragment = AdapterRegistry.getAdapter((EObject)clock).getUID((EObject)clock);
        this.name = ReferenceNameBuilder.buildQualifiedName((ModelElementReference)this._modelElementReference);
        this.id = String.valueOf(this.name) + this._URIfragment;
    }

    private String getURIfragment() {
        return this._URIfragment;
    }

    public EObject getClock() {
        EList refs = this._modelElementReference.getElementRef();
        for (EObject ref : refs) {
            if (!AdapterRegistry.getAdapter((EObject)ref).isClock(ref)) continue;
            return ref;
        }
        return null;
    }

    public ModelElementReference getModelElementReference() {
        return this._modelElementReference;
    }

    public final String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return String.valueOf(this.getName()) + " " + this.getURIfragment();
    }

    public String toString() {
        return this.getName();
    }

    public List<EObject> getReferencedElement() {
        return AdapterRegistry.getAdapter((EObject)this._modelElementReference).fillWithReferencedElements((EObject)this._modelElementReference, null);
    }

    public boolean equals(Object o) {
        block5: {
            if (o != this) break block5;
            return true;
        }
        try {
            if (o instanceof ClockEntity) {
                ClockEntity ce = (ClockEntity)o;
                if (this.modelElementReferenceEquality(ce._modelElementReference, this._modelElementReference)) {
                    return true;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private boolean modelElementReferenceEquality(ModelElementReference mer1, ModelElementReference mer2) {
        if (mer1 == mer2) {
            return true;
        }
        if (mer1.getElementRef().size() != mer2.getElementRef().size()) {
            return false;
        }
        int i = 0;
        while (i < mer1.getElementRef().size()) {
            if (mer1.getElementRef().get(i) != mer2.getElementRef().get(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int n = this.name != null ? this.name.hashCode() : 0;
        int c = this.id != null ? this.id.hashCode() : 0;
        return n + c;
    }

    @Override
    public int compareTo(ClockEntity arg0) {
        return this.name.compareTo(arg0.name);
    }
}

