/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler.ast;

import org.aspectj.ajdt.internal.compiler.ast.PseudoToken;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.Parser;
import org.aspectj.weaver.IHasPosition;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.patterns.BasicTokenSource;
import org.aspectj.weaver.patterns.Declare;
import org.aspectj.weaver.patterns.IToken;
import org.aspectj.weaver.patterns.ITokenSource;
import org.aspectj.weaver.patterns.ParserException;
import org.aspectj.weaver.patterns.PatternParser;
import org.aspectj.weaver.patterns.PerClause;
import org.aspectj.weaver.patterns.PerSingleton;
import org.aspectj.weaver.patterns.Pointcut;
import org.aspectj.weaver.patterns.TypePattern;

public class PseudoTokens
extends ASTNode {
    BasicTokenSource tokenSource;
    PseudoToken[] tokens;
    String endToken;

    public PseudoTokens(PseudoToken[] tokens, ISourceContext sourceContext) {
        this.tokens = tokens;
        this.tokenSource = new BasicTokenSource((IToken[])tokens, sourceContext);
        this.endToken = tokens[tokens.length - 1].getString();
        this.sourceStart = tokens[0].sourceStart;
        this.sourceEnd = tokens[tokens.length - 2].sourceEnd;
    }

    public Pointcut parsePointcut(Parser parser) {
        PatternParser patternParser = new PatternParser((ITokenSource)this.tokenSource);
        try {
            Pointcut ret = patternParser.parsePointcut();
            this.checkEof(parser);
            return ret;
        }
        catch (ParserException pe) {
            this.reportError(parser, pe);
            return Pointcut.makeMatchesNothing((Pointcut.State)Pointcut.SYMBOLIC);
        }
    }

    private void checkEof(Parser parser) {
        IToken last = this.tokenSource.next();
        if (this.tokenSource.next() != IToken.EOF) {
            parser.problemReporter().parseError(last.getStart(), last.getEnd(), 2, last.getString().toCharArray(), last.getString(), new String[]{this.endToken});
        }
    }

    private void reportError(Parser parser, ParserException pe) {
        int end;
        int start;
        IHasPosition tok = pe.getLocation();
        if (tok == IToken.EOF) {
            start = this.sourceEnd + 1;
            end = this.sourceEnd + 1;
        } else {
            start = tok.getStart();
            end = tok.getEnd();
        }
        String found = "<unknown>";
        if (tok instanceof IToken) {
            found = ((IToken)tok).getString();
        }
        parser.problemReporter().parseError(start, end, 2, found.toCharArray(), found, new String[]{pe.getMessage()});
    }

    public TypePattern maybeParseDominatesPattern(Parser parser) {
        PatternParser patternParser = new PatternParser((ITokenSource)this.tokenSource);
        try {
            if (patternParser.maybeEatIdentifier("dominates")) {
                return patternParser.parseTypePattern();
            }
            return null;
        }
        catch (ParserException pe) {
            this.reportError(parser, pe);
            return null;
        }
    }

    public PerClause parsePerClause(Parser parser) {
        PatternParser patternParser = new PatternParser((ITokenSource)this.tokenSource);
        try {
            PerClause ret = patternParser.maybeParsePerClause();
            this.checkEof(parser);
            if (ret == null) {
                return new PerSingleton();
            }
            return ret;
        }
        catch (ParserException pe) {
            this.reportError(parser, pe);
            return new PerSingleton();
        }
    }

    public Declare parseDeclare(Parser parser) {
        PatternParser patternParser = new PatternParser((ITokenSource)this.tokenSource);
        try {
            Declare ret = patternParser.parseDeclare();
            this.checkEof(parser);
            return ret;
        }
        catch (ParserException pe) {
            this.reportError(parser, pe);
            return null;
        }
    }

    public Declare parseAnnotationDeclare(Parser parser) {
        PatternParser patternParser = new PatternParser((ITokenSource)this.tokenSource);
        try {
            Declare ret = patternParser.parseDeclareAnnotation();
            this.checkEof(parser);
            return ret;
        }
        catch (ParserException pe) {
            this.reportError(parser, pe);
            return null;
        }
    }

    public void postParse(TypeDeclaration typeDec, MethodDeclaration enclosingDec) {
        int counter = 0;
        int len = this.tokens.length;
        for (int i = 0; i < len; ++i) {
            counter += this.tokens[i].postParse(typeDec, enclosingDec, counter);
        }
    }

    @Override
    public StringBuffer print(int indent, StringBuffer output) {
        output.append(this.tokenSource.toString());
        return output;
    }
}

