/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.core.compiler;

import java.util.Arrays;
import java.util.BitSet;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.ScannerHelper;

class SubwordMatcher {
    private static final int[] EMPTY_REGIONS = new int[0];
    private final char[] name;
    private final BitSet wordBoundaries;

    public SubwordMatcher(String name) {
        this.name = name.toCharArray();
        this.wordBoundaries = new BitSet(name.length());
        BoundaryState state = BoundaryState.SEPARATOR;
        int i = 0;
        while (i < this.name.length) {
            char c = this.name[i];
            if (state.isWordBoundary(c)) {
                this.wordBoundaries.set(i);
            }
            state = state.next(c);
            ++i;
        }
    }

    public int[] getMatchingRegions(String pattern) {
        int segmentStart = 0;
        int[] segments = EMPTY_REGIONS;
        int iName = -1;
        int iPatternWordStart = 0;
        int iPattern = 0;
        while (iPattern < pattern.length()) {
            char nameChar;
            if (++iName == this.name.length) {
                return null;
            }
            char patternChar = pattern.charAt(iPattern);
            if (patternChar != (nameChar = this.name[iName]) && (this.isWordBoundary(iName) || !this.equalsIgnoreCase(patternChar, nameChar))) {
                int next;
                int wordStart;
                if (iName > segmentStart) {
                    segments = Arrays.copyOf(segments, segments.length + 2);
                    segments[segments.length - 2] = segmentStart;
                    segments[segments.length - 1] = iName - segmentStart;
                }
                if ((wordStart = this.indexOfWordStart(iName, patternChar)) < 0 && (next = this.indexOfWordStart(iName, pattern.charAt(iPatternWordStart))) > 0) {
                    wordStart = next;
                    iPattern = iPatternWordStart;
                    segments = Arrays.copyOfRange(segments, 0, segments.length - 2);
                }
                if (wordStart < 0) {
                    return null;
                }
                segmentStart = wordStart;
                iName = wordStart;
                iPatternWordStart = iPattern;
            }
            ++iPattern;
        }
        segments = Arrays.copyOf(segments, segments.length + 2);
        segments[segments.length - 2] = segmentStart;
        segments[segments.length - 1] = iName - segmentStart + 1;
        return segments;
    }

    private int indexOfWordStart(int nameStart, char patternChar) {
        int iName = nameStart;
        while (iName < this.name.length) {
            char nameChar = this.name[iName];
            if (this.isWordBoundary(iName) && this.equalsIgnoreCase(nameChar, patternChar)) {
                return iName;
            }
            if (!ScannerHelper.isJavaIdentifierPart(nameChar)) {
                return -1;
            }
            ++iName;
        }
        return -1;
    }

    private boolean equalsIgnoreCase(char a, char b) {
        return ScannerHelper.toLowerCase(a) == ScannerHelper.toLowerCase(b);
    }

    private boolean isWordBoundary(int iName) {
        return this.wordBoundaries.get(iName);
    }

    private static enum BoundaryState {
        SEPARATOR{

            @Override
            public BoundaryState next(char c) {
                if (c == '_') {
                    return SEPARATOR;
                }
                return ScannerHelper.isUpperCase(c) ? CAPS_WORD : WORD;
            }

            @Override
            public boolean isWordBoundary(char c) {
                return true;
            }
        }
        ,
        WORD{

            @Override
            public BoundaryState next(char c) {
                if (c == '_') {
                    return SEPARATOR;
                }
                return WORD;
            }

            @Override
            public boolean isWordBoundary(char c) {
                return ScannerHelper.isUpperCase(c);
            }
        }
        ,
        CAPS_WORD{

            @Override
            public BoundaryState next(char c) {
                if (c == '_') {
                    return SEPARATOR;
                }
                return ScannerHelper.isUpperCase(c) ? CAPS_WORD : WORD;
            }

            @Override
            public boolean isWordBoundary(char c) {
                return this.next(c) == SEPARATOR;
            }
        };


        public abstract boolean isWordBoundary(char var1);

        public abstract BoundaryState next(char var1);
    }
}

